/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.sys.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.sys.persistence.dao.AppTagsRelationDao;
import com.hotent.sys.persistence.manager.AppTagsRelationManager;
import com.hotent.sys.persistence.manager.SysTagManager;
import com.hotent.sys.persistence.manager.SysTypeManager;
import com.hotent.sys.persistence.model.AppTagsRelation;
import com.hotent.sys.persistence.model.SysTag;
import com.hotent.sys.persistence.model.SysType;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AppTagsRelationManagerImpl
extends BaseManagerImpl<AppTagsRelationDao, AppTagsRelation>
implements AppTagsRelationManager {
    @Resource
    SysTypeManager sysTypeManager;
    @Resource
    SysTagManager sysTagManager;

    @Override
    @Transactional
    public void saveAppTags(String appId, String tagIds) {
        String[] ids;
        HashMap<String, String> conditionMap = new HashMap<String, String>();
        conditionMap.put("APP_ID_", appId);
        ((AppTagsRelationDao)this.baseMapper).deleteByMap(conditionMap);
        for (String tagId : ids = tagIds.split(",")) {
            AppTagsRelation rel = new AppTagsRelation();
            rel.setAppId(appId);
            rel.setTagId(tagId);
            ((AppTagsRelationDao)this.baseMapper).insert((Object)rel);
        }
    }

    @Override
    public List<AppTagsRelation> getByAppId(String appId) {
        List<AppTagsRelation> relations = ((AppTagsRelationDao)this.baseMapper).getRelationByAppId(appId);
        return relations.stream().filter(relation -> StringUtil.isNotEmpty((String)relation.getTagName())).collect(Collectors.toList());
    }

    @Override
    public Set<String> getAppIdsByTagIds(String[] tagIds) {
        return ((AppTagsRelationDao)this.baseMapper).getAppIdsByTagIds(tagIds).stream().collect(Collectors.toSet());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveAppTagRelations(String appId, List<SysTag> sysTagList) {
        if (BeanUtils.isNotEmpty(sysTagList)) {
            for (SysTag sysTag : sysTagList) {
                SysType sysType = this.sysTypeManager.getByTypeKeyAndGroupKey("TAG", sysTag.getTypeKey());
                if (sysType == null) continue;
                SysTag existSysTag = null;
                LambdaQueryWrapper tagWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysTag::getKey, (Object)sysTag.getKey());
                List existSysTags = this.sysTagManager.list((Wrapper)tagWrapper);
                if (BeanUtils.isNotEmpty((Object)existSysTags)) {
                    existSysTag = (SysTag)((Object)existSysTags.get(0));
                }
                String tagId = UniqueIdUtil.getSuid();
                if (BeanUtils.isNotEmpty(existSysTag)) {
                    tagId = existSysTag.getId();
                } else {
                    sysTag.setId(tagId);
                    sysTag.setTypeId(sysType.getId());
                    this.sysTagManager.save((Object)sysTag);
                }
                String relationId = UniqueIdUtil.getSuid();
                AppTagsRelation appTagsRelation = new AppTagsRelation();
                appTagsRelation.setId(relationId);
                appTagsRelation.setAppId(appId);
                appTagsRelation.setTagId(tagId);
                this.save((Object)appTagsRelation);
            }
        }
    }
}

