/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.sys.persistence.manager.impl;

import cn.hutool.core.map.MapUtil;
import cn.hutool.core.util.ReUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.google.common.collect.Maps;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.id.IdGenerator;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.sys.constants.CategoryConstants;
import com.hotent.sys.persistence.dao.DataDictDao;
import com.hotent.sys.persistence.manager.DataDictManager;
import com.hotent.sys.persistence.manager.SysTypeManager;
import com.hotent.sys.persistence.model.DataDict;
import com.hotent.sys.persistence.model.SysType;
import com.hotent.sys.vo.DataDictExcelVo;
import com.hotent.uc.api.impl.util.ContextUtil;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Workbook;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import poi.util.ExcelUtil;

@Service(value="dataDictManager")
public class DataDictManagerImpl
extends BaseManagerImpl<DataDictDao, DataDict>
implements DataDictManager {
    @Resource
    SysTypeManager sysTypeManager;
    @Resource
    IdGenerator idGenerator;
    @Resource
    DataDictManager dataDictManager;
    @Resource
    UCFeignService ucFeignService;

    @Override
    public List<DataDict> getByTypeId(String typeId) {
        return ((DataDictDao)this.baseMapper).getByTypeId(typeId);
    }

    @Override
    public DataDict getByDictKey(String typeId, String key) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(StringUtil.isNotEmpty((String)typeId), DataDict::getTypeId, (Object)typeId)).eq(StringUtil.isNotEmpty((String)key), DataDict::getKey, (Object)key);
        return (DataDict)((Object)((DataDictDao)this.baseMapper).selectOne((Wrapper)wrapper));
    }

    @Override
    public PageList<DataDict> listJson(QueryFilter<DataDict> queryFilter) {
        List rows;
        Set userIds;
        PageList result = super.query(queryFilter);
        if (BeanUtils.isNotEmpty((Object)result.getRows()) && BeanUtils.isNotEmpty(userIds = (rows = result.getRows()).stream().filter(row -> StringUtil.isNotEmpty((String)row.getCreateBy())).map(DataDict::getCreateBy).collect(Collectors.toSet()))) {
            ArrayNode arrayNode = this.ucFeignService.getUserByIds(StringUtil.join(userIds));
            HashMap userMap = Maps.newHashMap();
            arrayNode.forEach(item -> {
                String id = JsonUtil.getStringIgnoreKey((JsonNode)item, (String)"id", null);
                String fullname = JsonUtil.getStringIgnoreKey((JsonNode)item, (String)"fullname", (String)"");
                if (id != null) {
                    userMap.put(id, fullname);
                }
            });
            rows.forEach(row -> {
                if (userMap.containsKey(row.getCreateBy())) {
                    row.setCreateName((String)userMap.get(row.getCreateBy()));
                }
            });
        }
        return result;
    }

    @Override
    public List<DataDict> queryDictLikeName(String name) {
        return ((DataDictDao)this.baseMapper).queryDictLikeName(name);
    }

    @Override
    public void importCheck(List<DataDict> dataDictionaries, Consumer<DataDict> consumer) throws IOException {
        for (DataDict dataDict : dataDictionaries) {
            HashMap param = MapUtil.of((Object)"key", (Object)dataDict.getKey());
            DataDict byDictKey = ((DataDictDao)this.baseMapper).getByDictKey(param);
            if (byDictKey != null) {
                consumer.accept(byDictKey);
            }
            for (Object child : dataDict.getChildren()) {
                DataDict dict = (DataDict)((Object)JsonUtil.toBean((JsonNode)JsonUtil.toJsonNode(child), DataDict.class));
                HashMap params = MapUtil.of((Object)"key", (Object)dict.getKey());
                DataDict exist = ((DataDictDao)this.baseMapper).getByDictKey(params);
                if (exist == null) continue;
                consumer.accept(exist);
            }
        }
    }

    @Override
    public List<DataDict> getDictionaries(List<String> list) {
        if (BeanUtils.isEmpty(list)) {
            return new ArrayList<DataDict>();
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().in(DataDict::getKey, list);
        List dataDictList = this.list((Wrapper)wrapper);
        return dataDictList.stream().peek(dict -> {
            LambdaQueryWrapper tWrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(DataDict::getParentId, (Object)dict.getId());
            List children = this.list((Wrapper)tWrapper);
            dict.setChildren(children);
        }).collect(Collectors.toList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void importData(List<DataDict> dataDictList, String status, String typeId) throws Exception {
        for (DataDict dataDict : dataDictList) {
            this.saveOrUpdateDict(dataDict, status, typeId, typeId);
            for (Object child : dataDict.getChildren()) {
                DataDict dataDict1 = (DataDict)((Object)JsonUtil.toBean((JsonNode)JsonUtil.toJsonNode(child), DataDict.class));
                this.saveOrUpdateDict(dataDict1, status, typeId, dataDict.getId());
            }
        }
    }

    @Override
    public List<DataDict> getByTypeKeyForComBo(String typeKey) {
        if (StringUtil.isEmpty((String)typeKey)) {
            return null;
        }
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(StringUtil.isNotEmpty((String)typeKey), DataDict::getKey, (Object)typeKey)).and(w -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w.last("parent_id_ = type_id_");
        });
        DataDict byDictKey = (DataDict)((Object)this.getOne((Wrapper)wrapper));
        List<DataDict> list = this.getChildrenByParentId(byDictKey.getId());
        return BeanUtils.listToTree(list);
    }

    private void saveOrUpdateDict(DataDict dataDict, String status, String typeId, String parentId) {
        if (dataDict == null) {
            return;
        }
        LambdaQueryWrapper wrapper = StringUtil.isNotEmpty((String)dataDict.getParentId()) && dataDict.getParentId().equals(dataDict.getTypeId()) ? (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(DataDict::getKey, (Object)dataDict.getKey())).and(w -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w.last("type_id_ = parent_id_");
        }) : (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(DataDict::getParentId, (Object)parentId)).eq(DataDict::getKey, (Object)dataDict.getKey());
        DataDict dict = (DataDict)((Object)this.getOne((Wrapper)wrapper));
        if (BeanUtils.isEmpty((Object)((Object)dict))) {
            dataDict.setId(UniqueIdUtil.getSuid());
            dataDict.setTypeId(typeId);
            dataDict.setParentId(parentId);
            dataDict.setCreateBy(ContextUtil.getCurrentUserId());
            dataDict.setCreateTime(LocalDateTime.now());
            this.create((Model)dataDict);
        } else {
            dataDict.setId(dict.getId());
            if ("cover".equals(status)) {
                dataDict.setTypeId(typeId);
                dataDict.setParentId(parentId);
                dataDict.setCreateBy(dict.getCreateBy());
                dataDict.setCreateTime(dict.getCreateTime());
                this.update((Model)dataDict);
            }
        }
    }

    public void removeByIds(String ... ids) {
        if (BeanUtils.isNotEmpty((Object)ids)) {
            for (String id : ids) {
                this.remove((Serializable)((Object)id));
                List<DataDict> childs = this.getChildrenByParentId(id);
                for (DataDict dict : childs) {
                    this.remove((Serializable)((Object)dict.getId()));
                }
            }
        }
        super.removeByIds(ids);
    }

    @Override
    public List<DataDict> getFirstChilsByParentId(String id) {
        return ((DataDictDao)this.baseMapper).getByParentId(id);
    }

    @Override
    public List<DataDict> getChildrenByParentId(String id) {
        List<DataDict> childs = ((DataDictDao)this.baseMapper).getByParentId(id);
        return this.getChilds(childs);
    }

    private List<DataDict> getChilds(List<DataDict> childs) {
        ArrayList<DataDict> dataDict = new ArrayList<DataDict>();
        if (BeanUtils.isNotEmpty(childs)) {
            for (DataDict dict : childs) {
                List<DataDict> children = ((DataDictDao)this.baseMapper).getByParentId(dict.getId());
                if (!BeanUtils.isNotEmpty(children)) continue;
                children = this.getChilds(children);
                dataDict.addAll(children);
            }
            dataDict.addAll(childs);
        }
        return dataDict;
    }

    @Override
    public void delByDictTypeId(String dictTypeId) {
        ((DataDictDao)this.baseMapper).delByDictTypeId(dictTypeId);
    }

    @Override
    public void updSn(String dicId, int sn) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", dicId);
        params.put("sn", sn);
        ((DataDictDao)this.baseMapper).updSn(params);
    }

    @Override
    public CommonResult<String> removeByTypeIds(String typeIds) {
        if (StringUtil.isNotEmpty((String)typeIds)) {
            List<SysType> typeList = this.sysTypeManager.getChildByTypeId(typeIds);
            String[] typeIdList = new String[typeList.size() + 1];
            typeIdList[0] = typeIds;
            for (int i = 0; i < typeList.size(); ++i) {
                typeIdList[i + 1] = typeList.get(i).getId();
            }
            this.sysTypeManager.removeByIds(typeIdList);
            for (String typeId : typeIdList) {
                ((DataDictDao)this.baseMapper).delByDictTypeId(typeId);
            }
        }
        return new CommonResult("\u64cd\u4f5c\u6210\u529f");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean importData(List<MultipartFile> files, String typeId) throws Exception {
        QueryWrapper wrapper = (QueryWrapper)new QueryWrapper().orderByDesc((Object)"sn_");
        List allList = this.list((Wrapper)wrapper);
        int sn = 0;
        if (BeanUtils.isNotEmpty((Object)allList) && ((DataDict)((Object)allList.get(0))).getSn() != null) {
            sn = ((DataDict)((Object)allList.get(0))).getSn();
        }
        Iterator<MultipartFile> it = files.iterator();
        HashMap<String, DataDict> data = new HashMap<String, DataDict>();
        SysType sysType = (SysType)this.sysTypeManager.get((Serializable)((Object)typeId));
        if (BeanUtils.isEmpty((Object)((Object)sysType))) {
            throw new BaseException("\u8bf7\u9009\u62e9\u6570\u636e\u5b57\u5178\u5206\u7c7b\u8fdb\u884c\u5bfc\u5165");
        }
        while (it.hasNext()) {
            MultipartFile file = it.next();
            List list = ExcelUtil.readExcel(DataDictExcelVo.class, (MultipartFile)file);
            LinkedList<DataDict> dataDictBuffer = new LinkedList<DataDict>();
            for (DataDictExcelVo vo : list) {
                this.checkDict(vo);
                if (StringUtil.isNotEmpty((String)vo.getName()) && vo.getName().length() > 40) {
                    throw new BaseException(String.format("\u5b57\u5178\u9879[%s]\u8d85\u8fc7\u957f\u5ea640\uff01", vo.getName()));
                }
                DataDict dataDict = new DataDict();
                dataDict.setTypeId(typeId);
                if (StringUtil.isEmpty((String)vo.getPidKey())) {
                    dataDict.setParentId(typeId);
                } else {
                    DataDict parentDict = (DataDict)((Object)this.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(DataDict::getTypeId, (Object)typeId)).eq(DataDict::getKey, (Object)vo.getPidKey())));
                    if (BeanUtils.isEmpty((Object)((Object)parentDict))) {
                        DataDict dmDict = (DataDict)((Object)data.get(vo.getPidKey()));
                        if (BeanUtils.isEmpty((Object)((Object)dmDict))) {
                            if (this.isParentKeyInList(vo.getPidKey(), list)) {
                                dataDict.setParentId(vo.getPidKey());
                                dataDict.setKey(vo.getKey());
                                dataDict.setName(vo.getName());
                                dataDictBuffer.add(dataDict);
                                continue;
                            }
                            throw new BaseException("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u7236\u8282\u70b9key");
                        }
                        dataDict.setParentId(dmDict.getId());
                    } else {
                        dataDict.setParentId(parentDict.getId());
                    }
                }
                dataDict.setKey(vo.getKey());
                dataDict.setName(vo.getName());
                DataDict dict = this.getDict(dataDict);
                if (dict != null) {
                    return false;
                }
                dataDict.setSn(++sn);
                dataDict.setCreateBy(ContextUtil.getCurrentUserId());
                dataDict.setCreateTime(LocalDateTime.now());
                this.create((Model)dataDict);
                data.put(vo.getKey(), dataDict);
            }
            this.handleSaveBuffer(dataDictBuffer, data);
        }
        return true;
    }

    @Override
    public Map<String, Object> edit(String id, Integer isAdd, Integer isRoot) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("isAdd", isAdd);
        DataDict dataDict = null;
        if (isRoot == 1 && isAdd == 1) {
            map.put("typeId", id);
            map.put("parentId", id);
            return map;
        }
        if (isAdd == 1 && StringUtil.isNotEmpty((String)id)) {
            map.put("parentId", id);
            dataDict = (DataDict)this.get((Serializable)((Object)id));
            map.put("typeId", dataDict.getTypeId());
            return map;
        }
        if (StringUtil.isNotEmpty((String)id)) {
            dataDict = (DataDict)this.get((Serializable)((Object)id));
            map.put("dataDict", (Object)dataDict);
            return map;
        }
        return map;
    }

    @Override
    public List<DataDict> getDataDict(SysType dictType, Boolean tileNeedRoot) throws Exception {
        if (BeanUtils.isEmpty((Object)((Object)dictType))) {
            return null;
        }
        String typeId = dictType.getId();
        List<DataDict> dataDictList = this.getByTypeId(typeId);
        ArrayList<DataDict> list = new ArrayList<DataDict>();
        for (DataDict entity : dataDictList) {
            DataDict dataDicts = new DataDict();
            dataDicts = entity;
            dataDicts.setOpen("true");
            List<DataDict> listDataDict = this.getFirstChilsByParentId(dataDicts.getId());
            if (listDataDict != null && listDataDict.size() == 0) {
                dataDicts.setIsParent("false");
            }
            list.add(dataDicts);
        }
        if (tileNeedRoot.booleanValue()) {
            DataDict dict = new DataDict();
            dict.setId(dictType.getId());
            dict.setParentId("-1");
            dict.setName(dictType.getName());
            dict.setTypeId(typeId);
            dict.setKey(dictType.getTypeKey());
            dict.setOpen("true");
            list.add(dict);
        }
        return list;
    }

    @Override
    public CommonResult<String> saveDataDict(DataDict dataDict) throws Exception {
        String id = dataDict.getId();
        try {
            if (StringUtil.isEmpty((String)id)) {
                DataDict one = this.getDict(dataDict);
                if (one != null) {
                    return new CommonResult(false, "\u8be5\u5b57\u5178\u9879\u503c\u5df2\u7ecf\u5b58\u5728");
                }
                dataDict.setId(this.idGenerator.getSuid());
                dataDict.setCreateTime(LocalDateTime.now());
                QueryWrapper wrapper = (QueryWrapper)new QueryWrapper().orderByDesc((Object)"sn_");
                List list = this.list((Wrapper)wrapper);
                if (BeanUtils.isNotEmpty((Object)list) && ((DataDict)((Object)list.get(0))).getSn() != null) {
                    dataDict.setSn(((DataDict)((Object)list.get(0))).getSn() + 1);
                } else {
                    dataDict.setSn(0);
                }
                dataDict.setCreateBy(ContextUtil.getCurrentUserId());
                this.create((Model)dataDict);
            } else {
                DataDict dict;
                if (!((DataDict)this.get((Serializable)((Object)id))).getKey().equals(dataDict.getKey()) && (dict = this.getByDictKey("", dataDict.getKey())) != null) {
                    return new CommonResult(false, "\u8be5\u5b57\u5178\u9879\u503c\u5df2\u7ecf\u5b58\u5728");
                }
                this.update((Model)dataDict);
            }
            return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u4fdd\u5b58\u5931\u8d25");
        }
    }

    private DataDict getDict(DataDict dataDict) {
        DataDict one;
        if (dataDict.getTypeId().equals(dataDict.getParentId())) {
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(DataDict::getKey, (Object)dataDict.getKey())).and(w -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)w.last("type_id_ = parent_id_");
            });
            one = (DataDict)((Object)this.getOne((Wrapper)wrapper));
        } else {
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(DataDict::getKey, (Object)dataDict.getKey())).eq(DataDict::getTypeId, (Object)dataDict.getTypeId())).eq(DataDict::getParentId, (Object)dataDict.getParentId());
            one = (DataDict)((Object)this.getOne((Wrapper)wrapper));
        }
        return one;
    }

    @Override
    public CommonResult<String> sort(String[] dicIds) throws Exception {
        try {
            if (BeanUtils.isNotEmpty((Object)dicIds)) {
                for (int i = 0; i < dicIds.length; ++i) {
                    String dicId = dicIds[i];
                    int sn = i + 1;
                    this.updSn(dicId, sn);
                }
            }
        }
        catch (Exception e) {
            return new CommonResult(false, "\u6392\u5e8f\u5931\u8d25");
        }
        return new CommonResult(true, "\u6392\u5e8f\u6210\u529f");
    }

    @Override
    public Map<String, Object> getMoibleComBoByTypeKey(String typeKey) throws Exception {
        if (StringUtil.isEmpty((String)typeKey)) {
            return null;
        }
        SysType dictType = this.sysTypeManager.getByTypeKeyAndGroupKey(CategoryConstants.CAT_DIC.key(), typeKey);
        List<DataDict> list = this.getDataDict(dictType, false);
        List rtnList = BeanUtils.listToTree(list);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataDictList", rtnList);
        map.put("dictType", (Object)dictType);
        return map;
    }

    @Override
    public void export(String typeId, String dictId, HttpServletResponse response) throws Exception {
        SysType sysType = (SysType)this.sysTypeManager.get((Serializable)((Object)typeId));
        List dataDict = null;
        if (StringUtil.isNotEmpty((String)dictId)) {
            QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"id_", (Object)dictId)).or()).eq((Object)"parent_id_", (Object)dictId);
            dataDict = this.list((Wrapper)wrapper);
        } else {
            dataDict = this.dataDictManager.getDataDict(sysType, false);
        }
        LinkedHashMap<String, String> exportMap = new LinkedHashMap<String, String>();
        exportMap.put("parentKey", "\u7236\u8282\u70b9\u9879\u503c");
        exportMap.put("typeKey", "\u5206\u7c7bkey");
        exportMap.put("typeName", "\u5206\u7c7b\u540d\u79f0");
        ArrayList list = new ArrayList();
        for (DataDict dict : dataDict) {
            if (StringUtil.isEmpty((String)dict.getKey())) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("parentKey", this.getKeyFromList(dict.getParentId(), dataDict));
            map.put("typeKey", dict.getKey());
            map.put("typeName", dict.getName());
            list.add(map);
        }
        HSSFWorkbook exportFile = ExcelUtil.exportExcel((String)"\u6570\u636e\u5b57\u5178", (int)dataDict.size(), exportMap, list);
        ExcelUtil.downloadExcel((Workbook)exportFile, (String)"\u5b57\u5178\u5bfc\u51fa", (HttpServletResponse)response);
    }

    @Override
    public CommonResult<String> importDataConfirm(List<MultipartFile> files, String status, String typeId) {
        QueryWrapper wrapper = (QueryWrapper)new QueryWrapper().orderByDesc((Object)"sn_");
        List allList = this.list((Wrapper)wrapper);
        int sn = 0;
        if (BeanUtils.isNotEmpty((Object)allList) && ((DataDict)((Object)allList.get(0))).getSn() != null) {
            sn = ((DataDict)((Object)allList.get(0))).getSn();
        }
        Iterator<MultipartFile> it = files.iterator();
        HashMap<String, DataDict> data = new HashMap<String, DataDict>();
        SysType sysType = (SysType)this.sysTypeManager.get((Serializable)((Object)typeId));
        if (BeanUtils.isEmpty((Object)((Object)sysType))) {
            throw new BaseException("\u8bf7\u9009\u62e9\u6570\u636e\u5b57\u5178\u5206\u7c7b\u8fdb\u884c\u5bfc\u5165");
        }
        while (it.hasNext()) {
            MultipartFile file = it.next();
            List list = ExcelUtil.readExcel(DataDictExcelVo.class, (MultipartFile)file);
            LinkedList<DataDict> dataDictBuffer = new LinkedList<DataDict>();
            for (DataDictExcelVo vo : list) {
                DataDict dataDict = new DataDict();
                dataDict.setTypeId(typeId);
                if (StringUtil.isEmpty((String)vo.getPidKey())) {
                    dataDict.setParentId(typeId);
                } else {
                    DataDict parentDict = (DataDict)((Object)this.getOne((Wrapper)Wrappers.lambdaQuery().eq(DataDict::getKey, (Object)vo.getPidKey())));
                    if (BeanUtils.isEmpty((Object)((Object)parentDict))) {
                        DataDict dmDict = (DataDict)((Object)data.get(vo.getPidKey()));
                        if (BeanUtils.isEmpty((Object)((Object)dmDict))) {
                            if (this.isParentKeyInList(vo.getPidKey(), list)) {
                                dataDict.setParentId(vo.getPidKey());
                                dataDict.setKey(vo.getKey());
                                dataDict.setName(vo.getName());
                                dataDictBuffer.add(dataDict);
                                continue;
                            }
                            throw new BaseException("\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u7236\u8282\u70b9key");
                        }
                        dataDict.setParentId(dmDict.getId());
                    } else {
                        dataDict.setParentId(parentDict.getId());
                    }
                }
                dataDict.setKey(vo.getKey());
                dataDict.setName(vo.getName());
                DataDict dict = this.getDict(dataDict);
                if (dict != null && "jump".equals(status)) continue;
                this.checkDict(vo);
                if (dict != null && "cover".equals(status)) {
                    dataDict.setId(dict.getId());
                    dataDict.setSn(dict.getSn());
                    dataDict.setCreateBy(dict.getCreateBy());
                    dataDict.setCreateTime(dict.getCreateTime());
                    this.updateById((Object)dataDict);
                } else {
                    dataDict.setSn(++sn);
                    dataDict.setCreateBy(ContextUtil.getCurrentUserId());
                    dataDict.setCreateTime(LocalDateTime.now());
                    this.create((Model)dataDict);
                }
                data.put(vo.getKey(), dataDict);
            }
            this.handleSaveBuffer(dataDictBuffer, data);
        }
        return new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
    }

    private void checkDict(DataDictExcelVo vo) {
        if (StringUtil.isNotEmpty((String)vo.getKey())) {
            if (vo.getKey().length() > 40) {
                throw new BaseException(String.format("\u5b57\u5178\u522b\u540d[%s]\u8d85\u8fc7\u957f\u5ea640\uff01", vo.getKey()));
            }
            boolean matched = ReUtil.isMatch((String)"^(?!_)[a-zA-Z0-9_\u4e00-\u9fa5]+$", (CharSequence)vo.getKey());
            if (!matched) {
                throw new BaseException(String.format("\u5b57\u5178\u522b\u540d[%s]\u53ea\u80fd\u8f93\u5165\u6c49\u5b57\u3001\u5b57\u6bcd\u3001\u6570\u5b57\u3001\u4e0b\u5212\u7ebf\uff0c\u4e14\u4ee5\u4e0d\u80fd\u4ee5\u4e0b\u5212\u7ebf\u5f00\u5934\uff01", vo.getKey()));
            }
        }
    }

    private boolean isParentKeyInList(String parentKey, List<DataDictExcelVo> list) {
        if (StringUtil.isEmpty((String)parentKey) || BeanUtils.isEmpty(list)) {
            return false;
        }
        for (DataDictExcelVo dataDictExcelVo : list) {
            if (!parentKey.equals(dataDictExcelVo.getPidKey())) continue;
            return true;
        }
        return false;
    }

    private void handleSaveBuffer(LinkedList<DataDict> list, Map<String, DataDict> data) {
        if (BeanUtils.isEmpty(list)) {
            return;
        }
        int size = list.size();
        int count = 0;
        while (list.size() > 0) {
            DataDict dataDict = list.removeFirst();
            String parentKey = dataDict.getParentId();
            DataDict parent = data.get(parentKey);
            if (BeanUtils.isEmpty((Object)((Object)parent))) {
                list.addLast(dataDict);
                if (++count <= size) continue;
                throw new BaseException("\u5bfc\u5165\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5excel\u6570\u636e\u662f\u5426\u6b63\u786e");
            }
            dataDict.setParentId(parent.getId());
            this.create((Model)dataDict);
            data.put(dataDict.getKey(), dataDict);
            size = list.size();
            count = 0;
        }
    }

    private String getKeyFromList(String id, List<DataDict> list) {
        if (StringUtil.isEmpty((String)id)) {
            return "";
        }
        for (DataDict dataDict : list) {
            if (!id.equals(dataDict.getId())) continue;
            return dataDict.getKey();
        }
        return "";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<String> movePosition(Map<String, String> params) {
        String firstId = params.get("first");
        String secondId = params.get("second");
        DataDict first = (DataDict)((Object)this.getById((Serializable)((Object)firstId)));
        DataDict second = (DataDict)((Object)this.getById((Serializable)((Object)secondId)));
        Integer firstSn = new Integer(first.getSn());
        Integer secondSn = new Integer(second.getSn());
        first.setSn(secondSn);
        this.updateById((Object)first);
        second.setSn(firstSn);
        this.updateById((Object)second);
        return new CommonResult();
    }
}

