/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.sys.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.sys.persistence.dao.PortalAppParamDao;
import com.hotent.sys.persistence.manager.PortalAppParamManager;
import com.hotent.sys.persistence.model.PortalAppParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class PortalAppParamManagerImpl
extends BaseManagerImpl<PortalAppParamDao, PortalAppParam>
implements PortalAppParamManager {
    @Override
    public boolean existsByAppId(String appId) {
        QueryWrapper qw = new QueryWrapper();
        qw.eq((Object)"APP_ID_", (Object)appId);
        List list = this.list((Wrapper)qw);
        return !BeanUtils.isEmpty((Object)list);
    }

    @Override
    public List<PortalAppParam> getbyAppId(String appId) {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("APP_ID_", (Object)appId, QueryOP.EQUAL, FieldRelation.AND);
        PageList pageList = this.query(queryFilter);
        return pageList.getRows();
    }

    @Override
    public List<PortalAppParam> getByAppId(String id) {
        return this.list((Wrapper)Wrappers.lambdaQuery().eq(PortalAppParam::getAppId, (Object)id));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveAppParams(String appId, List<PortalAppParam> params) {
        List saveParams = ((List)Optional.ofNullable(params).orElse(new ArrayList())).parallelStream().peek(param -> {
            String paramId = UniqueIdUtil.getSuid();
            param.setId(paramId);
            param.setAppId(appId);
        }).collect(Collectors.toList());
        this.saveBatch(saveParams);
    }
}

