/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.sys.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.sys.persistence.dao.SysAuthUserDao;
import com.hotent.sys.persistence.manager.CurrentUserService;
import com.hotent.sys.persistence.manager.SysAuthUserManager;
import com.hotent.sys.persistence.model.SysAuthUser;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.impl.util.PermissionCalc;
import com.hotent.uc.api.model.IUser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysAuthUserManagerImpl
extends BaseManagerImpl<SysAuthUserDao, SysAuthUser>
implements SysAuthUserManager {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private CurrentUserService currentUserService;
    @Resource
    PermissionCalc permssionCalc;
    @Resource
    UCFeignService ucFeignService;

    @Override
    public ArrayNode getRights(String authorizeId, String objType) throws IOException {
        String ownerNameJson = "[]";
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("authorizeId", authorizeId);
        params.put("objType", objType);
        List<SysAuthUser> bpmDefUsers = ((SysAuthUserDao)this.baseMapper).getAll(params);
        ownerNameJson = this.toOwnerNameJson(bpmDefUsers);
        return (ArrayNode)JsonUtil.toJsonNode((String)ownerNameJson);
    }

    @Override
    public Map<String, Object> getDefaultRight() {
        try {
            ArrayNode defaultRight = (ArrayNode)JsonUtil.toJsonNode((String)"[{\"type\":\"everyone\",\"title\":\"\u6240\u6709\u4eba\"}]");
            HashMap<String, Object> result = new HashMap<String, Object>(2);
            result.put("right", defaultRight);
            result.put("type", AppUtil.getBean((String)"defaultObjectRightType"));
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u9ed8\u8ba4\u6743\u9650\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    @Override
    public void saveRights(String authorizeId, String objType, String ownerNameJson) throws IOException {
        if (StringUtil.isNotEmpty((String)ownerNameJson)) {
            ((SysAuthUserDao)this.baseMapper).delByAuthorizeId(authorizeId, objType);
            List<SysAuthUser> bpmDefUserList = this.toBpmDefUserList(ownerNameJson, authorizeId);
            for (SysAuthUser bpmDefUser : bpmDefUserList) {
                bpmDefUser.setObjType(objType);
                this.create((Model)bpmDefUser);
            }
        }
    }

    @Override
    public void batchSaveRights(List<String> ids, String objType, String ownerNameJson) throws IOException {
        for (String id : ids) {
            this.saveRights(id, objType, ownerNameJson);
        }
    }

    private List<SysAuthUser> toBpmDefUserList(String ownNameJson, String authorizeId) throws IOException {
        ArrayList<SysAuthUser> userList = new ArrayList<SysAuthUser>();
        if (StringUtil.isEmpty((String)ownNameJson)) {
            return userList;
        }
        ArrayNode aryJson = (ArrayNode)JsonUtil.toJsonNode((String)ownNameJson);
        for (Object obj : aryJson) {
            ObjectNode jsonObject = (ObjectNode)obj;
            List<SysAuthUser> list = this.getList(jsonObject, authorizeId);
            userList.addAll(list);
        }
        return userList;
    }

    private List<SysAuthUser> getList(ObjectNode json, String authorizeId) {
        ArrayList<SysAuthUser> bpmDefUsers = new ArrayList<SysAuthUser>();
        String type = json.get("type").asText();
        if ("everyone".equals(type)) {
            SysAuthUser defUser = new SysAuthUser();
            defUser.setId(UniqueIdUtil.getSuid());
            defUser.setAuthorizeId(authorizeId);
            defUser.setRightType(type);
            bpmDefUsers.add(defUser);
        } else {
            String ids = json.get("id").asText();
            String names = json.get("name").asText();
            String[] aryId = ids.split(",");
            String[] aryName = names.split(",");
            for (int i = 0; i < aryId.length; ++i) {
                SysAuthUser defUser = new SysAuthUser();
                defUser.setId(UniqueIdUtil.getSuid());
                defUser.setAuthorizeId(authorizeId);
                defUser.setRightType(type);
                defUser.setOwnerId(aryId[i]);
                defUser.setOwnerName(aryName[i]);
                bpmDefUsers.add(defUser);
            }
        }
        return bpmDefUsers;
    }

    private String toOwnerNameJson(List<SysAuthUser> bpmDefUsers) {
        if (BeanUtils.isEmpty(bpmDefUsers)) {
            return "[]";
        }
        HashMap map = new HashMap();
        Map<String, String> userTypeMap = this.currentUserService.getUserTypeMap(CurrentUserService.DEFAULT_OBJECT_RIGHTTYPE_BEAN);
        for (SysAuthUser user : bpmDefUsers) {
            List<SysAuthUser> list;
            String string = user.getRightType();
            if (map.containsKey(string)) {
                list = (List)map.get(string);
                list.add(user);
                continue;
            }
            list = new ArrayList();
            list.add(user);
            map.put(string, list);
        }
        ArrayNode ArrayNode2 = JsonUtil.getMapper().createArrayNode();
        for (Map.Entry<String, List<SysAuthUser>> entry : map.entrySet()) {
            ObjectNode json = this.userEntToJson(entry, userTypeMap);
            ArrayNode2.add((JsonNode)json);
        }
        return ArrayNode2.toString();
    }

    private ObjectNode userEntToJson(Map.Entry<String, List<SysAuthUser>> entry, Map<String, String> userTypeMap) {
        ObjectNode jsonObj = JsonUtil.getMapper().createObjectNode();
        String type = entry.getKey();
        String title = userTypeMap.get(type);
        jsonObj.put("type", type);
        jsonObj.put("title", title);
        if (type.equals("everyone")) {
            return jsonObj;
        }
        List<SysAuthUser> list = entry.getValue();
        String ids = "";
        String names = "";
        for (int i = 0; i < list.size(); ++i) {
            SysAuthUser user = list.get(i);
            if (i == 0) {
                ids = ids + user.getOwnerId();
                names = names + user.getOwnerName();
                continue;
            }
            ids = ids + "," + user.getOwnerId();
            names = names + "," + user.getOwnerName();
        }
        jsonObj.put("id", ids);
        jsonObj.put("name", names);
        return jsonObj;
    }

    @Override
    public List<String> getAuthorizeIdsByUserMap(String objType) {
        Map<String, Set<String>> userRightMap = this.currentUserService.getUserRightMap();
        Map<String, String> userRightMapStr = this.currentUserService.getMapStringByMayList(userRightMap);
        List<String> list = ((SysAuthUserDao)this.baseMapper).getAuthorizeIdsByUserMap(userRightMapStr, objType);
        return list;
    }

    @Override
    public boolean hasRights(String authorizeId) {
        Map<String, Set<String>> userRightMap = this.currentUserService.getUserRightMap();
        Map<String, String> userRightMapStr = this.currentUserService.getMapStringByMayList(userRightMap);
        List<String> list = ((SysAuthUserDao)this.baseMapper).getAuthByAuthorizeId(userRightMapStr, authorizeId);
        return BeanUtils.isNotEmpty(list);
    }

    @Override
    @CacheEvict(value={"eip:sys:userMenu"}, allEntries=true)
    public void delUserMenu() {
    }

    @Override
    @CacheEvict(value={"eip:sys:userMenu"}, key="#userId")
    public void delUserMenuCache(String userId) {
    }

    @Override
    @CacheEvict(value={"eip:portal:popupRemind"}, allEntries=true)
    public void delPopupCache() {
    }

    @Override
    public boolean getAuthorizeAppMenuId(String menuId, Map<String, String> userRightMap) {
        List<String> list = ((SysAuthUserDao)this.baseMapper).getAuthorizeAppMenuId(menuId, userRightMap);
        return BeanUtils.isNotEmpty(list);
    }

    @Override
    public Map<String, Set<String>> getUserRightMap() {
        return this.currentUserService.getUserRightMap();
    }

    @Override
    public List<String> filterAuth(List<String> ids) {
        if (BeanUtils.isEmpty(ids)) {
            return new ArrayList<String>();
        }
        Map<String, Set<String>> userRightMap = this.currentUserService.getUserRightMap();
        Map<String, String> userRightMapStr = this.currentUserService.getMapStringByMayList(userRightMap);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ids.size(); ++i) {
            sb.append("'");
            sb.append(ids.get(i));
            sb.append("'");
            if (i == ids.size() - 1) continue;
            sb.append(",");
        }
        List<String> res = ((SysAuthUserDao)this.baseMapper).getAuthByAuthorizedIds(userRightMapStr, sb.toString());
        return res;
    }

    @Override
    public void createDefault(String authorizeId) {
        SysAuthUser sysAuthUser = new SysAuthUser();
        sysAuthUser.setRightType("everyone");
        sysAuthUser.setAuthorizeId(authorizeId);
        sysAuthUser.setObjType("app");
        this.save((Object)sysAuthUser);
    }

    @Override
    public void createDefaultByObjType(String authorizeId, String objType) {
        SysAuthUser sysAuthUser = new SysAuthUser();
        sysAuthUser.setRightType("everyone");
        sysAuthUser.setAuthorizeId(authorizeId);
        sysAuthUser.setObjType(objType);
        this.save((Object)sysAuthUser);
    }

    @Override
    public <T> List<T> getAuthItems(List<T> items, Function<T, String> function, String userId, Function<T, String> userFunction) {
        List<String> ids = items.parallelStream().map(function).collect(Collectors.toList());
        List<String> authIds = this.filterAuth(ids);
        List newApps = items.parallelStream().filter(item -> authIds.contains(function.apply(item)) || userId.equals(userFunction.apply(item))).collect(Collectors.toList());
        return newApps;
    }

    @Override
    public ObjectNode calcAllPermssion(String permssionJson) throws Exception {
        ObjectNode rightJson = JsonUtil.getMapper().createObjectNode();
        Map currentMap = this.permssionCalc.getCurrentProfiles();
        ArrayNode array = (ArrayNode)JsonUtil.toJsonNode((String)permssionJson);
        for (JsonNode jsonNode : array) {
            ObjectNode node = (ObjectNode)jsonNode;
            String permssionStr = "";
            permssionStr = node.get("right").isArray() ? JsonUtil.toJson((Object)node.get("right")) : node.get("right").asText();
            boolean is = false;
            if (StringUtil.isNotEmpty((String)permssionStr)) {
                ArrayNode ay = (ArrayNode)JsonUtil.toJsonNode((String)permssionStr);
                for (JsonNode jsonNode2 : ay) {
                    boolean isRight = this.permssionCalc.hasRight(JsonUtil.toJson((Object)jsonNode2), currentMap);
                    if (!isRight) continue;
                    is = true;
                    break;
                }
            }
            rightJson.put(node.get("fieldName").asText(), is);
        }
        return rightJson;
    }

    @Override
    public List<String> getAuthorizeIdsByUserAndList(String objType, List<String> list) {
        List<String> authList = this.getAuthorizeIdsByUserMap(objType);
        if (BeanUtils.isNotEmpty(list)) {
            HashMap<String, Boolean> authSetMap = new HashMap<String, Boolean>();
            List<String> authSetList = ((SysAuthUserDao)this.baseMapper).getAuthSetList(list);
            if (BeanUtils.isNotEmpty(authSetList)) {
                for (String authId : authSetList) {
                    authSetMap.put(authId, true);
                }
            }
            for (String id : list) {
                if (authSetMap.containsKey(id)) continue;
                authList.add(id);
            }
        }
        return authList;
    }

    @Override
    public List<String> getCurrentUserColumnIds() {
        QueryWrapper queryWrapper;
        ArrayList ids;
        HashSet authSet = Sets.newHashSet();
        IUser currentUser = ContextUtil.getCurrentUser();
        String curUserId = currentUser.getUserId();
        String currentUserAccount = currentUser.getAccount();
        List posListByAccount = this.ucFeignService.getPosListByAccount(curUserId);
        ArrayNode orgListByUserId = this.ucFeignService.getOrgListByUserId(curUserId);
        List roleListByAccount = this.ucFeignService.getRoleListByAccount(currentUserAccount);
        QueryWrapper queryWrapperEveryone = new QueryWrapper();
        queryWrapperEveryone.eq((Object)"RIGHT_TYPE_", (Object)"everyone");
        authSet.addAll(this.list((Wrapper)queryWrapperEveryone));
        if (StringUtil.isNotEmpty((String)curUserId)) {
            QueryWrapper queryWrapper2 = new QueryWrapper();
            ((QueryWrapper)queryWrapper2.eq((Object)"RIGHT_TYPE_", (Object)"user")).eq((Object)"OWNER_ID_", (Object)curUserId);
            authSet.addAll(this.list((Wrapper)queryWrapper2));
        }
        if (BeanUtils.isNotEmpty((Object)posListByAccount)) {
            ids = Lists.newArrayList();
            for (ObjectNode node : posListByAccount) {
                ids.add(node.get("id").asText());
            }
            queryWrapper = new QueryWrapper();
            ((QueryWrapper)queryWrapper.eq((Object)"RIGHT_TYPE_", (Object)"pos")).in((Object)"OWNER_ID_", (Collection)ids);
            authSet.addAll(this.list((Wrapper)queryWrapper));
        }
        if (BeanUtils.isNotEmpty((Object)orgListByUserId)) {
            ids = Lists.newArrayList();
            for (ObjectNode node : orgListByUserId) {
                ids.add(node.get("id").asText());
            }
            queryWrapper = new QueryWrapper();
            ((QueryWrapper)queryWrapper.eq((Object)"RIGHT_TYPE_", (Object)"org")).in((Object)"OWNER_ID_", (Collection)ids);
            authSet.addAll(this.list((Wrapper)queryWrapper));
        }
        if (BeanUtils.isNotEmpty((Object)roleListByAccount)) {
            ids = Lists.newArrayList();
            for (ObjectNode node : roleListByAccount) {
                ids.add(node.get("id").asText());
            }
            queryWrapper = new QueryWrapper();
            ((QueryWrapper)queryWrapper.eq((Object)"RIGHT_TYPE_", (Object)"role")).in((Object)"OWNER_ID_", (Collection)ids);
            Set collect = this.list((Wrapper)queryWrapper).stream().map(SysAuthUser::getAuthorizeId).collect(Collectors.toSet());
            authSet.addAll(this.list((Wrapper)queryWrapper));
        }
        return authSet.stream().map(SysAuthUser::getAuthorizeId).collect(Collectors.toList());
    }

    @Override
    public List<SysAuthUser> getByAuthorizeId(String id) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysAuthUser::getAuthorizeId, (Object)id);
        List sysAuthUserList = this.list((Wrapper)wrapper);
        for (SysAuthUser sysAuthUser : sysAuthUserList) {
            String code;
            CommonResult result;
            String rightType = sysAuthUser.getRightType();
            String ownerId = sysAuthUser.getOwnerId();
            if ("user".equals(rightType)) {
                result = this.ucFeignService.getUserById(ownerId);
                if (!BeanUtils.isNotEmpty((Object)result)) continue;
                JsonNode userNode = (JsonNode)result.getValue();
                String account = JsonUtil.getString((JsonNode)userNode, (String)"account");
                sysAuthUser.setOwnerCode(account);
                continue;
            }
            if ("org".equals(rightType)) {
                ObjectNode orgObjNode = this.ucFeignService.getOrgByIdOrCode(ownerId);
                if (!BeanUtils.isNotEmpty((Object)orgObjNode)) continue;
                String code2 = orgObjNode.get("code").asText();
                sysAuthUser.setOwnerCode(code2);
                continue;
            }
            if ("pos".equals(rightType)) {
                result = this.ucFeignService.getPostByIdOrCode(ownerId);
                if (!result.getState().booleanValue() || !BeanUtils.isNotEmpty((Object)result.getValue())) continue;
                ObjectNode posObjNode = (ObjectNode)result.getValue();
                code = posObjNode.get("code").asText();
                sysAuthUser.setOwnerCode(code);
                continue;
            }
            if (!"role".equals(rightType) || !(result = this.ucFeignService.getRoleByIdOrCode(ownerId)).getState().booleanValue() || !BeanUtils.isNotEmpty((Object)result.getValue())) continue;
            ObjectNode roleObjNode = (ObjectNode)result.getValue();
            code = roleObjNode.get("code").asText();
            sysAuthUser.setOwnerCode(code);
        }
        return sysAuthUserList;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveAppAuthUsers(String appId, List<SysAuthUser> authUsers) {
        if (BeanUtils.isEmpty(authUsers)) {
            this.createDefault(appId);
        } else {
            List saveAuthUsers = authUsers.parallelStream().peek(sysAuthUser -> {
                CommonResult result;
                sysAuthUser.setId(UniqueIdUtil.getSuid());
                String rightType = sysAuthUser.getRightType();
                String ownerCode = sysAuthUser.getOwnerCode();
                String ownerId = null;
                String ownerName = null;
                sysAuthUser.setAuthorizeId(appId);
                if ("user".equals(rightType)) {
                    JsonNode userNode = this.ucFeignService.getUser(ownerCode, null);
                    if (BeanUtils.isNotEmpty((Object)userNode)) {
                        ownerId = JsonUtil.getString((JsonNode)userNode, (String)"id");
                        ownerName = JsonUtil.getString((JsonNode)userNode, (String)"fullname");
                        sysAuthUser.setOwnerId(ownerId);
                        sysAuthUser.setOwnerName(ownerName);
                    }
                } else if ("org".equals(rightType)) {
                    ObjectNode orgObjNode = this.ucFeignService.getOrgByIdOrCode(ownerCode);
                    if (BeanUtils.isNotEmpty((Object)orgObjNode)) {
                        ownerId = orgObjNode.get("id").asText();
                        ownerName = orgObjNode.get("name").asText();
                        sysAuthUser.setOwnerId(ownerId);
                        sysAuthUser.setOwnerName(ownerName);
                    }
                } else if ("pos".equals(rightType)) {
                    CommonResult result2 = this.ucFeignService.getPostByIdOrCode(ownerCode);
                    if (result2.getState().booleanValue() && BeanUtils.isNotEmpty((Object)result2.getValue())) {
                        ObjectNode posObjNode = (ObjectNode)result2.getValue();
                        ownerId = posObjNode.get("id").asText();
                        ownerName = posObjNode.get("name").asText();
                        sysAuthUser.setOwnerId(ownerId);
                        sysAuthUser.setOwnerName(ownerName);
                    }
                } else if ("role".equals(rightType) && (result = this.ucFeignService.getRoleByIdOrCode(ownerCode)).getState().booleanValue() && BeanUtils.isNotEmpty((Object)result.getValue())) {
                    ObjectNode roleObjNode = (ObjectNode)result.getValue();
                    ownerId = roleObjNode.get("id").asText();
                    ownerName = roleObjNode.get("name").asText();
                }
            }).collect(Collectors.toList());
            this.saveBatch(saveAuthUsers);
        }
    }
}

