/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.sys.persistence.manager.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.exception.BaseException;
import com.hotent.base.id.IdGenerator;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.sys.persistence.dao.SysCategoryDao;
import com.hotent.sys.persistence.dao.SysTypeDao;
import com.hotent.sys.persistence.manager.SysCategoryManager;
import com.hotent.sys.persistence.model.SysCategory;
import com.hotent.sys.persistence.model.SysType;
import com.hotent.uc.api.impl.util.ContextUtil;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service(value="sysCategoryManager")
public class SysCategoryManagerImpl
extends BaseManagerImpl<SysCategoryDao, SysCategory>
implements SysCategoryManager {
    @Resource
    SysTypeDao sysTypeDao;
    @Resource
    SysCategoryManager sysCategoryManager;
    @Resource
    IdGenerator idGenerator;

    @Override
    public Boolean isKeyExist(String id, String groupKey) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("id", id);
        params.put("groupKey", groupKey);
        int i = ((SysCategoryDao)this.baseMapper).isKeyExist(params);
        return i > 0;
    }

    @Override
    public SysCategory getByTypeKey(String typeKey) {
        return ((SysCategoryDao)this.baseMapper).getByKey(typeKey);
    }

    @Override
    public CommonResult<String> saveSysCategory(SysCategory sysCategory) {
        boolean isKeyExist;
        String id = sysCategory.getId();
        String groupKey = sysCategory.getGroupKey();
        if (StringUtil.isEmpty((String)id)) {
            id = null;
        }
        if (isKeyExist = this.sysCategoryManager.isKeyExist(id, groupKey).booleanValue()) {
            return new CommonResult(false, "\u8f93\u5165\u7684\u5206\u7c7b\u7ec4\u4e3b\u952e\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728!");
        }
        try {
            if (StringUtil.isEmpty((String)id)) {
                sysCategory.setId(this.idGenerator.getSuid());
                sysCategory.setFlag(0);
                sysCategory.setSn(0);
                sysCategory.setCreateOrgId(ContextUtil.getCurrentGroupId());
                this.sysCategoryManager.create((Model)sysCategory);
                return new CommonResult(true, "\u6dfb\u52a0\u7cfb\u7edf\u5206\u7c7b\u7ec4\u503c\u8868\u6210\u529f");
            }
            sysCategory.setGroupKey(groupKey);
            this.sysCategoryManager.update((Model)sysCategory);
            return new CommonResult(true, "\u66f4\u65b0\u7cfb\u7edf\u5206\u7c7b\u7ec4\u503c\u8868\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, "\u64cd\u4f5c\u5931\u8d25");
        }
    }

    public void remove(Serializable entityId) {
        List<SysType> sysTypes = this.sysTypeDao.getByParentId(entityId.toString());
        if (BeanUtils.isNotEmpty(sysTypes)) {
            String val = sysTypes.get(0).getTypeGroupKey();
            SysCategory sysCategory = ((SysCategoryDao)this.baseMapper).getByKey(val);
            if (BeanUtils.isNotEmpty((Object)((Object)sysCategory))) {
                val = sysCategory.getName();
            }
            throw new BaseException(String.format("\u5206\u7c7b\u6807\u8bc6[%s]\u4e0b\u5df2\u7ecf\u6dfb\u52a0\u5206\u7c7b\u4fe1\u606f\u6682\u65e0\u6cd5\u5220\u9664\u3002", val));
        }
        super.remove(entityId);
    }
}

