/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.sys.persistence.manager.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.datasource.DataSourceLoader;
import com.hotent.base.datasource.DatabaseContext;
import com.hotent.base.exception.BaseException;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.ExceptionUtil;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.SQLUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.ZipUtil;
import com.hotent.sys.persistence.dao.SysDataSourceDao;
import com.hotent.sys.persistence.manager.SysDataSourceManager;
import com.hotent.sys.persistence.model.SysDataSource;
import com.hotent.table.datasource.DataSourceUtil;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Primary;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Primary
@Service(value="sysDataSourceManager")
public class SysDataSourceManagerImpl
extends BaseManagerImpl<SysDataSourceDao, SysDataSource>
implements SysDataSourceManager,
DataSourceLoader {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SysDataSourceManagerImpl.class);
    @Resource
    DatabaseContext databaseContext;

    public void create(SysDataSource sysDataSource) {
        super.create((Model)sysDataSource);
        this.updateDataSource(sysDataSource);
    }

    public DataSource loadByAlias(String alias) {
        SysDataSource sysDataSource = this.getByAlias(alias);
        return this.getDsFromSysSource(sysDataSource);
    }

    public void update(SysDataSource sysDataSource) {
        super.update((Model)sysDataSource);
        this.updateDataSource(sysDataSource);
    }

    public boolean removeByIds(Collection<? extends Serializable> ids) {
        List<String> aliasAry = ((SysDataSourceDao)this.baseMapper).getAliasByIds(ids);
        boolean result = super.removeByIds(ids);
        for (String alias : aliasAry) {
            try {
                DataSourceUtil.removeDataSource((String)alias);
            }
            catch (Exception e) {
                LOGGER.warn(String.format("\u5173\u95ed\u6570\u636e\u6e90\uff1a%s\u65f6\u51fa\u9519", alias), (Throwable)e);
            }
        }
        return result;
    }

    private void updateDataSource(SysDataSource sysDataSource) {
        try {
            if (sysDataSource.getEnabled().booleanValue()) {
                DataSource dataSource = this.getDsFromSysSource(sysDataSource);
                DataSourceUtil.addDataSource((String)sysDataSource.getAlias(), (DataSource)dataSource, (boolean)true);
            }
        }
        catch (Exception e) {
            LOGGER.error(ExceptionUtil.getExceptionMessage((Throwable)e), (Throwable)e);
        }
    }

    @Override
    public DataSource getDsFromSysSource(SysDataSource sysDataSource) {
        DataSource dataSource = null;
        try {
            dataSource = this.databaseContext.getDsFromSysSource(JsonUtil.toJsonNode((Object)((Object)sysDataSource)));
        }
        catch (IOException e) {
            LOGGER.warn(String.format("\u6570\u636e\u6e90\uff1a%s(%s) \u7684\u53c2\u6570\u914d\u7f6e\u6709\u8bef\uff0c\u65e0\u6cd5\u521b\u5efa\u6570\u636e\u5e93\u8fde\u63a5\u3002", sysDataSource.getName(), sysDataSource.getAlias()), (Throwable)e);
        }
        return dataSource;
    }

    @Override
    public boolean checkConnection(SysDataSource sysDataSource) {
        return this.checkConnection(sysDataSource.getAlias(), this.getDsFromSysSource(sysDataSource), sysDataSource.getCloseMethod());
    }

    private boolean checkConnection(String dsAlias, DataSource dataSource, String closeMethod) {
        boolean b = false;
        try (Connection connection = dataSource.getConnection();){
            b = !connection.isClosed();
        }
        catch (Exception e) {
            throw new BaseException("\u8fde\u63a5\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
        }
        finally {
            this.closeInvoke(closeMethod, dataSource, dsAlias);
        }
        return b;
    }

    private void closeInvoke(String closeMethod, DataSource dataSource, String dsAlias) {
        if (!StringUtil.isEmpty((String)closeMethod) && closeMethod.split("\\|").length >= 2) {
            String cp = closeMethod.split("\\|")[0];
            String mn = closeMethod.split("\\|")[1];
            try {
                Class<?> _class = Class.forName(cp);
                Method method = _class.getMethod(mn, null);
                method.invoke(null, null);
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
        this.databaseContext.destroyDataSourceByAlias(dsAlias, dataSource);
    }

    @Override
    public List<SysDataSource> getSysDataSourcesInBean() {
        Map map;
        ArrayList<SysDataSource> result = new ArrayList<SysDataSource>();
        try {
            map = DataSourceUtil.getDataSources();
        }
        catch (Exception e) {
            return result;
        }
        QueryFilter queryFilter = QueryFilter.build().withDefaultPage().withQuery(new QueryField("enabled_", (Object)1));
        PageList query = this.query(queryFilter);
        List sysDataSources = query.getRows();
        for (Object key : map.keySet()) {
            for (SysDataSource sysDataSource : sysDataSources) {
                if (!sysDataSource.getAlias().equals(key.toString())) continue;
                result.add(sysDataSource);
            }
        }
        return result;
    }

    @Override
    public SysDataSource getByAlias(String alias) {
        QueryFilter queryFilter = QueryFilter.build().withDefaultPage().withQuery(new QueryField("alias_", (Object)alias));
        PageList sysDataSources = this.query(queryFilter);
        if (sysDataSources != null && !sysDataSources.getRows().isEmpty()) {
            return (SysDataSource)((Object)sysDataSources.getRows().get(0));
        }
        return null;
    }

    @Override
    public Map<String, DataSource> getDataSource() {
        List<SysDataSource> list = ((SysDataSourceDao)this.baseMapper).getDataSource(true, true);
        HashMap<String, DataSource> maps = new HashMap<String, DataSource>();
        for (SysDataSource sysDataSource : list) {
            DataSource ds = this.getDsFromSysSource(sysDataSource);
            if (ds == null) continue;
            maps.put(sysDataSource.getAlias(), ds);
        }
        return maps;
    }

    @Override
    public SysDataSource getDefaultDataSource() {
        SysDataSource defaultDataSource = new SysDataSource();
        defaultDataSource.setAlias("LOCAL");
        defaultDataSource.setName("\u672c\u5730\u6570\u636e\u6e90");
        defaultDataSource.setDbType(SQLUtil.getDbType());
        return defaultDataSource;
    }

    @Override
    public boolean isAliasExist(String alias) {
        SysDataSource sysDataSource = this.getByAlias(alias);
        return BeanUtils.isNotEmpty((Object)((Object)sysDataSource));
    }

    @Override
    public String export(String[] idList) throws Exception {
        if (BeanUtils.isEmpty((Object)idList)) {
            return "";
        }
        ArrayList<Model> list = new ArrayList<Model>();
        for (String s : idList) {
            list.add(this.get((Serializable)((Object)s)));
        }
        if (BeanUtils.isEmpty(list)) {
            return "";
        }
        return JsonUtil.toJson(list);
    }

    @Override
    public void importFile(String unZipFilePath) throws Exception {
        try {
            String json = FileUtil.readFile((String)(unZipFilePath + File.separator + "sysDataSource.json"));
            List list = (List)JsonUtil.toBean((String)json, List.class);
            for (Object o : list) {
                SysDataSource sysDataSource = (SysDataSource)((Object)JsonUtil.toBean((String)JsonUtil.toJson(o), SysDataSource.class));
                SysDataSource byAlias = this.getByAlias(sysDataSource.getAlias());
                if (BeanUtils.isNotEmpty((Object)((Object)byAlias))) {
                    if (byAlias.getId().equals(sysDataSource.getId())) {
                        ((SysDataSourceDao)this.baseMapper).updateById((Object)sysDataSource);
                        continue;
                    }
                    throw new BaseException("\u522b\u540d\u3010" + sysDataSource.getAlias() + "\u3011\u5df2\u5b58\u5728");
                }
                sysDataSource.setId(null);
                ((SysDataSourceDao)this.baseMapper).insert((Object)sysDataSource);
            }
        }
        catch (Exception e) {
            throw new BaseException("\u5bfc\u5165\u5931\u8d25:" + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResult<String> importIdentity(MultipartHttpServletRequest request, HttpServletResponse response) {
        MultipartFile file = request.getFile("file");
        String unZipFilePath = "";
        try {
            String rootRealPath = (FileUtil.getIoTmpdir() + "/attachFiles/unZip/").replace("/", File.separator);
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            String name = file.getOriginalFilename();
            String fileDir = StringUtil.substringBeforeLast((String)name, (String)".");
            ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            unZipFilePath = rootRealPath + File.separator + fileDir;
            this.importFile(unZipFilePath);
            CommonResult commonResult = new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
            return commonResult;
        }
        catch (Exception e) {
            CommonResult commonResult = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
            return commonResult;
        }
        finally {
            File zipFile;
            if (StringUtil.isNotEmpty((String)unZipFilePath) && (zipFile = new File(unZipFilePath)).exists()) {
                zipFile.delete();
            }
        }
    }

    @Override
    public CommonResult<String> saveSysDataSource(SysDataSource sysDataSource) {
        boolean isConnection = this.checkConnection(sysDataSource);
        boolean isAliasExist = this.isAliasExist(sysDataSource.getAlias());
        if (isAliasExist && StringUtil.isEmpty((String)sysDataSource.getId())) {
            return new CommonResult(false, "\u522b\u540d\u5df2\u5b58\u5728");
        }
        if (!isConnection) {
            return new CommonResult(false, "\u8fde\u63a5\u6570\u636e\u5e93\u5931\u8d25\uff0c\u64cd\u4f5c\u5931\u8d25");
        }
        String resultMsg = null;
        if (StringUtil.isEmpty((String)sysDataSource.getId())) {
            sysDataSource.setId(UniqueIdUtil.getSuid());
            resultMsg = "\u6dfb\u52a0\u6210\u529f,\u5e76\u8fde\u63a5\u6d4b\u8bd5\u901a\u8fc7";
        } else {
            resultMsg = "\u66f4\u65b0\u6210\u529f,\u5e76\u8fde\u63a5\u6d4b\u8bd5\u901a\u8fc7";
        }
        this.saveOrUpdate((Object)sysDataSource);
        return new CommonResult(resultMsg);
    }
}

