/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.sys.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.cache.annotation.CachePut;
import com.hotent.base.cache.annotation.Cacheable;
import com.hotent.base.cache.annotation.FirstCache;
import com.hotent.base.conf.SaaSConfig;
import com.hotent.base.constants.TenantConstant;
import com.hotent.base.context.BaseContext;
import com.hotent.base.enums.ResponseErrorEnums;
import com.hotent.base.exception.BaseException;
import com.hotent.base.exception.DataExistException;
import com.hotent.base.exception.ServerRejectException;
import com.hotent.base.feign.PortalFeignService;
import com.hotent.base.feign.UCFeignService;
import com.hotent.base.handler.MultiTenantHandler;
import com.hotent.base.handler.MultiTenantIgnoreResult;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.TenantUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.ZipUtil;
import com.hotent.i18n.util.I18nUtil;
import com.hotent.sys.constants.FrontTypeConstant;
import com.hotent.sys.persistence.dao.SysMenuDao;
import com.hotent.sys.persistence.dao.SysMethodDao;
import com.hotent.sys.persistence.manager.SysAppManager;
import com.hotent.sys.persistence.manager.SysAuthMenuManager;
import com.hotent.sys.persistence.manager.SysMenuManager;
import com.hotent.sys.persistence.manager.SysMethodManager;
import com.hotent.sys.persistence.manager.SysRoleAuthManager;
import com.hotent.sys.persistence.model.SysApp;
import com.hotent.sys.persistence.model.SysAuthMenu;
import com.hotent.sys.persistence.model.SysMenu;
import com.hotent.sys.persistence.model.SysMethod;
import com.hotent.sys.persistence.model.SysRoleAuth;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import io.seata.spring.annotation.GlobalTransactional;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="sysMenuManager")
public class SysMenuManagerImpl
extends BaseManagerImpl<SysMenuDao, SysMenu>
implements SysMenuManager {
    @Resource
    SysMethodDao sysMethodDao;
    @Resource
    UCFeignService uCFeignService;
    @Resource
    PortalFeignService portalFeignService;
    @Value(value="${system.mode.demo:false}")
    protected boolean demoMode;
    @Autowired
    SaaSConfig saaSConfig;
    @Resource
    MultiTenantHandler multiTenantHandler;
    @Resource
    BaseContext baseContext;
    @Resource
    SysMenuManager sysMenuManager;
    @Resource
    SysMethodManager sysMethodManager;
    @Resource
    SysAppManager sysAppManager;
    @Resource
    SysRoleAuthManager sysRoleAuthManager;
    @Resource
    SysAuthMenuManager sysAuthMenuManager;
    @Resource
    UCFeignService ucFeignService;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SysMenu getByAlias(String alias) {
        SysMenu sysMenu = null;
        try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
            List<SysMethod> sysMethods;
            sysMenu = ((SysMenuDao)this.baseMapper).getByAlias(alias, this.getTenantIds());
            if (BeanUtils.isNotEmpty((Object)((Object)sysMenu)) && BeanUtils.isNotEmpty(sysMethods = this.sysMethodDao.getByMenuAlias(sysMenu.getAlias()))) {
                sysMenu.setSysMethods(sysMethods);
            }
            SysMenu sysMenu2 = sysMenu;
            return sysMenu2;
        }
        catch (Exception el) {
            el.printStackTrace();
            throw new RuntimeException(el);
        }
    }

    public SysMenu get(Serializable entityId) {
        List<SysMethod> sysMethods;
        SysMenu sysMenu = null;
        try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
            sysMenu = (SysMenu)super.get(entityId);
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
        if (BeanUtils.isNotEmpty((Object)((Object)sysMenu)) && BeanUtils.isNotEmpty(sysMethods = this.sysMethodDao.getByMenuAlias(sysMenu.getAlias()))) {
            sysMenu.setSysMethods(sysMethods);
        }
        return sysMenu;
    }

    public void create(SysMenu entity) {
        if (StringUtil.isNotEmpty((String)entity.getParentId())) {
            ArrayList<SysRoleAuth> sysRoleAuthList = new ArrayList<SysRoleAuth>();
            this.getSysRoleAuthList(entity, sysRoleAuthList, entity.getParentId(), new ArrayList<String>());
            this.sysRoleAuthManager.saveOrUpdateBatch(sysRoleAuthList);
        }
        super.create((Model)entity);
        this.sysMethodDao.removeByMenuId((Serializable)((Object)entity.getId()));
        List<SysMethod> sysMethods = entity.getSysMethods();
        if (BeanUtils.isNotEmpty(sysMethods)) {
            for (SysMethod sysMethod : sysMethods) {
                sysMethod.setMenuAlias(entity.getAlias());
                sysMethod.setPath(entity.getPath());
                sysMethod.setId(UniqueIdUtil.getSuid());
                this.sysMethodDao.insert((Object)sysMethod);
            }
        }
        this.removeUserMenuCache();
    }

    public void update(SysMenu entity) {
        if (this.demoMode) {
            throw new ServerRejectException("\u6f14\u793a\u6a21\u5f0f\u4e0b\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c");
        }
        super.update((Model)entity);
        List<SysMethod> sysMethods = entity.getSysMethods();
        LambdaQueryWrapper whereParam = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysMethod::getMenuAlias, (Object)entity.getAlias());
        ArrayList methodIds = new ArrayList();
        if (BeanUtils.isNotEmpty(sysMethods)) {
            sysMethods.forEach(sysMethod -> {
                sysMethod.setPath(entity.getPath());
                sysMethod.setMenuAlias(entity.getAlias());
                sysMethod.setTenantId(null);
                if (StringUtil.isNotEmpty((String)entity.getId())) {
                    methodIds.add(entity.getId());
                }
            });
            if (BeanUtils.isNotEmpty(methodIds)) {
                whereParam.notIn(SysMethod::getId, methodIds);
            }
            this.sysMethodManager.remove((Wrapper)whereParam);
            this.sysMethodManager.saveOrUpdateBatch(sysMethods);
        } else {
            this.sysMethodManager.remove((Wrapper)whereParam);
        }
        this.removeUserMenuCache();
    }

    public void remove(Serializable entityId) {
        if (this.demoMode) {
            throw new ServerRejectException("\u6f14\u793a\u6a21\u5f0f\u4e0b\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c");
        }
        this.sysMethodDao.removeByMenuId(entityId);
        try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
            super.remove(entityId);
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    @Override
    public boolean isExistByAlias(String alias) {
        boolean isInPlateform = false;
        if (this.saaSConfig.isEnable()) {
            List<String> tenantIds = this.getTenantIds();
            if ("-1".equals(this.baseContext.getCurrentTenantId())) {
                tenantIds = null;
            }
            try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
                isInPlateform = ((SysMenuDao)this.baseMapper).isExistPlateformByAlias(alias, tenantIds) > 0;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return ((SysMenuDao)this.baseMapper).isExistByAlias(alias) > 0 || isInPlateform;
    }

    @Override
    @Transactional
    public void removeByResId(String resId, boolean force) {
        List collect;
        if (this.demoMode) {
            throw new ServerRejectException("\u6f14\u793a\u6a21\u5f0f\u4e0b\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c");
        }
        List<SysMenu> list = this.getRecursionById(resId);
        String currentTenantId = TenantUtil.getCurrentTenantId();
        if (!force && "-1".equals(currentTenantId) && BeanUtils.isNotEmpty(collect = list.stream().filter(r -> !currentTenantId.equals(r.getTenantId())).collect(Collectors.toList()))) {
            BaseException baseException = new BaseException("\u5176\u4ed6\u79df\u6237\u4e0b\u6709\u83dc\u5355\u5728\u5f53\u524d\u83dc\u5355\u4e0b\uff0c\u8bf7\u786e\u5b9a\u662f\u5426\u5220\u9664?");
            baseException.setCode(ResponseErrorEnums.FAIL_OPTION.getCode());
            throw baseException;
        }
        if (BeanUtils.isEmpty(list)) {
            return;
        }
        for (SysMenu resource : list) {
            this.remove((Serializable)((Object)resource.getId()));
        }
        this.removeUserMenuCache();
        this.portalFeignService.removeBookmarkByMenuIds(list.stream().map(SysMenu::getId).collect(Collectors.toList()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<SysMenu> getRecursionById(String resId) {
        ArrayList<SysMenu> list = new ArrayList<SysMenu>();
        SysMenu resource = this.get((Serializable)((Object)resId));
        String currentTenantId = this.baseContext.getCurrentTenantId();
        if (BeanUtils.isNotEmpty((Object)((Object)resource)) && !currentTenantId.equals(resource.getTenantId()) && this.saaSConfig.isEnable()) {
            throw new BaseException("\u65e0\u6743\u9650\u5220\u9664\u8be5\u83dc\u5355\uff01");
        }
        list.add(resource);
        try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
            List<SysMenu> tmpList = ((SysMenuDao)this.baseMapper).getByParentId(resId);
            if (BeanUtils.isEmpty(tmpList)) {
                ArrayList<SysMenu> arrayList = list;
                return arrayList;
            }
            Iterator<SysMenu> iterator = tmpList.iterator();
            while (iterator.hasNext()) {
                SysMenu sysMenu = iterator.next();
                this.recursion(sysMenu, list);
            }
            return list;
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
    }

    private void recursion(SysMenu sysMenu, List<SysMenu> list) {
        list.add(sysMenu);
        List<SysMenu> tmpList = ((SysMenuDao)this.baseMapper).getByParentId(sysMenu.getId());
        if (BeanUtils.isEmpty(tmpList)) {
            return;
        }
        for (SysMenu resource : tmpList) {
            this.recursion(resource, list);
        }
    }

    @Cacheable(value={"eip:sys:userMenu"}, key="#currentUser.userId")
    protected String getMenuByUserId(IUser currentUser) throws IOException {
        List<SysMenu> dbMenus = null;
        if (currentUser.isAdmin()) {
            dbMenus = this.getAllByTenant(null);
        }
        if (BeanUtils.isEmpty(dbMenus)) {
            List roles = this.uCFeignService.getRoleListByAccount(currentUser.getAccount());
            ArrayList<String> roleCodes = new ArrayList<String>();
            if (BeanUtils.isNotEmpty((Object)roles)) {
                for (ObjectNode role : roles) {
                    if (1 != JsonUtil.getInt((JsonNode)role, (String)"enabled", (int)0)) continue;
                    roleCodes.add(role.get("code").asText());
                }
                if (BeanUtils.isNotEmpty(roleCodes)) {
                    String tenantId = this.saaSConfig.isEnable() ? this.baseContext.getCurrentTenantId() : null;
                    try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
                        List ignoreMenus = null;
                        if (this.saaSConfig.isEnable() && !"-1".equals(currentUser.getTenantId())) {
                            ignoreMenus = this.uCFeignService.getIgnoreMenuCodes(currentUser.getTenantId());
                        }
                        dbMenus = ((SysMenuDao)this.baseMapper).getMenuByRoleAlias(roleCodes, tenantId, BeanUtils.isEmpty(ignoreMenus) ? null : ignoreMenus, this.getTenantIds());
                    }
                    catch (Exception e) {
                        throw new BaseException((Throwable)e);
                    }
                }
            }
        }
        if (BeanUtils.isEmpty(dbMenus)) {
            dbMenus = new ArrayList<SysMenu>();
        }
        this.unique(dbMenus);
        this.dealCurgetLayoutManage(dbMenus);
        String json = JsonUtil.toJson(dbMenus);
        return json;
    }

    private void dealCurgetLayoutManage(List<SysMenu> menuList) {
        IUser currentUser = ContextUtil.getCurrentUser();
        HashSet deleteIds = Sets.newHashSet();
        Map<Object, Object> filterMenu = Maps.newHashMap();
        List<SysAuthMenu> allAuthMenu = this.sysAuthMenuManager.getByTenantId(currentUser.getTenantId());
        if (BeanUtils.isNotEmpty(allAuthMenu)) {
            filterMenu = allAuthMenu.stream().collect(Collectors.toMap(SysAuthMenu::getMenuId, SysAuthMenu::getAuthorizeId));
        }
        Optional<SysMenu> homePageMenu = menuList.stream().filter(item -> "homePage".equals(item.getAlias())).findFirst();
        List authIds = Lists.newArrayList();
        if (!currentUser.isAdmin()) {
            authIds = this.portalFeignService.getAuthorizeIdsByUserMap("layoutManage");
        }
        List<Object> homePageList = Lists.newArrayList();
        Set authIdSet = authIds.stream().collect(Collectors.toSet());
        if (homePageMenu.isPresent() && (homePageList = menuList.stream().filter(item -> ((SysMenu)((Object)((Object)((Object)homePageMenu.get())))).getId().equals(item.getParentId()) && StringUtil.isNotEmpty((String)item.getRouteExtend())).collect(Collectors.toList())).size() > 0) {
            Set alias = Sets.newHashSet();
            if (currentUser.isAdmin()) {
                alias = this.portalFeignService.getDisabledLayoutManageAlias().stream().collect(Collectors.toSet());
            } else if (BeanUtils.isNotEmpty((Object)authIds)) {
                alias = this.portalFeignService.getLayoutManageAliasByIds(authIds).stream().collect(Collectors.toSet());
            }
            for (SysMenu sysMenu : homePageList) {
                String routeExtend = sysMenu.getRouteExtend();
                try {
                    String[] split;
                    String param;
                    JsonNode jsonNode = JsonUtil.toJsonNode((String)routeExtend);
                    String path = jsonNode.get("path").asText();
                    if (!StringUtil.isNotEmpty((String)path) || path.indexOf("?") == -1 || path.indexOf("?") == path.length() - 1 || !StringUtil.isNotEmpty((String)(param = path.substring(path.indexOf("?") + 1)))) continue;
                    for (String s : split = param.split("&")) {
                        if (!s.startsWith("alias=")) continue;
                        String replace = s.replace("alias=", "");
                        if (!currentUser.isAdmin() && StringUtil.isNotEmpty((String)replace) && (BeanUtils.isEmpty(alias) || !alias.contains(replace))) {
                            deleteIds.add(sysMenu.getId());
                        }
                        if (!currentUser.isAdmin() || !StringUtil.isNotEmpty((String)replace) || !alias.contains(replace)) continue;
                        deleteIds.add(sysMenu.getId());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        for (SysMenu sysMenu : menuList) {
            if (currentUser.isAdmin()) break;
            if (!filterMenu.containsKey(sysMenu.getId()) || authIdSet.contains(filterMenu.get(sysMenu.getId()))) continue;
            deleteIds.add(sysMenu.getId());
        }
        for (int i = menuList.size() - 1; i >= 0; --i) {
            if (!deleteIds.contains(menuList.get(i).getId())) continue;
            menuList.remove(i);
        }
    }

    @Override
    public List<SysMenu> getCurrentUserMenu() throws Exception {
        IUser currentUser = ContextUtil.getCurrentUser();
        if (BeanUtils.isEmpty((Object)currentUser)) {
            throw new BaseException("\u672a\u83b7\u53d6\u5230\u5f53\u524d\u767b\u5f55\u7528\u6237");
        }
        SysMenuManagerImpl bean = (SysMenuManagerImpl)AppUtil.getBean(this.getClass());
        String menuByUserId = bean.getMenuByUserId(currentUser);
        List<SysMenu> list = new ArrayList<SysMenu>();
        if (menuByUserId != null) {
            list = (List)JsonUtil.toBean((String)menuByUserId, (TypeReference)new TypeReference<List<SysMenu>>(){});
        }
        return list;
    }

    @Override
    public List<Map<String, Object>> getAllMenuRoleAlias(String roleAlias) {
        QueryWrapper<SysMenu> queryWrapper = this.getTenantQueryWrapper();
        List<Map<String, Object>> result = null;
        String tenantId = this.saaSConfig.isEnable() ? this.baseContext.getCurrentTenantId() : null;
        try (MultiTenantIgnoreResult multiTenantIgnoreResult = MultiTenantHandler.setThreadLocalIgnore();){
            result = ((SysMenuDao)this.baseMapper).getAllMenuRoleAlias(roleAlias, tenantId, queryWrapper);
            result.forEach(map -> {
                if (BeanUtils.isEmpty(map.get("isOpen"))) {
                    map.put("isOpen", 0);
                }
            });
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
        return result;
    }

    private void unique(List<SysMenu> objects) {
        for (int i = 0; i < objects.size() - 1; ++i) {
            for (int j = objects.size() - 1; j > i; --j) {
                if (!objects.get(j).getId().equals(objects.get(i).getId())) continue;
                objects.remove(j);
            }
        }
    }

    @Override
    public List<SysMenu> filterByMenuAlias(String menuAlias, List<SysMenu> lists, Set<String> filterMenuAliasSet) {
        ArrayList<SysMenu> result = new ArrayList<SysMenu>();
        if (BeanUtils.isEmpty(lists) || StringUtil.isEmpty((String)menuAlias)) {
            return result;
        }
        String pId = null;
        Iterator<SysMenu> iterator = lists.iterator();
        while (iterator.hasNext()) {
            SysMenu sysMenu = iterator.next();
            if (menuAlias.equals(sysMenu.getAlias())) {
                pId = sysMenu.getId();
            }
            if (!filterMenuAliasSet.contains(sysMenu.getAlias())) continue;
            iterator.remove();
        }
        if (StringUtil.isEmpty(pId)) {
            return result;
        }
        BeanUtils.listByPid(lists, pId, result);
        return BeanUtils.listToTree(result);
    }

    @Override
    public List<SysMenu> filterByAppCenter(String menuAlias, List<SysMenu> lists) {
        ArrayList<SysMenu> result = new ArrayList<SysMenu>();
        if (BeanUtils.isEmpty(lists) || StringUtil.isEmpty((String)menuAlias)) {
            return result;
        }
        String pId = null;
        for (SysMenu sysMenu : lists) {
            SysMenu appMenu;
            if (!menuAlias.equals(sysMenu.getAlias()) || (appMenu = this.getByAlias("app_menu")) == null) continue;
            pId = appMenu.getId();
            break;
        }
        if (StringUtil.isEmpty(pId)) {
            return result;
        }
        BeanUtils.listByPid(lists, pId, result);
        return BeanUtils.listToTree(result);
    }

    @Override
    public List<SysMenu> getMenuByRoleAlias(String roleAlias) {
        return ((SysMenuDao)this.baseMapper).getMenuByRoleAlias(Arrays.asList(roleAlias.split(",")), null, null, this.getTenantIds());
    }

    @Override
    public List<SysMenu> getAllByTenant(String ignoreAlias) {
        ArrayList<SysMenu> dbMenus = new ArrayList();
        QueryWrapper<SysMenu> queryWrapper = this.getTenantQueryWrapper();
        this.dealWithIgnoreQuery(queryWrapper, ignoreAlias);
        try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
            dbMenus = this.list((Wrapper)queryWrapper);
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
        return dbMenus;
    }

    private void dealWithIgnoreQuery(QueryWrapper<SysMenu> queryWrapper, String ignoreAlias) {
        if (StringUtil.isNotEmpty((String)ignoreAlias)) {
            String[] ignores = ignoreAlias.split(",");
            ArrayList<String> allIgnores = new ArrayList<String>();
            try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
                for (String alias : ignores) {
                    SysMenu menu = ((SysMenuDao)this.baseMapper).getByAlias(alias, this.getTenantIds());
                    if (!BeanUtils.isNotEmpty((Object)((Object)menu))) continue;
                    allIgnores.add(alias);
                    List<SysMenu> childrens = null;
                    childrens = ((SysMenuDao)this.baseMapper).getByChidrensParentPath(menu.getPath());
                    if (!BeanUtils.isNotEmpty(childrens)) continue;
                    for (SysMenu sysMenu : childrens) {
                        allIgnores.add(sysMenu.getAlias());
                    }
                }
            }
            catch (Exception e) {
                throw new BaseException(e.getMessage(), (Throwable)e);
            }
            if (BeanUtils.isNotEmpty(allIgnores)) {
                BeanUtils.removeDuplicate(allIgnores);
                allIgnores.addAll(TenantConstant.IGNORE_MENU);
                queryWrapper.and(consumer -> consumer.notIn((Object)"alias_", (Collection)allIgnores));
            }
        }
    }

    private List<String> getTenantIds() {
        ArrayList<String> tenantIds = new ArrayList<String>();
        if (this.saaSConfig.isEnable()) {
            tenantIds.add(this.baseContext.getCurrentTenantId());
            if (!"-1".equals(this.baseContext.getCurrentTenantId())) {
                tenantIds.add("-1");
            }
        }
        return tenantIds;
    }

    private QueryWrapper<SysMenu> getTenantQueryWrapper() {
        String currentTenantId = this.baseContext.getCurrentTenantId();
        QueryWrapper queryWrapper = new QueryWrapper();
        if (this.saaSConfig.isEnable()) {
            ((QueryWrapper)queryWrapper.or()).in((Object)this.multiTenantHandler.getTenantIdColumn(), Arrays.asList("-1", currentTenantId));
            if (!"-1".equals(currentTenantId)) {
                queryWrapper.and(consumer -> {
                    ArrayList allIgnoreMenus = new ArrayList();
                    allIgnoreMenus.addAll(TenantConstant.IGNORE_MENU);
                    try {
                        List ignoreMenus = this.uCFeignService.getIgnoreMenuCodes(currentTenantId);
                        if (BeanUtils.isNotEmpty((Object)ignoreMenus)) {
                            allIgnoreMenus.addAll(ignoreMenus);
                        }
                    }
                    catch (Exception e) {
                        throw new BaseException("\u83b7\u53d6\u5f53\u524d\u79df\u6237\u7981\u7528\u83dc\u5355\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
                    }
                    ArrayList<String> allIgnores = new ArrayList<String>();
                    try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
                        for (String alias : allIgnoreMenus) {
                            allIgnores.add(alias);
                            SysMenu menu = ((SysMenuDao)this.baseMapper).getByAlias(alias, this.getTenantIds());
                            if (!BeanUtils.isNotEmpty((Object)((Object)menu))) continue;
                            List<SysMenu> childrens = null;
                            childrens = ((SysMenuDao)this.baseMapper).getByChidrensParentPath(menu.getPath());
                            if (!BeanUtils.isNotEmpty(childrens)) continue;
                            for (SysMenu sysMenu : childrens) {
                                allIgnores.add(sysMenu.getAlias());
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new BaseException(e.getMessage(), (Throwable)e);
                    }
                    if (BeanUtils.isNotEmpty(allIgnores)) {
                        consumer.notIn((Object)"alias_", allIgnores);
                    }
                });
            }
        } else {
            queryWrapper.notIn((Object)"alias_", new Object[]{"tenant", "tenantManager", "tenantTypeManager", "tenantParamsManager"});
        }
        queryWrapper.orderByAsc((Object)"sn_");
        return queryWrapper;
    }

    private void removeUserMenuCache() {
        SysMenuManagerImpl bean = (SysMenuManagerImpl)AppUtil.getBean(this.getClass());
        bean.delUserMenuCache();
    }

    @Override
    @CacheEvict(value={"eip:sys:userMenu"}, allEntries=true)
    public void delUserMenuCache() {
    }

    @Override
    public List<SysMenu> getByChidrensParentPath(String path) {
        return ((SysMenuDao)this.baseMapper).getByChidrensParentPath(path);
    }

    private String getMenuTypeDesc(SysMenu sysMenu) {
        for (FrontTypeConstant type : FrontTypeConstant.values()) {
            if (!sysMenu.getPath().startsWith(type.menuPathPrefix())) continue;
            return type.label();
        }
        return "";
    }

    public void getTreeMenu(SysMenu sysMenu, SysMenu parentMenu, boolean cover) throws Exception {
        if (StringUtil.isNotEmpty((String)this.getMenuTypeDesc(parentMenu)) && !this.getMenuTypeDesc(parentMenu).equals(this.getMenuTypeDesc(sysMenu))) {
            throw new BaseException(String.format("\u4e0d\u80fd\u5c06[%s]\u83dc\u5355\u5bfc\u5165[%s]", this.getMenuTypeDesc(sysMenu), this.getMenuTypeDesc(parentMenu)));
        }
        SysMenu menu = this.getByAlias(sysMenu.getAlias());
        if (BeanUtils.isNotEmpty((Object)((Object)menu))) {
            if (StringUtil.isNotEmpty((String)this.getMenuTypeDesc(parentMenu)) && !this.getMenuTypeDesc(parentMenu).equals(this.getMenuTypeDesc(menu))) {
                throw new BaseException(String.format("\u83dc\u5355[%s]\u7684\u522b\u540d[%s]\uff0c\u5df2\u88ab%s\u83dc\u5355[%s]\u4f7f\u7528", sysMenu.getName(), sysMenu.getAlias(), this.getMenuTypeDesc(menu), menu.getName()));
            }
            if (!cover) {
                throw new DataExistException("\u83dc\u5355\u5df2\u5b58\u5728\uff0c\u5bfc\u5165\u5c06\u76f4\u63a5\u8986\u76d6\u83dc\u5355\u6570\u636e\uff0c\u662f\u5426\u7ee7\u7eed\u64cd\u4f5c\uff1f");
            }
            menu.setName(sysMenu.getName());
            menu.setSn(sysMenu.getSn());
            menu.setTabsStyle(sysMenu.getTabsStyle());
            menu.setActiveTab(sysMenu.getActiveTab());
            menu.setRouterExtend(sysMenu.getRouteExtend());
            this.update(menu);
        } else {
            sysMenu.setParentId(parentMenu.getId());
            String nId = UniqueIdUtil.getSuid();
            if (FrontTypeConstant.fromKey(sysMenu.getAlias().replace("_menu", "")) != null) {
                nId = FrontTypeConstant.fromKey(sysMenu.getAlias().replace("_menu", "")).id();
            }
            sysMenu.setId(nId);
            sysMenu.setPath(parentMenu.getPath() + nId + ".");
            sysMenu.setTenantId(null);
            this.create(sysMenu);
        }
        for (Object chirden : sysMenu.getChildren()) {
            SysMenu subMenu = null;
            if (chirden instanceof SysMenu) {
                subMenu = (SysMenu)((Object)chirden);
            } else {
                String jsonString = JsonUtil.toJsonString(chirden);
                subMenu = (SysMenu)((Object)JsonUtil.toBean((String)jsonString, SysMenu.class));
            }
            this.getTreeMenu(subMenu, sysMenu, cover);
        }
    }

    @Override
    @Transactional
    public void importFile(String unZipFilePath, String parentMenuId, String cacheMenuJson) throws Exception {
        SysMenu baseParentMenu = this.get((Serializable)((Object)parentMenuId));
        List<SysMenu> sysMenuList = new ArrayList();
        boolean isCover = false;
        if (StringUtil.isNotEmpty((String)cacheMenuJson)) {
            sysMenuList = (List)JsonUtil.toBean((String)cacheMenuJson, (TypeReference)new TypeReference<List<SysMenu>>(){});
            isCover = true;
        } else {
            String json = FileUtil.readFile((String)(unZipFilePath + File.separator + "sysMenus.json"));
            List list = (List)JsonUtil.toBean((String)json, List.class);
            for (Object o : list) {
                SysMenu sysMenu = (SysMenu)((Object)JsonUtil.toBean((String)JsonUtil.toJson(o), SysMenu.class));
                sysMenuList.add(sysMenu);
            }
            sysMenuList = BeanUtils.listToTree(sysMenuList);
        }
        try {
            for (int i = 0; i < sysMenuList.size(); ++i) {
                SysMenu sysMenu = (SysMenu)((Object)sysMenuList.get(i));
                this.getTreeMenu(sysMenu, baseParentMenu, isCover);
            }
        }
        catch (Exception e) {
            if (e instanceof DataExistException) {
                String cacheFileId = UniqueIdUtil.getSuid();
                ((SysMenuManagerImpl)AppUtil.getBean(this.getClass())).putImportFileInCache(cacheFileId, JsonUtil.toJson(sysMenuList));
                ((DataExistException)e).setMessage(cacheFileId);
            }
            throw e;
        }
    }

    @Override
    @Transactional
    public void update(SysMenu menu, String parentId) {
        SysMenu parentMenu = this.get((Serializable)((Object)parentId));
        if (BeanUtils.isEmpty((Object)((Object)parentMenu))) {
            throw new BaseException(String.format("\u66f4\u65b0\u7684\u7236\u8282\u70b9ID\uff1a%s\u4e0d\u5b58\u5728\uff0c\u66f4\u65b0\u5931\u8d25\uff01", parentId));
        }
        String ocurpath = menu.getPath();
        String ncurpath = parentMenu.getPath() + menu.getId() + ".";
        List<SysMenu> chidrens = this.getByChidrensParentPath(ocurpath);
        if (BeanUtils.isNotEmpty(chidrens)) {
            for (SysMenu sysMenu : chidrens) {
                if (sysMenu.getId().equals(menu.getId())) continue;
                String opath = sysMenu.getPath();
                opath = opath.replace(ocurpath, ncurpath);
                sysMenu.setPath(opath);
                this.update(sysMenu);
            }
        }
        menu.setParentId(parentId);
        menu.setPath(ncurpath);
        this.update(menu);
    }

    @Override
    public CommonResult<String> saveMenus(List<SysMenu> list) {
        List oldList = this.list();
        HashMap<String, SysMenu> oldMap = new HashMap<String, SysMenu>();
        for (SysMenu sysMenu : oldList) {
            oldMap.put(sysMenu.getId(), sysMenu);
        }
        ArrayList<SysMenu> changeMenus = new ArrayList<SysMenu>();
        for (SysMenu menu : list) {
            if (menu.equals((SysMenu)((Object)oldMap.get(menu.getId())))) continue;
            changeMenus.add(menu);
        }
        for (SysMenu sysMenu : changeMenus) {
            this.update(sysMenu);
        }
        this.delUserMenuCache();
        return new CommonResult("\u4fdd\u5b58\u6210\u529f");
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @GlobalTransactional
    public CommonResult<String> saveMenus(SysMenu sysMenu, Optional<String> parentId) throws Exception {
        String resultMsg = null;
        String id = sysMenu.getId();
        if (StringUtil.isEmpty((String)sysMenu.getType())) {
            sysMenu.setType("catalog");
        }
        this.validateRoutePath(sysMenu);
        if (StringUtil.isEmpty((String)id)) {
            if (this.isExistByAlias(sysMenu.getAlias())) {
                throw new BaseException("\u83dc\u5355\u522b\u540d\u5df2\u5b58\u5728");
            }
            if (!this.validSysMethodAlias(sysMenu.getSysMethods())) {
                return new CommonResult(false, "\u8bf7\u6c42\u65b9\u6cd5\u522b\u540d\u91cd\u590d");
            }
            sysMenu.setId(UniqueIdUtil.getSuid());
            sysMenu.setPath(sysMenu.getPath() + sysMenu.getId() + ".");
            if (BeanUtils.isEmpty((Object)sysMenu.getSn())) {
                sysMenu.setSn(99);
            }
            this.create(sysMenu);
            if ("-1".equals(TenantUtil.getCurrentTenantId())) {
                this.ucFeignService.saveIgnoreMenuByCodes(Collections.singletonList(sysMenu.getAlias()));
            }
            resultMsg = "\u6dfb\u52a0\u83dc\u5355\u4fe1\u606f\u6210\u529f";
        } else {
            if (!this.validSysMethodAlias(sysMenu.getSysMethods())) {
                return new CommonResult(false, "\u8bf7\u6c42\u65b9\u6cd5\u522b\u540d\u91cd\u590d");
            }
            if (StringUtil.isNotEmpty((String)parentId.orElse(""))) {
                this.update(sysMenu, parentId.get());
            } else {
                this.update(sysMenu);
            }
            resultMsg = "\u66f4\u65b0\u83dc\u5355\u4fe1\u606f\u6210\u529f";
        }
        this.delUserMenuCache();
        return new CommonResult(true, resultMsg);
    }

    private void getSysRoleAuthList(SysMenu sysMenu, List<SysRoleAuth> sysRoleAuthList, String parentId, List<String> records) {
        SysMenu menu = this.get((Serializable)((Object)parentId));
        List<SysRoleAuth> parentSysRoleAuths = this.sysRoleAuthManager.getSysRoleAuthByMenuAlias(menu.getAlias());
        parentSysRoleAuths = parentSysRoleAuths.stream().filter(sysRoleAuth -> Integer.valueOf("1").equals(sysRoleAuth.getIsOpen())).collect(Collectors.toList());
        for (SysRoleAuth parentSysRoleAuth : parentSysRoleAuths) {
            if (records.contains(parentSysRoleAuth.getRoleAlias())) continue;
            records.add(parentSysRoleAuth.getRoleAlias());
            sysRoleAuthList.add(new SysRoleAuth(UniqueIdUtil.getSuid(), parentSysRoleAuth.getRoleAlias(), sysMenu.getAlias(), 0));
        }
        if (!"-1".equals(menu.getParentId()) && StringUtil.isNotEmpty((String)menu.getParentId())) {
            this.getSysRoleAuthList(sysMenu, sysRoleAuthList, menu.getParentId(), records);
        }
    }

    private void validateRoutePath(SysMenu menu) throws Exception {
        if (!menu.getPath().startsWith("-1.3.") || menu.getId().equals("3") || !"page".equals(menu.getType())) {
            return;
        }
        if (StringUtil.isEmpty((String)menu.getRouteExtend())) {
            return;
        }
        JsonNode routeExtend = JsonUtil.toJsonNode((String)menu.getRouteExtend());
        if (routeExtend.has("path")) {
            String path = routeExtend.get("path").asText();
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            if (StringUtil.isNotEmpty((String)menu.getId())) {
                query.ne(SysMenu::getId, (Object)menu.getId());
            }
            ((LambdaQueryWrapper)((LambdaQueryWrapper)query.eq(SysMenu::getType, (Object)"page")).likeRight(SysMenu::getPath, (Object)"-1.3.")).like(SysMenu::getRouteExtend, (Object)path);
            List existList = this.list((Wrapper)query);
            ArrayList<String> pathExistMenuName = new ArrayList<String>();
            for (SysMenu sysMenu : existList) {
                String ePath;
                JsonNode r;
                if (StringUtil.isEmpty((String)sysMenu.getRouteExtend()) || !(r = JsonUtil.toJsonNode((String)sysMenu.getRouteExtend())).has("path") || !path.equals(ePath = r.get("path").asText())) continue;
                pathExistMenuName.add(sysMenu.getName());
            }
            if (pathExistMenuName.size() > 0) {
                throw new BaseException("\u8def\u7531\u914d\u7f6e\u7684path\u5df2\u5b58\u5728\uff0c\u5df2\u88ab\u83dc\u5355[" + StringUtil.join(pathExistMenuName) + "]\u4f7f\u7528");
            }
        }
    }

    private boolean validSysMethodAlias(List<SysMethod> sysMethods) {
        for (int i = 0; i < sysMethods.size() - 1; ++i) {
            for (int j = i + 1; j < sysMethods.size(); ++j) {
                if (!sysMethods.get(i).getAlias().equals(sysMethods.get(j).getAlias())) continue;
                return false;
            }
        }
        if (CollectionUtils.isNotEmpty(sysMethods)) {
            Map<String, String> aliasMap = sysMethods.stream().collect(Collectors.toMap(SysMethod::getAlias, sysMethod -> StringUtil.isNotEmpty((String)sysMethod.getId()) ? sysMethod.getId() : ""));
            String tenantId = ContextUtil.getCurrentUser().getTenantId();
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().in(SysMethod::getAlias, aliasMap.keySet())).eq(SysMethod::getTenantId, (Object)tenantId);
            List sysMethodList = this.sysMethodDao.selectList((Wrapper)wrapper);
            for (SysMethod sysMethod2 : sysMethodList) {
                if (sysMethod2.getId().equals(aliasMap.get(sysMethod2.getAlias()))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public CommonResult<String> saveDataByBatch(List<SysMenu> list) {
        String resultMsg = "";
        for (int k = 0; k < list.size(); ++k) {
            List<SysMethod> sysMethods = list.get(k).getSysMethods();
            if (!this.validSysMethodAlias(sysMethods)) {
                return new CommonResult(false, "\u8bf7\u6c42\u65b9\u6cd5\u522b\u540d\u91cd\u590d");
            }
            this.update(list.get(k));
        }
        resultMsg = "\u66f4\u65b0\u83dc\u5355\u4fe1\u606f\u6210\u529f";
        this.delUserMenuCache();
        return new CommonResult(true, resultMsg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResult<String> importData(MultipartHttpServletRequest request, String parentMenuId) {
        MultipartFile file = request.getFile("file");
        String unZipFilePath = "";
        try {
            String rootRealPath = (FileUtil.getIoTmpdir() + "/attachFiles/unZip/").replace("/", File.separator);
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            String name = file.getOriginalFilename();
            String fileDir = StringUtil.substringBeforeLast((String)name, (String)".");
            ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            unZipFilePath = rootRealPath + File.separator + fileDir;
            this.importFile(unZipFilePath, parentMenuId, "");
            CommonResult commonResult = new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
            return commonResult;
        }
        catch (Exception e) {
            if (e instanceof DataExistException) {
                CommonResult commonResult = CommonResult.ok().value((Object)("\u83dc\u5355\u5df2\u5b58\u5728:" + e.getMessage()));
                return commonResult;
            }
            CommonResult commonResult = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
            return commonResult;
        }
        finally {
            File zipFile;
            if (StringUtil.isNotEmpty((String)unZipFilePath) && (zipFile = new File(unZipFilePath)).exists()) {
                zipFile.delete();
            }
        }
    }

    @Override
    public SysMenu getJson(String id) throws Exception {
        SysMenu sysMenu = new SysMenu();
        sysMenu.setOpen(true);
        if (!StringUtil.isEmpty((String)id)) {
            try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
                sysMenu = (SysMenu)this.sysMenuManager.get((Serializable)((Object)id));
            }
        }
        return sysMenu;
    }

    @Override
    public Map<String, List<String>> getCurrentUserMethodAuth() {
        List all = this.sysMethodManager.list();
        ArrayList<String> sysMethodList = new ArrayList<String>();
        for (SysMethod sysMethod : all) {
            sysMethodList.add(sysMethod.getAlias());
        }
        IUser currentUser = ContextUtil.getCurrentUser();
        List<String> curUserMethod = sysMethodList;
        if (!currentUser.isAdmin()) {
            curUserMethod = this.sysMethodManager.getCurrentUserMethodAuth();
        }
        HashMap<String, List<String>> rtnMap = new HashMap<String, List<String>>();
        rtnMap.put("allMethod", sysMethodList);
        rtnMap.put("curUserMethod", curUserMethod);
        return rtnMap;
    }

    @Override
    public List<SysMenu> getAppMenuByAuthApp(String menuAlias) {
        List sysMenus;
        ArrayList result = new ArrayList();
        QueryFilter sysAppQueryFilter = QueryFilter.build();
        sysAppQueryFilter.setPageBean(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        List sysAppPageList = this.sysAppManager.queryByFilter((QueryFilter<SysApp>)sysAppQueryFilter).getRows();
        List menuIds = sysAppPageList.stream().map(SysApp::getMenuId).distinct().collect(Collectors.toList());
        try (MultiTenantIgnoreResult ignored = MultiTenantHandler.setThreadLocalIgnore();){
            QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().and(w -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)w.in(BeanUtils.isNotEmpty((Object)menuIds), (Object)"id_", (Collection)menuIds)).or()).eq((Object)"alias_", (Object)menuAlias);
            })).and(w -> {
                QueryWrapper cfr_ignored_0 = (QueryWrapper)w.in((Object)this.multiTenantHandler.getTenantIdColumn(), Arrays.asList("-1", this.baseContext.getCurrentTenantId()));
            })).orderByAsc((Object)"sn_");
            List<String> parentIds = this.getParentIds(this.list((Wrapper)wrapper));
            sysMenus = this.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().in(SysMenu::getId, parentIds)).orderByAsc(SysMenu::getSn));
        }
        catch (Exception e) {
            throw new BaseException((Throwable)e);
        }
        List parentId = sysMenus.stream().filter(sysMenu -> sysMenu.getAlias().equals(menuAlias)).map(SysMenu::getId).collect(Collectors.toList());
        if (BeanUtils.isNotEmpty(parentId)) {
            BeanUtils.listByPid((List)sysMenus, (String)((String)parentId.get(0)), result);
        }
        return BeanUtils.listToTree(result);
    }

    private List<String> getParentIds(List<SysMenu> sysMenus) {
        ArrayList parentIds = new ArrayList();
        sysMenus.forEach(system -> {
            String[] ids = system.getPath().split("\\.");
            List<String> list = Arrays.asList(ids);
            parentIds.addAll(list);
        });
        return parentIds.stream().distinct().collect(Collectors.toList());
    }

    @Override
    public List<SysMenu> getMenusByTemplateAlias(String templateAlias, String pathPrefix) {
        String _alias = String.format("?templateKey=%s", templateAlias.replaceAll("-", "_"));
        return ((SysMenuDao)this.baseMapper).getByTemplateAlias(_alias, pathPrefix);
    }

    @Override
    public CommonResult<String> getFirstMenuRouterPathByTemplateAlias(String templateAlias, FrontTypeConstant frontType) throws Exception {
        List menus;
        QueryWrapper menuwp;
        if (FrontTypeConstant.manage.equals((Object)frontType)) {
            menuwp = new QueryWrapper();
            menuwp.like((Object)"ALIAS_", (Object)String.format("/%s/", templateAlias));
            if (StringUtil.isNotEmpty((String)frontType.menuPathPrefix())) {
                menuwp.like((Object)"PATH_", (Object)frontType.menuPathPrefix());
            }
            if (BeanUtils.isNotEmpty((Object)(menus = this.list((Wrapper)menuwp)))) {
                SysMenu menu = (SysMenu)((Object)menus.get(0));
                String alias = menu.getAlias();
                if (!alias.startsWith("/")) {
                    alias = "/" + alias;
                }
                return CommonResult.ok().value((Object)alias);
            }
        }
        if (FrontTypeConstant.front.equals((Object)frontType)) {
            menuwp = new QueryWrapper();
            menuwp.like((Object)"ROUTE_EXTEND_", (Object)templateAlias);
            if (StringUtil.isNotEmpty((String)frontType.menuPathPrefix())) {
                menuwp.like((Object)"PATH_", (Object)frontType.menuPathPrefix());
            }
            if (BeanUtils.isNotEmpty((Object)(menus = this.list((Wrapper)menuwp)))) {
                SysMenu menu = (SysMenu)((Object)menus.get(0));
                String path = menu.getPath();
                String routerPath = "";
                String[] parentIds = path.split("\\.");
                if (parentIds.length > 3) {
                    for (int i = 2; i < parentIds.length - 1; ++i) {
                        String parentId = parentIds[i];
                        SysMenu parentMenu = (SysMenu)((Object)((SysMenuDao)this.baseMapper).selectById((Serializable)((Object)parentId)));
                        String routeExtend = parentMenu.getRouteExtend();
                        routerPath = routerPath + this.parseRouterPath(routeExtend);
                    }
                }
                routerPath = routerPath + this.parseRouterPath(menu.getRouteExtend());
                return CommonResult.ok().value((Object)routerPath);
            }
            return CommonResult.ok();
        }
        return CommonResult.ok();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public SysMenu getByIdAndTenant(String id, String tenantId) {
        LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(SysMenu::getId, (Object)id)).eq(SysMenu::getTenantId, (Object)tenantId);
        try (MultiTenantIgnoreResult multiTenantIgnoreResult = MultiTenantHandler.setThreadLocalIgnore();){
            SysMenu sysMenu = (SysMenu)((Object)this.getOne((Wrapper)query));
            return sysMenu;
        }
        catch (Exception e) {
            return null;
        }
    }

    private String parseRouterPath(String routeExtend) throws Exception {
        String routerPath = "";
        if (StringUtil.isEmpty((String)routeExtend)) {
            return routerPath;
        }
        JsonNode jsonNode = JsonUtil.toJsonNode((String)routeExtend);
        String parentRouterPath = JsonUtil.getString((JsonNode)jsonNode, (String)"path");
        if (StringUtil.isNotEmpty((String)parentRouterPath)) {
            if (!parentRouterPath.startsWith("/")) {
                routerPath = routerPath + "/";
            }
            routerPath = routerPath + parentRouterPath.split("\\?")[0];
        }
        return routerPath;
    }

    public static void main(String[] args) {
        String s = "/appConter";
        System.out.println(s.startsWith("/"));
        String[] aaa = s.split("\\?");
        System.out.println(aaa);
    }

    @Override
    public void createMenuAndAuth(String authorizeId, SysMenu sysMenu) {
        SysAuthMenu sysAuthMenu = new SysAuthMenu();
        sysAuthMenu.setId(UniqueIdUtil.getSuid());
        sysAuthMenu.setAuthorizeId(authorizeId);
        sysAuthMenu.setMenuId(sysMenu.getId());
        this.sysAuthMenuManager.create((Model)sysAuthMenu);
        this.sysAuthMenuManager.delCacheByTenantId(ContextUtil.getCurrentUser().getTenantId());
    }

    @Override
    public void updateFrontMenuPath() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.like((Object)"path_", (Object)FrontTypeConstant.front.menuPathPrefix());
        try (MultiTenantIgnoreResult setThreadLocalIgnore = MultiTenantHandler.setThreadLocalIgnore();){
            List Menus = this.list((Wrapper)queryWrapper);
            ArrayList updates = new ArrayList();
            Menus.forEach(m -> {
                if (StringUtil.isNotEmpty((String)m.getRouteExtend())) {
                    try {
                        ObjectNode routeObj = (ObjectNode)JsonUtil.toJsonNode((String)m.getRouteExtend());
                        String routerPath = JsonUtil.getString((JsonNode)routeObj, (String)"path").replaceAll("\\/", "");
                        if (!m.getAlias().equalsIgnoreCase(routerPath)) {
                            routeObj.put("path", StringUtil.lowerFirst((String)m.getAlias()));
                            m.setRouterExtend(JsonUtil.toJsonString((Object)routeObj));
                            updates.add(m);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            });
            if (BeanUtils.isNotEmpty(updates)) {
                this.updateBatchById(updates);
            }
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @CachePut(value={"eip:sys:menuImportFile"}, key="#fileId", firstCache=@FirstCache(expireTime=1, timeUnit=TimeUnit.HOURS))
    public String putImportFileInCache(String fileId, String fileJson) {
        return fileJson;
    }

    @Override
    @Cacheable(value={"eip:sys:menuImportFile"}, key="#fileId", firstCache=@FirstCache(expireTime=1, timeUnit=TimeUnit.HOURS))
    public String getImportFileFromCache(String fileId) {
        return null;
    }

    @Override
    public List<SysMenu> setTopMenu(List<SysMenu> result) {
        if (BeanUtils.isNotEmpty(result)) {
            String parentId = result.get(0).getParentId();
            List<SysMenu> sysMenus = this.recursionSetTop(result, parentId);
            return sysMenus;
        }
        return result;
    }

    private List<SysMenu> recursionSetTop(List<SysMenu> sysMenus, String parentId) {
        SysMenu sysMenu = this.get((Serializable)((Object)parentId));
        if (BeanUtils.isNotEmpty((Object)((Object)sysMenu)) && !"-1".equals(sysMenu.getId())) {
            sysMenu.setChildren(sysMenus);
            ArrayList<SysMenu> tempSysMenus = new ArrayList<SysMenu>();
            tempSysMenus.add(sysMenu);
            this.i18nSysMenu(tempSysMenus);
            return this.recursionSetTop(tempSysMenus, sysMenu.getParentId());
        }
        return sysMenus;
    }

    @Override
    public List<SysMenu> i18nSysMenu(List<SysMenu> lists) {
        ArrayList<String> i18nKey = new ArrayList<String>();
        for (SysMenu sysMenu : lists) {
            i18nKey.add(sysMenu.getAlias());
        }
        Map messages = I18nUtil.getMessages(i18nKey, (Locale)LocaleContextHolder.getLocale());
        for (SysMenu sysMenu : lists) {
            String key = sysMenu.getAlias();
            if (!messages.containsKey(key) || !StringUtil.isNotEmpty((String)((String)messages.get(key)))) continue;
            String oldName = sysMenu.getName();
            String newName = (String)messages.get(key);
            sysMenu.setName(newName);
            if (!StringUtil.isNotEmpty((String)sysMenu.getRouteExtend())) continue;
            sysMenu.setRouterExtend(sysMenu.getRouteExtend().replace(oldName, newName));
        }
        return lists;
    }

    @Override
    public List<SysMenu> getMenusByAlias(List<String> alias) throws Exception {
        List<SysMenu> currentUserMenu = this.getCurrentUserMenu();
        return currentUserMenu.stream().filter(item -> alias.contains(item.getAlias())).collect(Collectors.toList());
    }
}

