/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.sys.persistence.manager.impl;

import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.hotent.base.cache.annotation.CacheEvict;
import com.hotent.base.exception.ServerRejectException;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.sys.persistence.dao.SysRoleAuthDao;
import com.hotent.sys.persistence.manager.SysRoleAuthManager;
import com.hotent.sys.persistence.model.SysRoleAuth;
import com.hotent.sys.persistence.param.SysRoleAuthParam;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="sysRoleAuthManager")
public class SysRoleAuthManagerImpl
extends BaseManagerImpl<SysRoleAuthDao, SysRoleAuth>
implements SysRoleAuthManager {
    @Value(value="${system.mode.demo:false}")
    protected boolean demoMode;
    @Resource
    SysRoleAuthDao sysRoleAuthDao;

    private void removeMethodRoleAuth() {
        SysRoleAuthManagerImpl bean = (SysRoleAuthManagerImpl)AppUtil.getBean(this.getClass());
        bean.delMethodRoleAuth();
    }

    @CacheEvict(value={"eip:sys:methodAuth"}, allEntries=true)
    protected void delMethodRoleAuth() {
    }

    @Override
    public void removeUserMenu() {
        SysRoleAuthManagerImpl bean = (SysRoleAuthManagerImpl)AppUtil.getBean(this.getClass());
        bean.delUserMenu();
    }

    @CacheEvict(value={"eip:sys:userMenu"}, allEntries=true)
    protected void delUserMenu() {
    }

    private void removeDataPermission() {
        SysRoleAuthManagerImpl bean = (SysRoleAuthManagerImpl)AppUtil.getBean(this.getClass());
        bean.delDataPermission();
    }

    @CacheEvict(value={"eip:sys:dataPermission"}, allEntries=true)
    protected void delDataPermission() {
    }

    @Override
    public List<SysRoleAuth> getSysRoleAuthByRoleAlias(String roleAlias) {
        return ((SysRoleAuthDao)this.baseMapper).getSysRoleAuthByRoleAlias(roleAlias);
    }

    @Override
    public List<String> getMenuAliasByRoleAlias(String roleAlias) {
        return ((SysRoleAuthDao)this.baseMapper).getMenuAliasByRoleAlias(roleAlias);
    }

    @Override
    public List<String> getMethodAliasByRoleAlias(String roleAlias) {
        return ((SysRoleAuthDao)this.baseMapper).getMethodAliasByRoleAlias(roleAlias);
    }

    @Override
    public void removeByRoleAlias(String roleAlias) {
        ((SysRoleAuthDao)this.baseMapper).removeByRoleAlias(roleAlias);
    }

    @Override
    public void removeByArrRoleAlias(String[] aryroleAlias) {
        for (String roleAlias : aryroleAlias) {
            ((SysRoleAuthDao)this.baseMapper).removeByRoleAlias(roleAlias);
        }
        this.removeMethodRoleAuth();
        this.removeUserMenu();
        this.removeDataPermission();
    }

    @Override
    public void create(SysRoleAuthParam sysRoleAuthParam) {
        SysRoleAuth sysRoleAuth;
        if (this.demoMode) {
            throw new ServerRejectException("\u6f14\u793a\u6a21\u5f0f\u4e0b\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c");
        }
        ((SysRoleAuthDao)this.baseMapper).removeMenuAuthByRoleAlias(sysRoleAuthParam.getRoleAlias());
        List<Map<String, String>> arrMenuAlias = sysRoleAuthParam.getArrMenuAlias();
        ArrayList<SysRoleAuth> sysRoleAuthList = new ArrayList<SysRoleAuth>();
        for (Map<String, String> menuAliasMap : arrMenuAlias) {
            for (String menuAlias : menuAliasMap.keySet()) {
                sysRoleAuth = new SysRoleAuth();
                sysRoleAuth.setRoleAlias(sysRoleAuthParam.getRoleAlias());
                sysRoleAuth.setId(UniqueIdUtil.getSuid());
                sysRoleAuth.setMenuAlias(menuAlias);
                Integer isOpen = null;
                try {
                    String isOpenStr = menuAliasMap.getOrDefault(menuAlias, null);
                    if (isOpenStr != null) {
                        isOpen = Integer.valueOf(isOpenStr);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                sysRoleAuth.setIsOpen(isOpen);
                sysRoleAuthList.add(sysRoleAuth);
            }
        }
        super.saveBatch(sysRoleAuthList);
        sysRoleAuthList.clear();
        List<String> arrMethodAlias = sysRoleAuthParam.getArrMethodAlias();
        Map<String, String> dataPermission = sysRoleAuthParam.getDataPermission();
        for (String methodAlias : arrMethodAlias) {
            sysRoleAuth = new SysRoleAuth();
            sysRoleAuth.setRoleAlias(sysRoleAuthParam.getRoleAlias());
            sysRoleAuth.setId(UniqueIdUtil.getSuid());
            sysRoleAuth.setMethodAlias(methodAlias);
            sysRoleAuth.setDataPermission(dataPermission.get(methodAlias));
            sysRoleAuthList.add(sysRoleAuth);
        }
        super.saveBatch(sysRoleAuthList);
        this.removeMethodRoleAuth();
        this.removeUserMenu();
        this.removeDataPermission();
    }

    @Override
    public List<HashMap<String, String>> getSysRoleAuthAll() {
        ArrayList<HashMap<String, String>> result = new ArrayList<HashMap<String, String>>();
        ArrayList sysRoleAuths = (ArrayList)((SysRoleAuthDao)this.baseMapper).getSysRoleAuthAll();
        for (SysRoleAuth sysRoleAuth : sysRoleAuths) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("roleAlias", sysRoleAuth.getRoleAlias());
            map.put("methodRequestUrl", sysRoleAuth.getMethodRequestUrl());
            map.put("dataPermission", sysRoleAuth.getDataPermission());
            result.add(map);
        }
        return result;
    }

    @Override
    public void createCopy(String oldCode, String[] newCodes) {
        for (int i = 0; i < newCodes.length; ++i) {
            ((SysRoleAuthDao)this.baseMapper).removeByRoleAlias(newCodes[i]);
        }
        List<String> strList = this.getMenuAliasByRoleAlias(oldCode);
        for (int i = 0; i < newCodes.length; ++i) {
            for (String menuAlias : strList) {
                SysRoleAuth sysRoleAuth = new SysRoleAuth();
                sysRoleAuth.setId(UniqueIdUtil.getSuid());
                sysRoleAuth.setRoleAlias(newCodes[i]);
                sysRoleAuth.setMenuAlias(menuAlias);
                ((SysRoleAuthDao)this.baseMapper).insert((Object)sysRoleAuth);
            }
        }
        this.removeMethodRoleAuth();
        this.removeUserMenu();
    }

    @Override
    public void saveRoleMethods(SysRoleAuthParam sysRoleAuthParam) {
        if (this.demoMode) {
            throw new ServerRejectException("\u6f14\u793a\u6a21\u5f0f\u4e0b\u65e0\u6cd5\u6267\u884c\u8be5\u64cd\u4f5c");
        }
        SysRoleAuth sysRoleAuth = new SysRoleAuth();
        sysRoleAuth.setRoleAlias(sysRoleAuthParam.getRoleAlias());
        List<String> methodAliasByRoleAlias = this.getMethodAliasByRoleAlias(sysRoleAuth.getRoleAlias());
        List<String> arrMethodAlias = sysRoleAuthParam.getArrMethodAlias();
        Map<String, String> dataPermission = sysRoleAuthParam.getDataPermission();
        for (String methodAlias : arrMethodAlias) {
            sysRoleAuth.setId(UniqueIdUtil.getSuid());
            sysRoleAuth.setMethodAlias(methodAlias);
            sysRoleAuth.setDataPermission(dataPermission.get(methodAlias));
            if (methodAliasByRoleAlias.contains(methodAlias)) continue;
            this.create((Model)sysRoleAuth);
        }
        this.removeMethodRoleAuth();
        this.removeDataPermission();
    }

    @Override
    public void removeRoleMethods(String roleAlias, String[] methodAliasArr) {
        ((SysRoleAuthDao)this.baseMapper).removeRoleMethods(roleAlias, methodAliasArr);
        this.removeMethodRoleAuth();
        this.removeDataPermission();
    }

    @Override
    public List<SysRoleAuth> getSysRoleAuthByMenuAlias(String MenuAlias) {
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("menuAlias", (Object)MenuAlias, QueryOP.EQUAL);
        return this.queryNoPage(queryFilter);
    }
}

