/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.sys.persistence.manager.impl;

import com.hotent.base.exception.BaseException;
import com.hotent.base.exception.MessagePassingException;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.model.CommonResult;
import com.hotent.base.util.Base64;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.FileUtil;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.base.util.UniqueIdUtil;
import com.hotent.base.util.ZipUtil;
import com.hotent.sys.persistence.dao.SysSignetDao;
import com.hotent.sys.persistence.manager.SysSignetManager;
import com.hotent.sys.persistence.model.SysSignet;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="sysSignetManager")
public class SysSignetManagerImpl
extends BaseManagerImpl<SysSignetDao, SysSignet>
implements SysSignetManager {
    @Override
    public SysSignet getByAlias(String alias) {
        return ((SysSignetDao)this.baseMapper).getByAlias(alias);
    }

    @Override
    public String export(String[] idList) throws IOException {
        if (BeanUtils.isEmpty((Object)idList)) {
            return "";
        }
        ArrayList<SysSignet> list = new ArrayList<SysSignet>();
        for (String s : idList) {
            SysSignet sysSignet = (SysSignet)this.get((Serializable)((Object)s));
            list.add(sysSignet);
        }
        if (BeanUtils.isEmpty(list)) {
            return "";
        }
        return JsonUtil.toJson(list);
    }

    @Override
    @Transactional
    public Boolean importFile(String unZipFilePath) throws Exception {
        try {
            String signetFilePath = unZipFilePath + File.separator + "signet.json";
            if (!FileUtil.isExistFile((String)signetFilePath)) {
                throw new MessagePassingException("\u5bfc\u5165\u6587\u4ef6\u6821\u9a8c\u4e0d\u901a\u8fc7,\u8bf7\u68c0\u67e5\u6587\u4ef6\u914d\u7f6e");
            }
            String json = FileUtil.readFile((String)signetFilePath);
            List list = (List)JsonUtil.toBean((String)json, List.class);
            ArrayList<SysSignet> sysSignetList = new ArrayList<SysSignet>();
            for (Object item : list) {
                String identityStr = JsonUtil.toJson(item);
                SysSignet sysSignet = (SysSignet)((Object)JsonUtil.toBean((String)identityStr, SysSignet.class));
                SysSignet byAlias = ((SysSignetDao)this.baseMapper).getByAlias(sysSignet.getAlias());
                if (BeanUtils.isNotEmpty((Object)((Object)byAlias))) {
                    return false;
                }
                sysSignet.setTenantId(null);
                sysSignetList.add(sysSignet);
            }
            for (SysSignet sysSignet : sysSignetList) {
                sysSignet.setId(UniqueIdUtil.getSuid());
                ((SysSignetDao)this.baseMapper).insert((Object)sysSignet);
            }
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage());
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CommonResult<String> importIdentity(MultipartHttpServletRequest request, HttpServletResponse response) {
        MultipartFile file = request.getFile("file");
        String unZipFilePath = "";
        try {
            String rootRealPath = (FileUtil.getIoTmpdir() + "/attachFiles/unZip/").replace("/", File.separator);
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            String name = file.getOriginalFilename();
            String fileDir = StringUtil.substringBeforeLast((String)name, (String)".");
            ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            unZipFilePath = rootRealPath + File.separator + fileDir;
            Boolean isRepeat = this.importFile(unZipFilePath);
            if (!isRepeat.booleanValue()) {
                CommonResult commonResult = new CommonResult(true, "confirmUpload", (Object)Base64.getBase64Replace((String)unZipFilePath));
                return commonResult;
            }
            CommonResult commonResult = new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
            return commonResult;
        }
        catch (Exception e) {
            CommonResult commonResult = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
            return commonResult;
        }
        finally {
            File zipFile;
            if (StringUtil.isNotEmpty((String)unZipFilePath) && (zipFile = new File(unZipFilePath)).exists()) {
                zipFile.delete();
            }
        }
    }

    @Override
    public CommonResult<String> confirmImportIdentity(String unZipFilePath, String status) {
        try {
            String json = FileUtil.readFile((String)(Base64.getFromBase64Replace((String)unZipFilePath) + File.separator + "signet.json"));
            List list = (List)JsonUtil.toBean((String)json, List.class);
            for (Object item : list) {
                String identityStr = JsonUtil.toJson(item);
                SysSignet sysSignet = (SysSignet)((Object)JsonUtil.toBean((String)identityStr, SysSignet.class));
                SysSignet byAlias = ((SysSignetDao)this.baseMapper).getByAlias(sysSignet.getAlias());
                if (BeanUtils.isEmpty((Object)((Object)byAlias))) {
                    sysSignet.setId(UniqueIdUtil.getSuid());
                    ((SysSignetDao)this.baseMapper).insert((Object)sysSignet);
                    continue;
                }
                if (!"cover".equals(status)) continue;
                sysSignet.setId(byAlias.getId());
                ((SysSignetDao)this.baseMapper).updateById((Object)sysSignet);
            }
        }
        catch (Exception e) {
            throw new BaseException(e.getMessage());
        }
        return new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
    }
}

