/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.table.colmap;

import com.hotent.table.model.Column;
import com.hotent.table.model.impl.DefaultColumn;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.springframework.jdbc.core.RowMapper;

public class DmColumnMap
implements RowMapper<Column> {
    private static final List<String> CLOB_COLUMNS = Arrays.asList("CLOB", "BLOB", "BFILE", "TEXT", "IMAGE");
    private static final List<String> DATE_COLUMNS = Arrays.asList("DATE", "TIME", "TIMESTAMP", "DATETIME");
    private static final List<String> NUMBER_COLUMNS = Arrays.asList("NUMERIC", "NUMBER", "DECIMAL", "DEC", "INTEGER", "INT", "TINYINT", "SMALLINT", "BIGINT");

    public Column mapRow(ResultSet rs, int row) throws SQLException {
        DefaultColumn column = new DefaultColumn();
        String name = rs.getString("NAME");
        String typeName = rs.getString("TYPENAME");
        int length = rs.getInt("LENGTH");
        int precision = rs.getInt("PRECISION");
        int scale = rs.getInt("SCALE");
        boolean isNull = rs.getString("NULLABLE").equals("Y");
        String comments = rs.getString("DESCRIPTION");
        String tableName = rs.getString("TABLE_NAME");
        int isPK = rs.getInt("IS_PK");
        column.setFieldName(name);
        column.setComment(comments);
        column.setIsNull(isNull);
        column.setTableName(tableName);
        column.setIsPk(isPK == 1);
        this.setType(typeName, length, precision, scale, column);
        return column;
    }

    private void setType(String dbtype, int length, int precision, int scale, Column column) {
        if (dbtype.contains("CHAR")) {
            column.setColumnType("varchar");
            column.setCharLen(length);
            return;
        }
        if (NUMBER_COLUMNS.contains(dbtype)) {
            column.setColumnType("number");
            column.setIntLen(precision - scale);
            column.setDecimalLen(scale);
            return;
        }
        if (DATE_COLUMNS.contains(dbtype)) {
            column.setColumnType("date");
            return;
        }
        if (CLOB_COLUMNS.contains(dbtype)) {
            column.setColumnType("clob");
            return;
        }
    }
}

