/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.table.colmap;

import com.hotent.base.util.BeanUtils;
import com.hotent.table.model.Column;
import com.hotent.table.model.impl.DefaultColumn;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import org.springframework.jdbc.core.RowMapper;

public class KingBaseColumnMap
implements RowMapper<Column> {
    private static final List<String> CLOB_COLUMNS = Arrays.asList("CLOB", "BLOB", "BFILE", "NCLOB", "BYTEA");

    public Column mapRow(ResultSet rs, int row) throws SQLException {
        DefaultColumn column = new DefaultColumn();
        String name = rs.getString("NAME");
        String typeName = rs.getString("TYPENAME");
        int length = rs.getInt("LENGTH");
        int precision = rs.getInt("PRECISION");
        int scale = rs.getInt("SCALE");
        boolean isNull = rs.getString("NULLABLE").equals("Y");
        String comments = rs.getString("DESCRIPTION");
        String tableName = rs.getString("TABLE_NAME");
        int isPK = rs.getInt("IS_PK");
        column.setFieldName(name);
        column.setComment(comments);
        column.setIsNull(isNull);
        column.setTableName(tableName);
        column.setIsPk(isPK == 1);
        int columnLength = length;
        if ("NUMBER".equals(typeName) || "NUMERIC".equals(typeName)) {
            columnLength = precision;
        }
        column.setFcolumnType(BeanUtils.isEmpty((Object)length) ? typeName : typeName + "(" + columnLength + ")");
        this.setType(typeName, length, precision, scale, column);
        return column;
    }

    private void setType(String dbtype, int length, int precision, int scale, Column column) {
        if (dbtype.contains("CHAR")) {
            column.setColumnType("varchar");
            column.setCharLen(length);
            return;
        }
        if ("NUMBER".equals(dbtype)) {
            column.setColumnType("number");
            column.setIntLen(precision - scale);
            column.setDecimalLen(scale);
            int i = precision - scale;
            if (i == 0 && scale == 0) {
                column.setIntLen(38);
            }
            return;
        }
        if ("NUMERIC".equals(dbtype) || "DECIMAL".equals(dbtype) || "FIXED".equals(dbtype) || "FLOAT".equals(dbtype)) {
            column.setColumnType("numeric");
            column.setIntLen(precision - scale);
            column.setDecimalLen(scale);
            int i = precision - scale;
            if (i == 0 && scale == 0) {
                column.setIntLen(38);
            }
            return;
        }
        if ("MONEY".equals(dbtype)) {
            column.setColumnType("numeric");
            column.setIntLen(precision - scale);
            column.setDecimalLen(2);
            return;
        }
        if ("INTEGER".equals(dbtype)) {
            column.setColumnType("number");
            column.setIntLen(10);
            column.setDecimalLen(0);
            return;
        }
        if (dbtype.matches("INT\\d")) {
            column.setColumnType("number");
            column.setDecimalLen(0);
            column.setIntLen(length);
            return;
        }
        if ("DATE".equals(dbtype) || dbtype.contains("TIMESTAMP")) {
            column.setColumnType("date");
            return;
        }
        if (CLOB_COLUMNS.contains(dbtype)) {
            column.setColumnType("clob");
            return;
        }
        if (dbtype.contains("TEXT")) {
            column.setColumnType("text");
            return;
        }
        column.setColumnType("clob");
    }
}

