/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.table.colmap;

import com.hotent.base.util.StringUtil;
import com.hotent.table.model.Column;
import com.hotent.table.model.impl.DefaultColumn;
import io.jsonwebtoken.lang.Assert;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;

public class PostgreSQLColumnMap
implements RowMapper<Column> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public Column mapRow(ResultSet rs, int row) throws SQLException {
        DefaultColumn column = new DefaultColumn();
        String table_name = rs.getString("table_name");
        String name = rs.getString("column_name");
        String is_nullable = rs.getString("is_nullable");
        String data_type = rs.getString("data_type");
        String length = rs.getString("length");
        String precisions = rs.getString("precisions");
        String scale = rs.getString("scale");
        String column_comment = rs.getString("column_comment");
        String udt_name = rs.getString("udt_name");
        String is_primary = rs.getString("is_primary");
        int iLength = 0;
        int iPrecisions = 0;
        int iScale = 0;
        try {
            iLength = StringUtils.isEmpty((String)length) ? 0 : Integer.parseInt(length);
            iPrecisions = StringUtils.isEmpty((String)precisions) ? 0 : Integer.parseInt(precisions);
            iScale = StringUtils.isEmpty((String)scale) ? 0 : Integer.parseInt(scale);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        column.setFieldName(name);
        column.setTableName(table_name);
        column.setComment(StringUtil.isEmpty((String)column_comment) ? name : column_comment);
        column.setFcolumnType(StringUtil.isEmpty((String)length) ? udt_name : udt_name + "(" + length + ")");
        if ("Y".equalsIgnoreCase(is_primary)) {
            column.setIsPk(true);
        }
        boolean isNull = "YES".equalsIgnoreCase(is_nullable);
        column.setIsNull(isNull);
        this.setType(data_type, iLength, iPrecisions, iScale, column);
        return column;
    }

    private void setType(String dbtype, int length, int precision, int scale, Column columnModel) {
        Assert.isTrue((boolean)StringUtil.isNotEmpty((String)dbtype), (String)"\u89e3\u6790PostgreSQL\u7684\u5217\u7c7b\u578b\u65f6\uff0c\u83b7\u53d6\u5230\u7684\u5217\u7c7b\u578b\u4e3a\u7a7a.");
        switch (dbtype = dbtype.toLowerCase()) {
            case "bigserial": 
            case "serial": 
            case "smallint": 
            case "integer": 
            case "int": 
            case "bigint": {
                columnModel.setColumnType("number");
                columnModel.setIntLen(precision);
                columnModel.setDecimalLen(0);
                break;
            }
            case "decimal": 
            case "numeric": 
            case "float": 
            case "real": 
            case "double precision": {
                columnModel.setColumnType("number");
                columnModel.setIntLen(precision);
                columnModel.setDecimalLen(scale);
                break;
            }
            case "bit": 
            case "bit varying": 
            case "varbit": 
            case "boolean": 
            case "char": 
            case "character": 
            case "varchar": 
            case "character varying": {
                columnModel.setColumnType("varchar");
                columnModel.setCharLen(length);
                break;
            }
            case "text": 
            case "bytea": {
                columnModel.setColumnType("clob");
                columnModel.setCharLen(65535);
                break;
            }
            case "date": 
            case "datetime": 
            case "time without time zone": 
            case "time with time zone": 
            case "timestamp without time zone": 
            case "timestamp with time zone": {
                columnModel.setColumnType("date");
                break;
            }
            default: {
                this.logger.warn("\u5904\u7406PostgreSQL\u6570\u636e\u5e93\u7684\u5217\u7c7b\u578b\u65f6\u6709\u672a\u8bc6\u522b\u7684\u5217\u6570\u636e\u7c7b\u578b\uff1a{}", (Object)dbtype);
            }
        }
    }
}

