/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.table.meta.impl;

import com.hotent.table.colmap.DB2ColumnMap;
import com.hotent.table.meta.impl.BaseTableMeta;
import com.hotent.table.model.Column;
import com.hotent.table.model.Table;
import com.hotent.table.model.impl.DefaultTable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowMapper;

public class DB2TableMeta
extends BaseTableMeta {
    private final String SQL_GET_COLUMNS = "SELECT TABNAME TAB_NAME, COLNAME COL_NAME, TYPENAME COL_TYPE, REMARKS COL_COMMENT, NULLS IS_NULLABLE, LENGTH LENGTH, SCALE SCALE, KEYSEQ  FROM  SYSCAT.COLUMNS WHERE  TABSCHEMA IN (SELECT CURRENT SQLID FROM SYSIBM.DUAL) AND UPPER(TABNAME) = UPPER('%s') ";
    private final String SQL_GET_COLUMNS_BATCH = "SELECT TABNAME TAB_NAME, COLNAME COL_NAME, TYPENAME COL_TYPE, REMARKS COL_COMMENT, NULLS IS_NULLABLE, LENGTH LENGTH, SCALE SCALE, KEYSEQ  FROM  SYSCAT.COLUMNS WHERE  TABSCHEMA IN (SELECT CURRENT SQLID FROM SYSIBM.DUAL) ";
    private final String SQL_GET_TABLE_COMMENT = "SELECT TABNAME TAB_NAME, REMARKS TAB_COMMENT FROM SYSCAT.TABLES WHERE TABSCHEMA IN (SELECT CURRENT SQLID FROM SYSIBM.DUAL) AND UPPER(TABNAME) =UPPER('%s')";
    private final String SQL_GET_ALL_TABLE_COMMENT = "SELECT TABNAME TAB_NAME, REMARKS TAB_COMMENT FROM SYSCAT.TABLES WHERE TABSCHEMA IN (SELECT CURRENT SQLID FROM SYSIBM.DUAL) AND UPPER(TABSCHEMA) = (SELECT UPPER(CURRENT SCHEMA) FROM SYSIBM.DUAL)";
    RowMapper<Table> tableModelRowMapper = new RowMapper<Table>(){

        public Table mapRow(ResultSet rs, int row) throws SQLException {
            DefaultTable tableModel = new DefaultTable();
            String tabName = rs.getString("TAB_NAME");
            String tabComment = rs.getString("TAB_COMMENT");
            tableModel.setTableName(tabName);
            tableModel.setComment(tabComment);
            return tableModel;
        }
    };
    RowMapper<Map<String, String>> tableMapRowMapper = new RowMapper<Map<String, String>>(){

        public Map<String, String> mapRow(ResultSet rs, int row) throws SQLException {
            String tableName = rs.getString("TAB_NAME");
            String comments = rs.getString("TAB_COMMENT");
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("name", tableName);
            map.put("comments", comments);
            return map;
        }
    };

    @Override
    public Table getTableByName(String tableName) {
        Table model = this.getTableModel(tableName);
        if (model == null) {
            return null;
        }
        List<Column> columnList = this.getColumnsByTableName(tableName);
        model.setColumnList(columnList);
        return model;
    }

    @Override
    public Map<String, String> getTablesByName(String tableName) {
        String sql = "SELECT TABNAME TAB_NAME, REMARKS TAB_COMMENT FROM SYSCAT.TABLES WHERE TABSCHEMA IN (SELECT CURRENT SQLID FROM SYSIBM.DUAL) AND UPPER(TABSCHEMA) = (SELECT UPPER(CURRENT SCHEMA) FROM SYSIBM.DUAL)";
        if (StringUtils.isNotEmpty((String)tableName)) {
            sql = sql + " AND UPPER(TABNAME) LIKE UPPER('%" + tableName + "%')";
        }
        List list = this.jdbcTemplate.query(sql, this.tableMapRowMapper);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < list.size(); ++i) {
            Map tmp = (Map)list.get(i);
            String name = (String)tmp.get("name");
            String comments = (String)tmp.get("comments");
            map.put(name, comments);
        }
        return map;
    }

    @Override
    public List<Table> getTableModelByName(String tableName) throws Exception {
        String sql = "SELECT TABNAME TAB_NAME, REMARKS TAB_COMMENT FROM SYSCAT.TABLES WHERE TABSCHEMA IN (SELECT CURRENT SQLID FROM SYSIBM.DUAL) AND UPPER(TABSCHEMA) = (SELECT UPPER(CURRENT SCHEMA) FROM SYSIBM.DUAL)";
        if (StringUtils.isNotEmpty((String)tableName)) {
            sql = sql + " AND UPPER(TABNAME) LIKE '%" + tableName.toUpperCase() + "%'";
        }
        List tables = this.jdbcTemplate.query(sql, this.tableModelRowMapper);
        ArrayList<String> tableNames = new ArrayList<String>();
        for (Table model : tables) {
            tableNames.add(model.getTableName());
        }
        Map<String, List<Column>> tableColumnsMap = this.getColumnsByTableName(tableNames);
        for (Map.Entry<String, List<Column>> entry : tableColumnsMap.entrySet()) {
            for (Table model : tables) {
                if (!model.getTableName().equalsIgnoreCase(entry.getKey())) continue;
                model.setColumnList(entry.getValue());
            }
        }
        return tables;
    }

    @Override
    public Map<String, String> getTablesByName(List<String> tableNames) {
        HashMap<String, String> map = new HashMap<String, String>();
        String sql = "SELECT TABNAME TAB_NAME, REMARKS TAB_COMMENT FROM SYSCAT.TABLES WHERE TABSCHEMA IN (SELECT CURRENT SQLID FROM SYSIBM.DUAL) AND UPPER(TABSCHEMA) = (SELECT UPPER(CURRENT SCHEMA) FROM SYSIBM.DUAL)";
        if (tableNames == null || tableNames.size() == 0) {
            return map;
        }
        StringBuffer buf = new StringBuffer();
        for (String str : tableNames) {
            buf.append("'" + str + "',");
        }
        buf.deleteCharAt(buf.length() - 1);
        sql = sql + " AND UPPER(TABNAME) IN (" + buf.toString().toUpperCase() + ") ";
        List list = this.jdbcTemplate.query(sql, this.tableMapRowMapper);
        for (int i = 0; i < list.size(); ++i) {
            Map tmp = (Map)list.get(i);
            String name = (String)tmp.get("name");
            String comments = (String)tmp.get("comments");
            map.put(name, comments);
        }
        return map;
    }

    private Table getTableModel(String tableName) {
        String sql = String.format("SELECT TABNAME TAB_NAME, REMARKS TAB_COMMENT FROM SYSCAT.TABLES WHERE TABSCHEMA IN (SELECT CURRENT SQLID FROM SYSIBM.DUAL) AND UPPER(TABNAME) =UPPER('%s')", tableName);
        Table tableModel = (Table)this.jdbcTemplate.queryForObject(sql, this.tableModelRowMapper);
        return tableModel;
    }

    private List<Column> getColumnsByTableName(String tableName) {
        String sql = String.format("SELECT TABNAME TAB_NAME, COLNAME COL_NAME, TYPENAME COL_TYPE, REMARKS COL_COMMENT, NULLS IS_NULLABLE, LENGTH LENGTH, SCALE SCALE, KEYSEQ  FROM  SYSCAT.COLUMNS WHERE  TABSCHEMA IN (SELECT CURRENT SQLID FROM SYSIBM.DUAL) AND UPPER(TABNAME) = UPPER('%s') ", tableName);
        List list = this.jdbcTemplate.query(sql, (RowMapper)new DB2ColumnMap());
        return list;
    }

    private Map<String, List<Column>> getColumnsByTableName(List<String> tableNames) {
        String sql = "SELECT TABNAME TAB_NAME, COLNAME COL_NAME, TYPENAME COL_TYPE, REMARKS COL_COMMENT, NULLS IS_NULLABLE, LENGTH LENGTH, SCALE SCALE, KEYSEQ  FROM  SYSCAT.COLUMNS WHERE  TABSCHEMA IN (SELECT CURRENT SQLID FROM SYSIBM.DUAL) ";
        HashMap<String, List<Column>> map = new HashMap<String, List<Column>>();
        if (tableNames != null && tableNames.size() == 0) {
            return map;
        }
        StringBuffer buf = new StringBuffer();
        for (String str : tableNames) {
            buf.append("'" + str + "',");
        }
        buf.deleteCharAt(buf.length() - 1);
        sql = sql + " AND UPPER(TABNAME) IN (" + buf.toString().toUpperCase() + ") ";
        List columnModels = this.jdbcTemplate.query(sql, (RowMapper)new DB2ColumnMap());
        for (Column columnModel : columnModels) {
            String tableName = columnModel.getTableName();
            if (map.containsKey(tableName)) {
                ((List)map.get(tableName)).add(columnModel);
                continue;
            }
            ArrayList<Column> cols = new ArrayList<Column>();
            cols.add(columnModel);
            map.put(tableName, cols);
        }
        return map;
    }

    @Override
    public String getAllTableSql() {
        return "SELECT TABNAME TAB_NAME, REMARKS TAB_COMMENT FROM SYSCAT.TABLES WHERE TABSCHEMA IN (SELECT CURRENT SQLID FROM SYSIBM.DUAL) AND UPPER(TABSCHEMA) = (SELECT UPPER(CURRENT SCHEMA) FROM SYSIBM.DUAL)";
    }

    @Override
    public List<Map<String, Object>> getTablesByNameIndex(String tableName) {
        return null;
    }
}

