/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.table.meta.impl;

import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.table.colmap.KingBaseColumnMap;
import com.hotent.table.meta.impl.BaseTableMeta;
import com.hotent.table.model.Column;
import com.hotent.table.model.Table;
import com.hotent.table.model.impl.DefaultTable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.util.Assert;

public class KingBaseTableMeta
extends BaseTableMeta {
    private final String sqlTableComment = "select c.relname as table_name,cast(obj_description(c.relfilenode,'pg_class') as varchar) as table_comment from sys_class c,information_schema.TABLES isc  ";
    private final String SQL_GET_COLUMNS = "SELECT  \tA.TABLE_NAME TABLE_NAME,  \tlower(A.COLUMN_NAME) NAME,  \tA.DATA_TYPE TYPENAME,  \tA.DATA_LENGTH LENGTH,   \tA.DATA_PRECISION \"PRECISION\",  \tA.DATA_SCALE SCALE,  \tA.DATA_DEFAULT,  \tA.NULLABLE,   \tDECODE(B.COMMENTS,NULL,A.COLUMN_NAME,B.COMMENTS) DESCRIPTION,  \t(    \t  SELECT    \t    COUNT(*)    \t  FROM     \t    USER_CONSTRAINTS CONS,     \t   USER_CONS_COLUMNS CONS_C      \t WHERE      \t   CONS.CONSTRAINT_NAME=CONS_C.CONSTRAINT_NAME     \t   AND CONS.CONSTRAINT_TYPE='P'     \t   AND CONS.TABLE_NAME=B.TABLE_NAME      \t  AND CONS_C.COLUMN_NAME=A.COLUMN_NAME      \t  AND LOWER ( CONS_C.TABLE_NAME ) = '%s'   \t ) AS IS_PK  FROM   \tUSER_TAB_COLUMNS A,  \tUSER_COL_COMMENTS B       WHERE   \tA.COLUMN_NAME=B.COLUMN_NAME  \tAND A.TABLE_NAME = B.TABLE_NAME  \tAND lower(A.TABLE_NAME)='%s'      ORDER BY   \tA.COLUMN_ID";
    private final String SQL_GET_COLUMNS_BATCH = "SELECT  \tA.TABLE_NAME TABLE_NAME,  \tlower(A.COLUMN_NAME) NAME,  \tA.DATA_TYPE TYPENAME,  \tA.DATA_LENGTH LENGTH,   \tA.DATA_PRECISION \"PRECISION\",  \tA.DATA_SCALE SCALE,  \tA.DATA_DEFAULT,  \tA.NULLABLE,   \tDECODE(B.COMMENTS,NULL,A.COLUMN_NAME,B.COMMENTS) DESCRIPTION,  \t(    \t  SELECT    \t    COUNT(*)    \t  FROM     \t    USER_CONSTRAINTS CONS,     \t   USER_CONS_COLUMNS CONS_C      \t WHERE      \t   CONS.CONSTRAINT_NAME=CONS_C.CONSTRAINT_NAME     \t   AND CONS.CONSTRAINT_TYPE='P'     \t   AND CONS.TABLE_NAME=B.TABLE_NAME      \t  AND CONS_C.COLUMN_NAME=A.COLUMN_NAME   \t ) AS IS_PK  FROM   \tUSER_TAB_COLUMNS A,  \tUSER_COL_COMMENTS B   WHERE   \tA.COLUMN_NAME=B.COLUMN_NAME  \tAND A.TABLE_NAME = B.TABLE_NAME ";
    private String sqlAllTables = "select TABLE_NAME,DECODE(COMMENTS,null,TABLE_NAME,comments) comments from user_tab_comments where table_type='TABLE'  ";
    private String SQL_GET_PRIMARY_KEY = "select column_name from USER_CONS_COLUMNS where table_name = upper('%s') and constraint_name =(select lower( constraint_name ) from USER_CONSTRAINTS where CONSTRAINT_TYPE = 'P' and table_name = upper('%s'))";

    @Override
    public Map<String, String> getTablesByName(String tableName) {
        String sql = "select c.relname as table_name,cast(obj_description(c.relfilenode,'pg_class') as varchar) as table_comment from sys_class c,information_schema.TABLES isc  ";
        sql = StringUtils.isNotEmpty((String)tableName) ? sql + " where lower(c.relname) like '%" + tableName.toLowerCase() + "%' and " : sql + " where ";
        sql = sql + "isc.table_schema='public' and c.relname=isc.table_name";
        List list = this.jdbcTemplate.query(sql, (RowMapper)new RowMapper<Map<String, String>>(){

            public Map<String, String> mapRow(ResultSet rs, int row) throws SQLException {
                String tableName = rs.getString("table_name");
                String comments = rs.getString("table_comment");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", tableName);
                map.put("comments", StringUtil.isNotEmpty((String)comments) ? comments : tableName);
                return map;
            }
        });
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < list.size(); ++i) {
            Map tmp = (Map)list.get(i);
            String name = (String)tmp.get("name");
            String comments = (String)tmp.get("comments");
            map.put(name, comments);
        }
        return map;
    }

    @Override
    public Map<String, String> getTablesByName(List<String> names) {
        StringBuffer sb = new StringBuffer();
        for (String name : names) {
            sb.append("'");
            sb.append(name);
            sb.append("',");
        }
        sb.deleteCharAt(sb.length() - 1);
        String sql = this.sqlAllTables + " and  lower(table_name) in (" + sb.toString().toLowerCase() + ")";
        List list = this.jdbcTemplate.query(sql, (RowMapper)new RowMapper<Map<String, String>>(){

            public Map<String, String> mapRow(ResultSet rs, int row) throws SQLException {
                String tableName = rs.getString("TABLE_NAME");
                String comments = rs.getString("COMMENTS");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("NAME", tableName);
                map.put("COMMENTS", comments);
                return map;
            }
        });
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < list.size(); ++i) {
            Map tmp = (Map)list.get(i);
            String name = (String)tmp.get("NAME");
            String comments = (String)tmp.get("COMMENTS");
            map.put(name, comments);
        }
        return map;
    }

    @Override
    public Table getTableByName(String tableName) {
        Assert.notNull((Object)tableName, (String)"\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        Table model = this.getTable(tableName.toLowerCase());
        List<Column> columnList = this.getColumnsByTableName(tableName);
        model.setColumnList(columnList);
        return model;
    }

    private Table getTable(final String tableName) {
        String sql = String.format("select c.relname as table_name,cast(obj_description(c.relfilenode,'pg_class') as varchar) as table_comment from sys_class c,information_schema.TABLES isc  where lower(c.relname) ='%s'and isc.table_schema='public' and c.relname=isc.table_name", tableName.toLowerCase());
        Table tableModel = (Table)this.jdbcTemplate.queryForObject(sql, (RowMapper)new RowMapper<Table>(){

            public Table mapRow(ResultSet rs, int row) throws SQLException {
                DefaultTable tableModel = new DefaultTable();
                tableModel.setTableName(tableName);
                String comments = rs.getString("table_comment");
                tableModel.setComment(StringUtil.isNotEmpty((String)comments) ? comments : tableName);
                return tableModel;
            }
        });
        if (BeanUtils.isEmpty((Object)tableModel)) {
            tableModel = new DefaultTable();
        }
        return tableModel;
    }

    private List<Column> getColumnsByTableName(String tableName) {
        String sql = String.format("SELECT  \tA.TABLE_NAME TABLE_NAME,  \tlower(A.COLUMN_NAME) NAME,  \tA.DATA_TYPE TYPENAME,  \tA.DATA_LENGTH LENGTH,   \tA.DATA_PRECISION \"PRECISION\",  \tA.DATA_SCALE SCALE,  \tA.DATA_DEFAULT,  \tA.NULLABLE,   \tDECODE(B.COMMENTS,NULL,A.COLUMN_NAME,B.COMMENTS) DESCRIPTION,  \t(    \t  SELECT    \t    COUNT(*)    \t  FROM     \t    USER_CONSTRAINTS CONS,     \t   USER_CONS_COLUMNS CONS_C      \t WHERE      \t   CONS.CONSTRAINT_NAME=CONS_C.CONSTRAINT_NAME     \t   AND CONS.CONSTRAINT_TYPE='P'     \t   AND CONS.TABLE_NAME=B.TABLE_NAME      \t  AND CONS_C.COLUMN_NAME=A.COLUMN_NAME      \t  AND LOWER ( CONS_C.TABLE_NAME ) = '%s'   \t ) AS IS_PK  FROM   \tUSER_TAB_COLUMNS A,  \tUSER_COL_COMMENTS B       WHERE   \tA.COLUMN_NAME=B.COLUMN_NAME  \tAND A.TABLE_NAME = B.TABLE_NAME  \tAND lower(A.TABLE_NAME)='%s'      ORDER BY   \tA.COLUMN_ID", tableName.toLowerCase(), tableName.toLowerCase());
        List columnList = this.jdbcTemplate.query(sql, (RowMapper)new KingBaseColumnMap());
        String getPrimaryKeySql = this.SQL_GET_PRIMARY_KEY.replace("%s", tableName);
        List column_name = this.jdbcTemplate.query(getPrimaryKeySql, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                if (rs != null) {
                    return rs.getString("column_name");
                }
                return null;
            }
        });
        if (column_name != null && column_name.size() > 0) {
            String pkColumn = (String)column_name.get(0);
            for (Column column : columnList) {
                if (!column.getFieldName().equalsIgnoreCase(pkColumn)) continue;
                column.setIsPk(true);
            }
        }
        return columnList;
    }

    private Map<String, List<Column>> getColumnsByTableName(List<String> tableNames) {
        String sql = "SELECT  \tA.TABLE_NAME TABLE_NAME,  \tlower(A.COLUMN_NAME) NAME,  \tA.DATA_TYPE TYPENAME,  \tA.DATA_LENGTH LENGTH,   \tA.DATA_PRECISION \"PRECISION\",  \tA.DATA_SCALE SCALE,  \tA.DATA_DEFAULT,  \tA.NULLABLE,   \tDECODE(B.COMMENTS,NULL,A.COLUMN_NAME,B.COMMENTS) DESCRIPTION,  \t(    \t  SELECT    \t    COUNT(*)    \t  FROM     \t    USER_CONSTRAINTS CONS,     \t   USER_CONS_COLUMNS CONS_C      \t WHERE      \t   CONS.CONSTRAINT_NAME=CONS_C.CONSTRAINT_NAME     \t   AND CONS.CONSTRAINT_TYPE='P'     \t   AND CONS.TABLE_NAME=B.TABLE_NAME      \t  AND CONS_C.COLUMN_NAME=A.COLUMN_NAME   \t ) AS IS_PK  FROM   \tUSER_TAB_COLUMNS A,  \tUSER_COL_COMMENTS B   WHERE   \tA.COLUMN_NAME=B.COLUMN_NAME  \tAND A.TABLE_NAME = B.TABLE_NAME ";
        HashMap<String, List<Column>> map = new HashMap<String, List<Column>>();
        if (tableNames != null && tableNames.size() == 0) {
            return map;
        }
        StringBuffer buf = new StringBuffer();
        for (String str : tableNames) {
            buf.append("'" + str + "',");
        }
        buf.deleteCharAt(buf.length() - 1);
        sql = sql + " AND A.TABLE_NAME IN (" + buf.toString() + ") ";
        List columnModels = this.jdbcTemplate.query(sql, (RowMapper)new KingBaseColumnMap());
        for (Column columnModel : columnModels) {
            String tableName = columnModel.getTableName();
            if (map.containsKey(tableName)) {
                ((List)map.get(tableName)).add(columnModel);
                continue;
            }
            ArrayList<Column> cols = new ArrayList<Column>();
            cols.add(columnModel);
            map.put(tableName, cols);
        }
        return map;
    }

    @Override
    public List<Table> getTableModelByName(String tableName) throws Exception {
        String sql = this.sqlAllTables;
        if (StringUtils.isNotEmpty((String)tableName)) {
            sql = sql + " AND  LOWER(table_name) LIKE '%" + tableName.toLowerCase() + "%'";
        }
        RowMapper<Table> rowMapper = new RowMapper<Table>(){

            public Table mapRow(ResultSet rs, int row) throws SQLException {
                DefaultTable tableModel = new DefaultTable();
                tableModel.setTableName(rs.getString("TABLE_NAME"));
                tableModel.setComment(rs.getString("COMMENTS"));
                return tableModel;
            }
        };
        List tableModels = this.jdbcTemplate.query(sql, (RowMapper)rowMapper);
        ArrayList<String> tableNames = new ArrayList<String>();
        for (Table model : tableModels) {
            tableNames.add(model.getTableName());
        }
        Map<String, List<Column>> tableColumnsMap = this.getColumnsByTableName(tableNames);
        for (Map.Entry<String, List<Column>> entry : tableColumnsMap.entrySet()) {
            for (Table model : tableModels) {
                if (!model.getTableName().equalsIgnoreCase(entry.getKey())) continue;
                model.setColumnList(entry.getValue());
            }
        }
        return tableModels;
    }

    @Override
    public String getAllTableSql() {
        return this.sqlAllTables;
    }

    @Override
    public List<Map<String, Object>> getTablesByNameIndex(String tableName) {
        return null;
    }
}

