/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.table.operator.impl.db2;

import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.table.model.Index;
import com.hotent.table.model.impl.DefaultIndex;
import com.hotent.table.operator.ITableOperator;
import com.hotent.table.operator.impl.BaseIndexOperator;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowMapper;

public class DB2IndexOperator
extends BaseIndexOperator {
    protected int BATCH_SIZE = 100;
    private final String SQL_GET_ALL_INDEX = "SELECT A.TABNAME, A.INDNAME, B.COLNAME, A.UNIQUERULE, A.COLCOUNT, A.INDEXTYPE, A.REMARKS FROM SYSCAT.INDEXES A JOIN SYSCAT.INDEXCOLUSE B ON A.INDNAME=B.INDNAME WHERE 1=1 ";

    @Override
    public void createIndex(Index index) throws SQLException {
        String sql = this.genIndexDDL(index);
        this.jdbcTemplate.execute(sql);
    }

    private String genIndexDDL(Index index) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE ").append("INDEX ").append(index.getIndexName()).append(" ON ").append(index.getTableName()).append("(");
        for (String field : index.getColumnList()) {
            sql.append(field);
            sql.append(",");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(")");
        if (!StringUtils.isEmpty((String)index.getIndexType()) && "CLUSTERED".equalsIgnoreCase(index.getIndexType())) {
            sql.append(" CLUSTER ");
        }
        return sql.toString();
    }

    @Override
    public void dropIndex(String tableName, String indexName) {
        String sql = "DROP INDEX " + indexName;
        this.jdbcTemplate.execute(sql);
    }

    @Override
    public Index getIndex(String tableName, String indexName) throws SQLException {
        String sql = "SELECT A.TABNAME, A.INDNAME, B.COLNAME, A.UNIQUERULE, A.COLCOUNT, A.INDEXTYPE, A.REMARKS FROM SYSCAT.INDEXES A JOIN SYSCAT.INDEXCOLUSE B ON A.INDNAME=B.INDNAME WHERE 1=1 ";
        List<Index> indexes = this.getIndexesBySql(sql = sql + " AND A.INDNAME = '" + indexName + "' ");
        List<Index> indexList = this.mergeIndex(indexes);
        if (BeanUtils.isEmpty(indexList)) {
            return null;
        }
        Index index = indexList.get(0);
        index.setIndexDdl(this.genIndexDDL(index));
        return index;
    }

    private List<Index> getIndexesBySql(String sql) {
        List indexes = this.jdbcTemplate.query(sql, (RowMapper)new RowMapper<Index>(){

            public Index mapRow(ResultSet rs, int rowNum) throws SQLException {
                String indexType;
                DefaultIndex index = new DefaultIndex();
                index.setTableName(rs.getString("TABNAME"));
                index.setTableType("TABLE");
                index.setIndexName(rs.getString("INDNAME"));
                String uniqueRule = rs.getString("UNIQUERULE").trim();
                if ("U".equalsIgnoreCase(uniqueRule) || "P".equalsIgnoreCase(uniqueRule)) {
                    index.setUnique(true);
                }
                if ("P".equalsIgnoreCase(uniqueRule)) {
                    index.setPkIndex(true);
                }
                if ("CLUS".equalsIgnoreCase(indexType = rs.getString("INDEXTYPE").trim())) {
                    index.setIndexType("CLUSTERED");
                } else if ("REG".equalsIgnoreCase(indexType)) {
                    index.setIndexType("REGULAR");
                } else if ("DIM".equalsIgnoreCase(indexType)) {
                    index.setIndexType("DIMENSIONBLOCK");
                } else if ("BLOK".equalsIgnoreCase(indexType)) {
                    index.setIndexType("BLOCK");
                }
                index.setIndexComment(rs.getString("REMARKS"));
                ArrayList<String> columnList = new ArrayList<String>();
                columnList.add(rs.getString("COLNAME"));
                index.setColumnList(columnList);
                index.setIndexDdl(DB2IndexOperator.this.genIndexDDL(index));
                return index;
            }
        });
        return indexes;
    }

    private List<Index> mergeIndex(List<Index> indexes) {
        ArrayList<Index> indexList = new ArrayList<Index>();
        for (Index index : indexes) {
            boolean found = false;
            for (Index index1 : indexList) {
                if (!index.getIndexName().equals(index1.getIndexName()) || !index.getTableName().equals(index1.getTableName())) continue;
                index1.getColumnList().add(index.getColumnList().get(0));
                found = true;
                break;
            }
            if (found) continue;
            indexList.add(index);
        }
        return indexList;
    }

    private List<Index> dedicatePKIndex(List<Index> indexList) throws SQLException {
        ArrayList<String> tableNames = new ArrayList<String>();
        for (Index index : indexList) {
            if (tableNames.contains(index.getTableName())) continue;
            tableNames.add(index.getTableName());
        }
        Map<String, List<String>> tablePKColsMaps = this.getTablesPKColsByNames(tableNames);
        for (Index index : indexList) {
            if (this.isListEqual(index.getColumnList(), tablePKColsMaps.get(index.getTableName()))) {
                index.setPkIndex(true);
                continue;
            }
            index.setPkIndex(false);
        }
        return indexList;
    }

    private Map<String, List<String>> getTablesPKColsByNames(List<String> tableNames) throws SQLException {
        HashMap<String, List<String>> tableMaps = new HashMap<String, List<String>>();
        ArrayList<String> names = new ArrayList<String>();
        for (int i = 1; i <= tableNames.size(); ++i) {
            names.add(tableNames.get(i - 1));
            if (i % this.BATCH_SIZE != 0 && i != tableNames.size()) continue;
            Map<String, List<String>> map = this.getPKColumns(names);
            tableMaps.putAll(map);
            names.clear();
        }
        return tableMaps;
    }

    private Map<String, List<String>> getPKColumns(List<String> tableNames) throws SQLException {
        ITableOperator tableOperator = (ITableOperator)AppUtil.getBean(ITableOperator.class);
        return tableOperator.getPKColumns(tableNames);
    }

    private boolean isListEqual(List<String> list1, List<String> list2) {
        if (list1 == null && list2 == null) {
            return true;
        }
        if (list1 == null || list2 == null) {
            return false;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        return list1.containsAll(list2);
    }

    @Override
    public void rebuildIndex(String tableName, String indexName) {
        throw new UnsupportedOperationException("DB2 \u4e0d\u652f\u6301\u901a\u8fc7JDBC\u8fdb\u884c\u7d22\u5f15\u91cd\u5efa\uff01");
    }

    @Override
    public List<Index> getIndexByName(String indexName) throws SQLException {
        return null;
    }

    @Override
    public List<Index> getIndexsByTable(String tableName) throws SQLException {
        return null;
    }
}

