/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.table.operator.impl.h2;

import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.util.BeanUtils;
import com.hotent.table.colmap.H2ColumnMap;
import com.hotent.table.model.Column;
import com.hotent.table.model.Table;
import com.hotent.table.model.impl.DefaultTable;
import com.hotent.table.operator.IViewOperator;
import com.hotent.table.operator.impl.BaseViewOperator;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowMapper;

public class H2ViewOperator
extends BaseViewOperator
implements IViewOperator {
    private static final String SQL_GET_ALL_VIEW = "SELECT TABLE_NAME ,REMARKS  FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_TYPE = 'VIEW' AND TABLE_SCHEMA=SCHEMA() ";
    private static final String SQL_GET_COLUMNS = "SELECT A.TABLE_NAME, A.COLUMN_NAME, A.IS_NULLABLE, A.DATA_TYPE, A.CHARACTER_OCTET_LENGTH LENGTH, A.NUMERIC_PRECISION PRECISIONS, A.NUMERIC_SCALE SCALE, B.COLUMN_LIST, A.REMARKS FROM INFORMATION_SCHEMA.COLUMNS A  JOIN INFORMATION_SCHEMA.CONSTRAINTS B ON A.TABLE_NAME=B.TABLE_NAME WHERE  A.TABLE_SCHEMA=SCHEMA() AND UPPER(A.TABLE_NAME)='%s' ";
    static final String SQL_GET_COLUMNS_BATCH = "SELECT A.TABLE_NAME, A.COLUMN_NAME, A.IS_NULLABLE, A.DATA_TYPE, A.CHARACTER_OCTET_LENGTH LENGTH, A.NUMERIC_PRECISION PRECISIONS, A.NUMERIC_SCALE SCALE, B.COLUMN_LIST, A.REMARKS FROM INFORMATION_SCHEMA.COLUMNS A  JOIN INFORMATION_SCHEMA.CONSTRAINTS B ON A.TABLE_NAME=B.TABLE_NAME WHERE  A.TABLE_SCHEMA=SCHEMA() ";
    RowMapper<Table> tableRowMapper = new RowMapper<Table>(){

        public Table mapRow(ResultSet rs, int row) throws SQLException {
            DefaultTable tableModel = new DefaultTable();
            String tabName = rs.getString("TABLE_NAME");
            String tabComment = rs.getString("REMARKS");
            tableModel.setTableName(tabName);
            tableModel.setComment(tabComment);
            return tableModel;
        }
    };

    @Override
    public void createOrRep(String viewName, String sql) throws Exception {
    }

    @Override
    public PageList<String> getViews(String viewName) throws SQLException {
        String sql = SQL_GET_ALL_VIEW;
        if (StringUtils.isNotEmpty((String)viewName)) {
            sql = sql + " AND TABLE_NAME LIKE '%" + viewName + "%'";
        }
        RowMapper<String> rowMapper = new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                String name = rs.getString("TABLE_NAME");
                return name;
            }
        };
        return new PageList(this.jdbcTemplate.query(sql, (RowMapper)rowMapper));
    }

    @Override
    public PageList<String> getViews(String viewName, PageBean pageBean) throws SQLException, Exception {
        String sql = SQL_GET_ALL_VIEW;
        if (StringUtils.isNotEmpty((String)viewName)) {
            sql = sql + " AND TABLE_NAME LIKE '%" + viewName + "%'";
        }
        RowMapper<String> rowMapper = new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                String name = rs.getString("TABLE_NAME");
                return name;
            }
        };
        return new PageList(this.jdbcTemplate.query(sql, (RowMapper)rowMapper));
    }

    @Override
    public PageList<Table> getViewsByName(String viewName, PageBean pageBean) throws Exception {
        String sql = SQL_GET_ALL_VIEW;
        if (StringUtils.isNotEmpty((String)viewName)) {
            sql = sql + " AND TABLE_NAME LIKE '%" + viewName + "%'";
        }
        RowMapper<Table> rowMapper = new RowMapper<Table>(){

            public Table mapRow(ResultSet rs, int row) throws SQLException {
                DefaultTable tableModel = new DefaultTable();
                tableModel.setTableName(rs.getString("table_name"));
                tableModel.setComment(tableModel.getTableName());
                return tableModel;
            }
        };
        PageList<Table> tableModels = this.getForList(sql, pageBean, rowMapper);
        ArrayList<String> tableNames = new ArrayList<String>();
        for (Table model : tableModels.getRows()) {
            tableNames.add(model.getTableName());
        }
        Map<String, List<Column>> tableColumnsMap = this.getColumnsByTableName(tableNames);
        for (Map.Entry<String, List<Column>> entry : tableColumnsMap.entrySet()) {
            for (Table model : tableModels.getRows()) {
                if (!model.getTableName().equalsIgnoreCase(entry.getKey())) continue;
                model.setColumnList(entry.getValue());
            }
        }
        return tableModels;
    }

    private Map<String, List<Column>> getColumnsByTableName(List<String> tableNames) {
        String sql = SQL_GET_COLUMNS_BATCH;
        HashMap<String, List<Column>> map = new HashMap<String, List<Column>>();
        if (tableNames != null && tableNames.size() == 0) {
            return map;
        }
        StringBuffer buf = new StringBuffer();
        for (String str : tableNames) {
            buf.append("'" + str + "',");
        }
        buf.deleteCharAt(buf.length() - 1);
        sql = sql + " AND A.TABLE_NAME IN (" + buf.toString() + ") ";
        List columnModels = this.jdbcTemplate.query(sql, (RowMapper)new H2ColumnMap());
        for (Column columnModel : columnModels) {
            String tableName = columnModel.getTableName();
            if (map.containsKey(tableName)) {
                ((List)map.get(tableName)).add(columnModel);
                continue;
            }
            ArrayList<Column> cols = new ArrayList<Column>();
            cols.add(columnModel);
            map.put(tableName, cols);
        }
        return map;
    }

    @Override
    public String getType(String type) {
        if ((type = type.toLowerCase()).indexOf("number") > -1) {
            return "number";
        }
        if (type.indexOf("date") > -1) {
            return "date";
        }
        if (type.indexOf("char") > -1) {
            return "varchar";
        }
        return "varchar";
    }

    @Override
    public Table getModelByViewName(String viewName) throws SQLException {
        String sql = SQL_GET_ALL_VIEW;
        sql = sql + " AND UPPER(TABLE_NAME) = '" + viewName.toUpperCase() + "'";
        Table tableModel = null;
        List tableModels = this.jdbcTemplate.query(sql, this.tableRowMapper);
        if (BeanUtils.isEmpty((Object)tableModels)) {
            return null;
        }
        tableModel = (Table)tableModels.get(0);
        List<Column> columnList = this.getColumnsByTableName(viewName);
        tableModel.setColumnList(columnList);
        return tableModel;
    }

    private List<Column> getColumnsByTableName(String tableName) {
        String sql = String.format(SQL_GET_COLUMNS, tableName);
        List list = this.jdbcTemplate.query(sql, (RowMapper)new H2ColumnMap());
        for (Column model : list) {
            model.setTableName(tableName);
        }
        return list;
    }
}

