/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.table.operator.impl.sqlserver;

import com.hotent.table.model.Column;
import com.hotent.table.model.Table;
import com.hotent.table.operator.impl.BaseTableOperator;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowMapper;

public class SQLServerTableOperator
extends BaseTableOperator {
    @Override
    public void createTable(Table model) throws SQLException {
        List<Column> columnList = model.getColumnList();
        StringBuffer createTableSql = new StringBuffer();
        String pkColumn = null;
        ArrayList<String> columnCommentList = new ArrayList<String>();
        createTableSql.append("CREATE TABLE " + model.getTableName() + " (\n");
        for (int i = 0; i < columnList.size(); ++i) {
            Column cm = columnList.get(i);
            createTableSql.append("    ").append(cm.getFieldName()).append("    ");
            createTableSql.append(this.getColumnType(cm.getColumnType(), cm.getCharLen(), cm.getIntLen(), cm.getDecimalLen()));
            createTableSql.append(" ");
            if (StringUtils.isNotEmpty((String)cm.getDefaultValue())) {
                if ("number".equals(cm.getColumnType()) || "int".equals(cm.getColumnType())) {
                    createTableSql.append(" DEFAULT " + cm.getDefaultValue());
                } else {
                    createTableSql.append(" DEFAULT '" + cm.getDefaultValue() + "' ");
                }
            }
            if (cm.getIsRequired() == 1) {
                createTableSql.append(" NOT NULL ");
            }
            if (cm.getIsPk()) {
                pkColumn = pkColumn == null ? cm.getFieldName() : pkColumn + "," + cm.getFieldName();
            }
            if (cm.getComment() != null && cm.getComment().length() > 0) {
                StringBuffer comment = new StringBuffer("EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'");
                comment.append(cm.getComment()).append("' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'").append(model.getTableName()).append("', @level2type=N'COLUMN', @level2name=N'").append(cm.getFieldName()).append("'");
                columnCommentList.add(comment.toString());
            }
            createTableSql.append(",\n");
        }
        if (pkColumn != null) {
            createTableSql.append("    CONSTRAINT PK_").append(model.getTableName()).append(" PRIMARY KEY (").append(pkColumn).append(")");
        }
        createTableSql.append("\n)");
        this.jdbcTemplate.execute(createTableSql.toString());
        if (model.getComment() != null && model.getComment().length() > 0) {
            StringBuffer tableComment = new StringBuffer("EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'");
            tableComment.append(model.getComment()).append("' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'").append(model.getTableName()).append("'");
            this.jdbcTemplate.execute(tableComment.toString());
        }
        for (String columnComment : columnCommentList) {
            this.jdbcTemplate.execute(columnComment);
        }
    }

    @Override
    public String getColumnType(Column column) {
        return this.getColumnType(column.getColumnType(), column.getCharLen(), column.getIntLen(), column.getDecimalLen());
    }

    @Override
    public String getColumnType(String columnType, int charLen, int intLen, int decimalLen) {
        if ("varchar".equals(columnType)) {
            return "VARCHAR(" + charLen + ')';
        }
        if ("number".equals(columnType)) {
            return "NUMERIC(" + (intLen + decimalLen) + "," + decimalLen + ")";
        }
        if ("date".equals(columnType)) {
            return "DATETIME";
        }
        if ("int".equals(columnType)) {
            return "NUMERIC(" + intLen + ")";
        }
        if ("clob".equals(columnType)) {
            return "TEXT";
        }
        return "";
    }

    @Override
    public void dropTable(String tableName) throws SQLException {
        String sql = "IF OBJECT_ID(N'" + tableName + "', N'U') IS NOT NULL  DROP TABLE " + tableName;
        this.jdbcTemplate.execute(sql);
    }

    @Override
    public void updateTableComment(String tableName, String comment) throws SQLException {
        StringBuffer commentSql = new StringBuffer("EXEC sys.sp_updateextendedproperty @name=N'MS_Description', @value=N'");
        commentSql.append(comment).append("' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'").append(tableName).append("'");
        this.jdbcTemplate.execute(commentSql.toString());
    }

    @Override
    public void addColumn(String tableName, Column model) throws SQLException {
        StringBuffer alterSql = new StringBuffer();
        alterSql.append("ALTER TABLE ").append(tableName);
        alterSql.append(" ADD ");
        alterSql.append(model.getFieldName()).append(" ");
        alterSql.append(this.getColumnType(model.getColumnType(), model.getCharLen(), model.getIntLen(), model.getDecimalLen()));
        if (StringUtils.isNotEmpty((String)model.getDefaultValue())) {
            alterSql.append(" DEFAULT " + model.getDefaultValue());
        }
        alterSql.append("\n");
        this.jdbcTemplate.execute(alterSql.toString());
        if (model.getComment() != null && model.getComment().length() > 0) {
            StringBuffer comment = new StringBuffer("EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'");
            comment.append(model.getComment()).append("' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'").append(tableName).append("', @level2type=N'COLUMN', @level2name=N'").append(model.getFieldName()).append("'");
            this.jdbcTemplate.execute(comment.toString());
        }
    }

    @Override
    public void updateColumn(String tableName, String columnName, Column model) throws SQLException {
        if (!columnName.equals(model.getFieldName())) {
            StringBuffer modifyName = new StringBuffer("EXEC sp_rename '");
            modifyName.append(tableName).append(".[").append(columnName).append("]','").append(model.getFieldName()).append("', 'COLUMN'");
            this.jdbcTemplate.execute(modifyName.toString());
        }
        StringBuffer alterSql = new StringBuffer();
        alterSql.append("ALTER TABLE ").append(tableName);
        alterSql.append(" ALTER COLUMN " + model.getFieldName()).append(" ");
        alterSql.append(this.getColumnType(model.getColumnType(), model.getCharLen(), model.getIntLen(), model.getDecimalLen()));
        if (model.getIsNull()) {
            alterSql.append(" NOT NULL ");
        }
        this.jdbcTemplate.execute(alterSql.toString());
        if (model.getComment() != null && model.getComment().length() > 0) {
            this.updateColumnComment(tableName, model.getFieldName(), model);
        }
    }

    @Override
    public void updateColumnComment(String tableName, String columnName, Column column) {
        StringBuffer commentStr = new StringBuffer("EXEC sys.sp_updateextendedproperty @name=N'MS_Description', @value=N'");
        commentStr.append(column.getComment()).append("' ,@level0type=N'SCHEMA', @level0name=N'dbo', @level1type=N'TABLE', @level1name=N'").append(tableName).append("', @level2type=N'COLUMN', @level2name=N'").append(columnName).append("'");
        this.jdbcTemplate.execute(commentStr.toString());
    }

    @Override
    public void addForeignKey(String pkTableName, String fkTableName, String pkField, String fkField) {
        String shortTableName = fkTableName.replaceFirst("(?im)W_", "");
        String sql = "  ALTER TABLE " + fkTableName + " ADD CONSTRAINT fk_" + shortTableName + " FOREIGN KEY (" + fkField + ") REFERENCES " + pkTableName + " (" + pkField + ")   ON DELETE CASCADE";
        this.jdbcTemplate.execute(sql);
    }

    @Override
    public void dropForeignKey(String tableName, String keyName) {
        String sql = "ALTER   TABLE   " + tableName + "   DROP   CONSTRAINT  " + keyName;
        this.jdbcTemplate.execute(sql);
    }

    @Override
    public List<String> getPKColumns(String tableName) throws SQLException {
        String sql = "SELECT C.COLUMN_NAME COLUMN_NAME FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS PK ,INFORMATION_SCHEMA.KEY_COLUMN_USAGE C WHERE \tPK.TABLE_NAME = '%S' AND\tCONSTRAINT_TYPE = 'PRIMARY KEY' AND\tC.TABLE_NAME = PK.TABLE_NAME AND\tC.CONSTRAINT_NAME = PK.CONSTRAINT_NAME ";
        sql = String.format(sql, tableName);
        List columns = this.jdbcTemplate.query(sql, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                String column = rs.getString(1);
                return column;
            }
        });
        return columns;
    }

    @Override
    public Map<String, List<String>> getPKColumns(List<String> tableNames) throws SQLException {
        StringBuffer sb = new StringBuffer();
        for (String name : tableNames) {
            sb.append("'");
            sb.append(name);
            sb.append("',");
        }
        sb.deleteCharAt(sb.length() - 1);
        String sql = "SELECT C.COLUMN_NAME COLUMN_NAME FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS PK ,INFORMATION_SCHEMA.KEY_COLUMN_USAGE C WHERE \tPK.TABLE_NAME in( %S )AND\tCONSTRAINT_TYPE = 'PRIMARY KEY' AND\tC.TABLE_NAME = PK.TABLE_NAME AND\tC.CONSTRAINT_NAME = PK.CONSTRAINT_NAME ";
        sql = String.format(sql, sb.toString());
        HashMap<String, List<String>> columnsMap = new HashMap<String, List<String>>();
        List maps = this.jdbcTemplate.query(sql, (RowMapper)new RowMapper<Map<String, String>>(){

            public Map<String, String> mapRow(ResultSet rs, int rowNum) throws SQLException {
                String table = rs.getString(1);
                String column = rs.getString(2);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", table);
                map.put("column", column);
                return map;
            }
        });
        for (Map map : maps) {
            if (columnsMap.containsKey(map.get("name"))) {
                ((List)columnsMap.get(map.get("name"))).add(map.get("column"));
                continue;
            }
            ArrayList cols = new ArrayList();
            cols.add(map.get("column"));
            columnsMap.put((String)map.get("name"), cols);
        }
        return columnsMap;
    }

    @Override
    public boolean isTableExist(String tableName) {
        String sql = "select count(1) from sysobjects where name='" + tableName.toUpperCase() + "'";
        return (Integer)this.jdbcTemplate.queryForObject(sql, Integer.class) > 0;
    }

    @Override
    public boolean isExsitPartition(String tableName, String partition) {
        return false;
    }

    @Override
    public void createPartition(String tableName, String partition) {
    }

    @Override
    public boolean supportPartition(String tableName) {
        return false;
    }

    @Override
    public void dropColumn(String tableName, String columnName) throws SQLException {
    }
}

