/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.table.colmap;

import com.hotent.table.model.Column;
import com.hotent.table.model.impl.DefaultColumn;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowMapper;

public class DB2ColumnMap
implements RowMapper<Column> {
    public Column mapRow(ResultSet rs, int rowNum) throws SQLException {
        int iLength;
        DefaultColumn column = new DefaultColumn();
        String tabName = rs.getString("TAB_NAME");
        String colName = rs.getString("COL_NAME");
        String colType = rs.getString("COL_TYPE");
        String colComment = rs.getString("COL_COMMENT");
        String nullable = rs.getString("IS_NULLABLE");
        String length = rs.getString("LENGTH");
        String scale = rs.getString("SCALE");
        String keySeq = rs.getString("KEYSEQ");
        int iPrecision = iLength = this.string2Int(length, 0);
        int iScale = this.string2Int(scale, 0);
        int iKeySeq = this.string2Int(keySeq, 0);
        column.setTableName(tabName);
        column.setFieldName(colName);
        column.setComment(colComment);
        column.setIsNull("Y".equalsIgnoreCase(nullable));
        column.setIsPk(iKeySeq > 0);
        this.setType(colType, iLength, iPrecision, iScale, column);
        return column;
    }

    private int string2Int(String str, int def) {
        if (StringUtils.isEmpty((String)str)) {
            return def;
        }
        try {
            return Integer.parseInt(str);
        }
        catch (Exception e) {
            e.printStackTrace();
            return def;
        }
    }

    private void setType(String type, int length, int precision, int scale, Column column) {
        String dbtype = type.toLowerCase();
        if (dbtype.endsWith("bigint")) {
            column.setColumnType("number");
            column.setIntLen(19);
            column.setDecimalLen(0);
        } else if (dbtype.endsWith("blob")) {
            column.setColumnType("clob");
        } else if (dbtype.endsWith("character")) {
            column.setColumnType("varchar");
            column.setCharLen(length);
            column.setDecimalLen(0);
        } else if (dbtype.endsWith("clob")) {
            column.setColumnType("clob");
        } else if (dbtype.endsWith("date")) {
            column.setColumnType("date");
        } else if (dbtype.endsWith("dbclob")) {
            column.setColumnType("clob");
        } else if (dbtype.endsWith("decimal")) {
            column.setColumnType("number");
            column.setIntLen(precision - scale);
            column.setDecimalLen(scale);
        } else if (dbtype.endsWith("double")) {
            column.setColumnType("number");
            column.setIntLen(precision - scale);
            column.setDecimalLen(scale);
        } else if (dbtype.endsWith("graphic")) {
            column.setColumnType("clob");
        } else if (dbtype.endsWith("integer")) {
            column.setColumnType("number");
            column.setIntLen(10);
            column.setDecimalLen(0);
        } else if (dbtype.endsWith("long varchar")) {
            column.setColumnType("varchar");
            column.setCharLen(length);
        } else if (dbtype.endsWith("long vargraphic")) {
            column.setColumnType("clob");
        } else if (dbtype.endsWith("real")) {
            column.setColumnType("number");
            column.setIntLen(length);
            column.setDecimalLen(scale);
        } else if (dbtype.endsWith("smallint")) {
            column.setColumnType("number");
            column.setIntLen(5);
            column.setDecimalLen(0);
        } else if (dbtype.endsWith("time")) {
            column.setColumnType("date");
        } else if (dbtype.endsWith("timestamp")) {
            column.setColumnType("date");
        } else if (dbtype.endsWith("varchar")) {
            column.setColumnType("varchar");
            column.setCharLen(length);
        } else if (dbtype.endsWith("vargraphic")) {
            column.setColumnType("clob");
        } else if (dbtype.endsWith("xml")) {
            column.setColumnType("clob");
        }
    }
}

