/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.table.factory;

import com.hotent.table.meta.impl.BaseTableMeta;
import com.hotent.table.meta.impl.DB2TableMeta;
import com.hotent.table.meta.impl.DmTableMeta;
import com.hotent.table.meta.impl.H2TableMeta;
import com.hotent.table.meta.impl.KingBaseTableMeta;
import com.hotent.table.meta.impl.MySQLTableMeta;
import com.hotent.table.meta.impl.OracleTableMeta;
import com.hotent.table.meta.impl.PostgreSQLTableMeta;
import com.hotent.table.meta.impl.SQLServer2005TableMeta;
import com.hotent.table.meta.impl.SQLServerTableMeta;
import com.hotent.table.operator.IIndexOperator;
import com.hotent.table.operator.ITableOperator;
import com.hotent.table.operator.IViewOperator;
import com.hotent.table.operator.impl.BaseIndexOperator;
import com.hotent.table.operator.impl.BaseTableOperator;
import com.hotent.table.operator.impl.BaseViewOperator;
import com.hotent.table.operator.impl.db2.DB2IndexOperator;
import com.hotent.table.operator.impl.db2.DB2TableOperator;
import com.hotent.table.operator.impl.db2.DB2ViewOperator;
import com.hotent.table.operator.impl.dm.DmIndexOperator;
import com.hotent.table.operator.impl.dm.DmTableOperator;
import com.hotent.table.operator.impl.dm.DmViewOperator;
import com.hotent.table.operator.impl.h2.H2IndexOperator;
import com.hotent.table.operator.impl.h2.H2TableOperator;
import com.hotent.table.operator.impl.h2.H2ViewOperator;
import com.hotent.table.operator.impl.kingbase.KingBaseIndexOperator;
import com.hotent.table.operator.impl.kingbase.KingBaseTableOperator;
import com.hotent.table.operator.impl.kingbase.KingBaseViewOperator;
import com.hotent.table.operator.impl.mysql.MySQLIndexOperator;
import com.hotent.table.operator.impl.mysql.MySQLTableOperator;
import com.hotent.table.operator.impl.mysql.MySQLViewOperator;
import com.hotent.table.operator.impl.oracle.OracleIndexOperator;
import com.hotent.table.operator.impl.oracle.OracleTableOperator;
import com.hotent.table.operator.impl.oracle.OracleViewOperator;
import com.hotent.table.operator.impl.postgresql.PostgreSQLIndexOperator;
import com.hotent.table.operator.impl.postgresql.PostgreSQLTableOperator;
import com.hotent.table.operator.impl.postgresql.PostgreSQLViewOperator;
import com.hotent.table.operator.impl.sqlserver.SQLServerIndexOperator;
import com.hotent.table.operator.impl.sqlserver.SQLServerTableOperator;
import com.hotent.table.operator.impl.sqlserver.SQLServerViewOperator;

public class DatabaseFactory {
    public static String EXCEPTION_MSG = "\u6ca1\u6709\u8bbe\u7f6e\u5408\u9002\u7684\u6570\u636e\u5e93\u7c7b\u578b";

    public static ITableOperator getTableOperator(String dbType) throws Exception {
        BaseTableOperator tableOperator = null;
        if (dbType.equals("oracle")) {
            tableOperator = new OracleTableOperator();
        } else if (dbType.equals("mysql")) {
            tableOperator = new MySQLTableOperator();
        } else if (dbType.equals("sqlserver") || dbType.equals("sqlserver2005")) {
            tableOperator = new SQLServerTableOperator();
        } else if (dbType.equals("db2")) {
            tableOperator = new DB2TableOperator();
        } else if (dbType.equals("h2")) {
            tableOperator = new H2TableOperator();
        } else if (dbType.equals("dm")) {
            tableOperator = new DmTableOperator();
        } else if (dbType.equals("postgresql")) {
            tableOperator = new PostgreSQLTableOperator();
        } else if (dbType.equals("kingbasees")) {
            tableOperator = new KingBaseTableOperator();
        } else {
            throw new Exception(EXCEPTION_MSG);
        }
        return tableOperator;
    }

    public static BaseTableMeta getTableMetaByDbType(String dbType) throws Exception {
        BaseTableMeta meta = null;
        if (dbType.equals("oracle")) {
            meta = new OracleTableMeta();
        } else if (dbType.equals("mysql")) {
            meta = new MySQLTableMeta();
        } else if (dbType.equals("sqlserver")) {
            meta = new SQLServerTableMeta();
        } else if (dbType.equals("sqlserver2005")) {
            meta = new SQLServer2005TableMeta();
        } else if (dbType.equals("db2")) {
            meta = new DB2TableMeta();
        } else if (dbType.equals("h2")) {
            meta = new H2TableMeta();
        } else if (dbType.equals("dm")) {
            meta = new DmTableMeta();
        } else if (dbType.equals("postgresql")) {
            meta = new PostgreSQLTableMeta();
        } else if (dbType.equals("kingbasees")) {
            meta = new KingBaseTableMeta();
        } else {
            throw new Exception(EXCEPTION_MSG);
        }
        return meta;
    }

    public static IIndexOperator getIndexOperator(String dbType) throws Exception {
        BaseIndexOperator indexOperator = null;
        if (dbType.equals("oracle")) {
            indexOperator = new OracleIndexOperator();
        } else if (dbType.equals("mysql")) {
            indexOperator = new MySQLIndexOperator();
        } else if (dbType.equals("sqlserver") || dbType.equals("sqlserver2005")) {
            indexOperator = new SQLServerIndexOperator();
        } else if (dbType.equals("db2")) {
            indexOperator = new DB2IndexOperator();
        } else if (dbType.equals("h2")) {
            indexOperator = new H2IndexOperator();
        } else if (dbType.equals("dm")) {
            indexOperator = new DmIndexOperator();
        } else if (dbType.equals("postgresql")) {
            indexOperator = new PostgreSQLIndexOperator();
        } else if (dbType.equals("kingbasees")) {
            indexOperator = new KingBaseIndexOperator();
        } else {
            throw new Exception(EXCEPTION_MSG);
        }
        return indexOperator;
    }

    public static IViewOperator getViewOperator(String dbType) throws Exception {
        BaseViewOperator view = null;
        if (dbType.equals("oracle")) {
            view = new OracleViewOperator();
        } else if (dbType.equals("mysql")) {
            view = new MySQLViewOperator();
        } else if (dbType.equals("sqlserver") || dbType.equals("sqlserver2005")) {
            view = new SQLServerViewOperator();
        } else if (dbType.equals("db2")) {
            view = new DB2ViewOperator();
        } else if (dbType.equals("h2")) {
            view = new H2ViewOperator();
        } else if (dbType.equals("dm")) {
            view = new DmViewOperator();
        } else if (dbType.equals("postgresql")) {
            view = new PostgreSQLViewOperator();
        } else if (dbType.equals("kingbasees")) {
            view = new KingBaseViewOperator();
        } else {
            throw new Exception(EXCEPTION_MSG);
        }
        return view;
    }
}

