/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.table.meta.impl;

import com.hotent.base.util.BeanUtils;
import com.hotent.table.colmap.H2ColumnMap;
import com.hotent.table.meta.impl.BaseTableMeta;
import com.hotent.table.model.Column;
import com.hotent.table.model.Table;
import com.hotent.table.model.impl.DefaultTable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowMapper;

public class H2TableMeta
extends BaseTableMeta {
    private final String SQL_GET_COLUMNS = "SELECT A.TABLE_NAME, A.COLUMN_NAME, A.IS_NULLABLE, A.TYPE_NAME, A.CHARACTER_OCTET_LENGTH LENGTH, A.NUMERIC_PRECISION PRECISIONS, A.NUMERIC_SCALE SCALE, B.COLUMN_LIST, A.REMARKS FROM INFORMATION_SCHEMA.COLUMNS A  JOIN INFORMATION_SCHEMA.CONSTRAINTS B ON A.TABLE_NAME=B.TABLE_NAME WHERE  A.TABLE_SCHEMA=SCHEMA() AND B.CONSTRAINT_TYPE='PRIMARY KEY' AND UPPER(A.TABLE_NAME)=UPPER('%s') ";
    private final String SQL_GET_COLUMNS_BATCH = "SELECT A.TABLE_NAME, A.COLUMN_NAME, A.IS_NULLABLE, A.TYPE_NAME, A.CHARACTER_OCTET_LENGTH LENGTH, A.NUMERIC_PRECISION PRECISIONS, A.NUMERIC_SCALE SCALE, B.COLUMN_LIST, A.REMARKS FROM INFORMATION_SCHEMA.COLUMNS A  JOIN INFORMATION_SCHEMA.CONSTRAINTS B ON A.TABLE_NAME=B.TABLE_NAME WHERE  A.TABLE_SCHEMA=SCHEMA() AND B.CONSTRAINT_TYPE='PRIMARY KEY' ";
    private final String SQL_GET_ALL_TABLE = "SELECT TABLE_NAME, REMARKS FROM INFORMATION_SCHEMA.TABLES T WHERE T.TABLE_TYPE='TABLE' AND T.TABLE_SCHEMA=SCHEMA() ";
    RowMapper<Table> tableRowMapper = new RowMapper<Table>(){

        public Table mapRow(ResultSet rs, int rowNum) throws SQLException {
            DefaultTable model = new DefaultTable();
            String tableName = rs.getString("TABLE_NAME");
            String tableComment = rs.getString("REMARKS");
            model.setTableName(tableName);
            model.setComment(tableComment);
            return model;
        }
    };
    RowMapper<Map<String, Object>> tableMapRowMapper = new RowMapper<Map<String, Object>>(){

        public Map<String, Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
            HashMap<String, Object> model = new HashMap<String, Object>();
            String tableName = rs.getString("TABLE_NAME");
            String tableComment = rs.getString("REMARKS");
            model.put("name", tableName);
            model.put("comment", tableComment);
            return model;
        }
    };

    @Override
    public Table getTableByName(String tableName) {
        Table model = this.getTable(tableName);
        List<Column> columnList = this.getColumnsByTableName(tableName);
        model.setColumnList(columnList);
        return model;
    }

    private List<Column> getColumnsByTableName(String tableName) {
        String sql = String.format("SELECT A.TABLE_NAME, A.COLUMN_NAME, A.IS_NULLABLE, A.TYPE_NAME, A.CHARACTER_OCTET_LENGTH LENGTH, A.NUMERIC_PRECISION PRECISIONS, A.NUMERIC_SCALE SCALE, B.COLUMN_LIST, A.REMARKS FROM INFORMATION_SCHEMA.COLUMNS A  JOIN INFORMATION_SCHEMA.CONSTRAINTS B ON A.TABLE_NAME=B.TABLE_NAME WHERE  A.TABLE_SCHEMA=SCHEMA() AND B.CONSTRAINT_TYPE='PRIMARY KEY' AND UPPER(A.TABLE_NAME)=UPPER('%s') ", tableName.toUpperCase());
        List list = this.jdbcTemplate.query(sql, (RowMapper)new H2ColumnMap());
        for (Column model : list) {
            model.setTableName(tableName);
        }
        return list;
    }

    private Map<String, List<Column>> getColumnsByTableName(List<String> tableNames) {
        String sql = "SELECT A.TABLE_NAME, A.COLUMN_NAME, A.IS_NULLABLE, A.TYPE_NAME, A.CHARACTER_OCTET_LENGTH LENGTH, A.NUMERIC_PRECISION PRECISIONS, A.NUMERIC_SCALE SCALE, B.COLUMN_LIST, A.REMARKS FROM INFORMATION_SCHEMA.COLUMNS A  JOIN INFORMATION_SCHEMA.CONSTRAINTS B ON A.TABLE_NAME=B.TABLE_NAME WHERE  A.TABLE_SCHEMA=SCHEMA() AND B.CONSTRAINT_TYPE='PRIMARY KEY' ";
        HashMap<String, List<Column>> map = new HashMap<String, List<Column>>();
        if (tableNames != null && tableNames.size() == 0) {
            return map;
        }
        StringBuffer buf = new StringBuffer();
        for (String str : tableNames) {
            buf.append("'" + str + "',");
        }
        buf.deleteCharAt(buf.length() - 1);
        sql = sql + " AND A.TABLE_NAME IN (" + buf.toString().toUpperCase() + ") ";
        List columnModels = this.jdbcTemplate.query(sql, (RowMapper)new H2ColumnMap());
        for (Column columnModel : columnModels) {
            String tableName = columnModel.getTableName();
            if (map.containsKey(tableName)) {
                ((List)map.get(tableName)).add(columnModel);
                continue;
            }
            ArrayList<Column> cols = new ArrayList<Column>();
            cols.add(columnModel);
            map.put(tableName, cols);
        }
        return map;
    }

    private Table getTable(String tableName) {
        String sql = "SELECT TABLE_NAME, REMARKS FROM INFORMATION_SCHEMA.TABLES T WHERE T.TABLE_TYPE='TABLE' AND T.TABLE_SCHEMA=SCHEMA()  AND UPPER(TABLE_NAME) = '" + tableName.toUpperCase() + "'";
        Table tableModel = (Table)this.jdbcTemplate.queryForObject(sql, this.tableRowMapper);
        if (BeanUtils.isEmpty((Object)tableModel)) {
            tableModel = new DefaultTable();
        }
        return tableModel;
    }

    @Override
    public Map<String, String> getTablesByName(String tableName) {
        String sql = "SELECT TABLE_NAME, REMARKS FROM INFORMATION_SCHEMA.TABLES T WHERE T.TABLE_TYPE='TABLE' AND T.TABLE_SCHEMA=SCHEMA() ";
        if (StringUtils.isNotEmpty((String)tableName)) {
            sql = sql + " AND UPPER(TABLE_NAME) LIKE '%" + tableName.toUpperCase() + "%'";
        }
        List list = this.jdbcTemplate.query(sql, this.tableMapRowMapper);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < list.size(); ++i) {
            Map tmp = (Map)list.get(i);
            String name = tmp.get("name").toString();
            String comments = tmp.get("comment").toString();
            map.put(name, comments);
        }
        return map;
    }

    @Override
    public Map<String, String> getTablesByName(List<String> names) {
        StringBuffer sb = new StringBuffer();
        for (String name : names) {
            sb.append("'");
            sb.append(name);
            sb.append("',");
        }
        sb.deleteCharAt(sb.length() - 1);
        String sql = "SELECT TABLE_NAME, REMARKS FROM INFORMATION_SCHEMA.TABLES T WHERE T.TABLE_TYPE='TABLE' AND T.TABLE_SCHEMA=SCHEMA()  AND  UPPER(TABLE_NAME) IN (" + sb.toString().toUpperCase() + ")";
        List list = this.jdbcTemplate.query(sql, this.tableMapRowMapper);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < list.size(); ++i) {
            Map tmp = (Map)list.get(i);
            String name = tmp.get("name").toString();
            String comments = tmp.get("comment").toString();
            map.put(name, comments);
        }
        return map;
    }

    @Override
    public List<Table> getTableModelByName(String tableName) throws Exception {
        String sql = "SELECT TABLE_NAME, REMARKS FROM INFORMATION_SCHEMA.TABLES T WHERE T.TABLE_TYPE='TABLE' AND T.TABLE_SCHEMA=SCHEMA() ";
        if (StringUtils.isNotEmpty((String)tableName)) {
            sql = sql + " AND UPPER(TABLE_NAME) LIKE '%" + tableName.toUpperCase() + "%'";
        }
        RowMapper<Table> rowMapper = new RowMapper<Table>(){

            public Table mapRow(ResultSet rs, int row) throws SQLException {
                DefaultTable tableModel = new DefaultTable();
                tableModel.setTableName(rs.getString("TABLE_NAME"));
                String comments = rs.getString("REMARKS");
                tableModel.setComment(comments);
                return tableModel;
            }
        };
        List tableModels = this.jdbcTemplate.query(sql, (RowMapper)rowMapper);
        ArrayList<String> tableNames = new ArrayList<String>();
        for (Table model : tableModels) {
            tableNames.add(model.getTableName());
        }
        Map<String, List<Column>> tableColumnsMap = this.getColumnsByTableName(tableNames);
        for (Map.Entry<String, List<Column>> entry : tableColumnsMap.entrySet()) {
            for (Table model : tableModels) {
                if (!model.getTableName().equalsIgnoreCase(entry.getKey())) continue;
                model.setColumnList(entry.getValue());
            }
        }
        return tableModels;
    }

    @Override
    public String getAllTableSql() {
        return "SELECT TABLE_NAME, REMARKS FROM INFORMATION_SCHEMA.TABLES T WHERE T.TABLE_TYPE='TABLE' AND T.TABLE_SCHEMA=SCHEMA() ";
    }

    @Override
    public List<Map<String, Object>> getTablesByNameIndex(String tableName) {
        return null;
    }
}

