/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.table.operator.impl.h2;

import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.table.model.Index;
import com.hotent.table.model.impl.DefaultIndex;
import com.hotent.table.operator.ITableOperator;
import com.hotent.table.operator.impl.BaseIndexOperator;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.jdbc.core.RowMapper;

public class H2IndexOperator
extends BaseIndexOperator {
    protected int BATCH_SIZE = 100;
    private final String SQL_GET_ALL_INDEX = "SELECT A.TABLE_NAME  , A.INDEX_NAME  , A.NON_UNIQUE  , A.COLUMN_NAME  , A.INDEX_TYPE_NAME  , A.REMARKS , A.SQL FROM INFORMATION_SCHEMA.INDEXES  A WHERE 1=1 ";

    @Override
    public void createIndex(Index index) throws SQLException {
        String sql = this.genIndexDDL(index);
        this.jdbcTemplate.execute(sql);
    }

    private String genIndexDDL(Index index) {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE ");
        sql.append("INDEX ");
        sql.append(index.getIndexName());
        sql.append(" ON ");
        sql.append(index.getTableName());
        sql.append("(");
        for (String field : index.getColumnList()) {
            sql.append(field);
            sql.append(",");
        }
        sql.deleteCharAt(sql.length() - 1);
        sql.append(")");
        return sql.toString();
    }

    @Override
    public void dropIndex(String tableName, String indexName) {
        String sql = "DROP INDEX " + indexName;
        this.jdbcTemplate.execute(sql);
    }

    @Override
    public Index getIndex(String tableName, String indexName) throws SQLException {
        String sql = "SELECT A.TABLE_NAME  , A.INDEX_NAME  , A.NON_UNIQUE  , A.COLUMN_NAME  , A.INDEX_TYPE_NAME  , A.REMARKS , A.SQL FROM INFORMATION_SCHEMA.INDEXES  A WHERE 1=1 ";
        List<Index> indexes = this.getIndexesBySql(sql = sql + " AND A.INDEX_NAME = '" + indexName + "' ");
        List<Index> indexList = this.mergeIndex(indexes);
        if (BeanUtils.isEmpty(indexList)) {
            return null;
        }
        Index index = indexList.get(0);
        return index;
    }

    private List<Index> getIndexesBySql(String sql) {
        List indexes = this.jdbcTemplate.query(sql, (RowMapper)new RowMapper<Index>(){

            public Index mapRow(ResultSet rs, int rowNum) throws SQLException {
                DefaultIndex index = new DefaultIndex();
                index.setTableName(rs.getString("TABLE_NAME"));
                index.setTableType("TABLE");
                index.setIndexName(rs.getString("INDEX_NAME"));
                String non_unique = rs.getString("NON_UNIQUE").trim();
                String index_type_name = rs.getString("INDEX_TYPE_NAME").trim();
                if ("TRUE".equalsIgnoreCase(non_unique)) {
                    index.setUnique(true);
                }
                if ("PRIMARY KEY".equalsIgnoreCase(index_type_name)) {
                    index.setPkIndex(true);
                }
                index.setIndexType("BTREE");
                index.setIndexComment(rs.getString("REMARKS"));
                ArrayList<String> indexFields = new ArrayList<String>();
                indexFields.add(rs.getString("COLUMN_NAME"));
                index.setColumnList(indexFields);
                index.setIndexDdl(rs.getString("SQL"));
                return index;
            }
        });
        return indexes;
    }

    private List<Index> mergeIndex(List<Index> indexes) {
        ArrayList<Index> indexList = new ArrayList<Index>();
        for (Index index : indexes) {
            boolean found = false;
            for (Index index1 : indexList) {
                if (!index.getIndexName().equals(index1.getIndexName()) || !index.getTableName().equals(index1.getTableName())) continue;
                index1.getColumnList().add(index.getColumnList().get(0));
                found = true;
                break;
            }
            if (found) continue;
            indexList.add(index);
        }
        return indexList;
    }

    private List<String> getPKColumns(String tableName) throws SQLException {
        ITableOperator tableOperator = (ITableOperator)AppUtil.getBean(ITableOperator.class);
        return tableOperator.getPKColumns(tableName);
    }

    private Index dedicatePKIndex(Index index) {
        try {
            List<String> pkCols = this.getPKColumns(index.getIndexName());
            if (this.isListEqual(index.getColumnList(), pkCols)) {
                index.setPkIndex(true);
            } else {
                index.setPkIndex(false);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return index;
    }

    private boolean isListEqual(List<String> list1, List<String> list2) {
        if (list1 == null && list2 == null) {
            return true;
        }
        if (list1 == null || list2 == null) {
            return false;
        }
        if (list1.size() != list2.size()) {
            return false;
        }
        return list1.containsAll(list2);
    }

    @Override
    public void rebuildIndex(String tableName, String indexName) {
        throw new UnsupportedOperationException("h2 \u4e0d\u652f\u6301\u901a\u8fc7JDBC\u8fdb\u884c\u7d22\u5f15\u91cd\u5efa\uff01");
    }

    @Override
    public List<Index> getIndexByName(String indexName) throws SQLException {
        return null;
    }

    @Override
    public List<Index> getIndexsByTable(String tableName) throws SQLException {
        String sql = "SELECT A.TABLE_NAME  , A.INDEX_NAME  , A.NON_UNIQUE  , A.COLUMN_NAME  , A.INDEX_TYPE_NAME  , A.REMARKS , A.SQL FROM INFORMATION_SCHEMA.INDEXES  A WHERE 1=1 ";
        sql = sql + " AND UPPER(A.TABLE_NAME) = UPPER('" + tableName + "')";
        List<Index> indexes = this.getIndexesBySql(sql);
        List<Index> indexList = this.mergeIndex(indexes);
        for (Index index : indexList) {
            index.setIndexDdl(this.genIndexDDL(index));
        }
        return indexList;
    }
}

