/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.table.operator.impl.kingbase;

import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.table.colmap.MySQLColumnMap;
import com.hotent.table.model.Column;
import com.hotent.table.model.Table;
import com.hotent.table.model.impl.DefaultTable;
import com.hotent.table.operator.IViewOperator;
import com.hotent.table.operator.impl.BaseViewOperator;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowMapper;

public class KingBaseViewOperator
extends BaseViewOperator
implements IViewOperator {
    private static final String sqlAllView = "SELECT TABLE_NAME FROM information_schema.`TABLES` WHERE TABLE_TYPE LIKE 'VIEW'";
    private static final String SQL_GET_COLUMNS_BATCH = "SELECT TABLE_NAME,COLUMN_NAME,IS_NULLABLE,DATA_TYPE,CHARACTER_OCTET_LENGTH LENGTH, NUMERIC_PRECISION PRECISIONS,NUMERIC_SCALE SCALE,COLUMN_KEY,COLUMN_COMMENT,COLUMN_TYPE  FROM INFORMATION_SCHEMA.COLUMNS  WHERE TABLE_SCHEMA=DATABASE() ";

    @Override
    public void createOrRep(String viewName, String sql) throws Exception {
        String getSql = "CREATE OR REPLACE VIEW " + viewName + " as (" + sql + ")";
        this.jdbcTemplate.execute(getSql);
    }

    @Override
    public PageList<String> getViews(String viewName) throws SQLException {
        String sql = "select viewname from pg_views where schemaname ='public'";
        if (StringUtils.isNotEmpty((String)viewName)) {
            sql = sql + " AND viewname LIKE '" + viewName + "%'";
        }
        ArrayList<String> list = new ArrayList<String>();
        List results = this.jdbcTemplate.queryForList(sql);
        for (Map line : results) {
            list.add(line.get("viewname").toString());
        }
        return new PageList(list);
    }

    @Override
    public PageList<String> getViews(String viewName, PageBean pageBean) throws SQLException, Exception {
        String sql = sqlAllView;
        if (StringUtils.isNotEmpty((String)viewName)) {
            sql = sql + " AND TABLE_NAME LIKE '" + viewName + "%'";
        }
        return super.getForList(sql, pageBean, String.class);
    }

    @Override
    public PageList<Table> getViewsByName(String viewName, PageBean pageBean) throws Exception {
        String sql = sqlAllView;
        if (StringUtils.isNotEmpty((String)viewName)) {
            sql = sql + " AND TABLE_NAME LIKE '" + viewName + "%'";
        }
        RowMapper<Table> rowMapper = new RowMapper<Table>(){

            public Table mapRow(ResultSet rs, int row) throws SQLException {
                DefaultTable table = new DefaultTable();
                table.setTableName(rs.getString("table_name"));
                table.setComment(table.getTableName());
                return table;
            }
        };
        PageList<Table> tableModels = this.getForList(sql, pageBean, rowMapper);
        ArrayList<String> tableNames = new ArrayList<String>();
        for (Table table : tableModels.getRows()) {
            tableNames.add(table.getTableName());
        }
        Map<String, List<Column>> tableColumnsMap = this.getColumnsByTableName(tableNames);
        for (Map.Entry<String, List<Column>> entry : tableColumnsMap.entrySet()) {
            for (Table table : tableModels.getRows()) {
                if (!table.getTableName().equalsIgnoreCase(entry.getKey())) continue;
                table.setColumnList(entry.getValue());
            }
        }
        return tableModels;
    }

    private Map<String, List<Column>> getColumnsByTableName(List<String> tableNames) {
        String sql = SQL_GET_COLUMNS_BATCH;
        HashMap<String, List<Column>> map = new HashMap<String, List<Column>>();
        if (tableNames != null && tableNames.size() == 0) {
            return map;
        }
        StringBuffer buf = new StringBuffer();
        for (String str : tableNames) {
            buf.append("'" + str + "',");
        }
        buf.deleteCharAt(buf.length() - 1);
        sql = sql + " AND TABLE_NAME IN (" + buf.toString() + ") ";
        List columns = this.jdbcTemplate.query(sql, (RowMapper)new MySQLColumnMap());
        for (Column column : columns) {
            String tableName = column.getTableName();
            if (map.containsKey(tableName)) {
                ((List)map.get(tableName)).add(column);
                continue;
            }
            ArrayList<Column> cols = new ArrayList<Column>();
            cols.add(column);
            map.put(tableName, cols);
        }
        return map;
    }

    @Override
    public String getType(String type) {
        if ((type = type.toLowerCase()).indexOf("number") > -1) {
            return "number";
        }
        if (type.indexOf("date") > -1) {
            return "date";
        }
        if (type.indexOf("char") > -1) {
            return "varchar";
        }
        return "varchar";
    }
}

