/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.table.datasource;

import com.baomidou.dynamic.datasource.DynamicRoutingDataSource;
import com.fasterxml.jackson.databind.JsonNode;
import com.hotent.base.datasource.DatabaseContext;
import com.hotent.base.util.AppUtil;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.jdbc.core.JdbcTemplate;

public class DataSourceUtil {
    public static final String DYNAMIC_DATASOURCE = "dataSource";

    public static void addDataSource(String key, DataSource dataSource, boolean replace) throws IllegalAccessException, NoSuchFieldException {
        DatabaseContext databaseContext = (DatabaseContext)AppUtil.getBean(DatabaseContext.class);
        DynamicRoutingDataSource dynamicDataSource = (DynamicRoutingDataSource)AppUtil.getBean((String)DYNAMIC_DATASOURCE);
        Map<String, DataSource> map = DataSourceUtil.getDataSources();
        if (map.containsKey(key)) {
            if (!replace) {
                return;
            }
            databaseContext.destroyDataSourceByAlias(key, map.get(key));
        }
        dynamicDataSource.addDataSource(key, dataSource);
    }

    public static void removeDataSource(String key) throws IllegalAccessException, NoSuchFieldException {
        DatabaseContext databaseContext = (DatabaseContext)AppUtil.getBean(DatabaseContext.class);
        Map<String, DataSource> map = DataSourceUtil.getDataSources();
        if (map.containsKey(key)) {
            databaseContext.destroyDataSourceByAlias(key, map.get(key));
        }
    }

    public static Map<String, DataSource> getDataSources() throws IllegalAccessException, NoSuchFieldException {
        DynamicRoutingDataSource dynamicDataSource = (DynamicRoutingDataSource)AppUtil.getBean((String)DYNAMIC_DATASOURCE);
        return dynamicDataSource.getCurrentDataSources();
    }

    public static DataSource getDataSourceByAlias(String alias) throws IllegalAccessException, NoSuchFieldException {
        DatabaseContext databaseContext = (DatabaseContext)AppUtil.getBean(DatabaseContext.class);
        return databaseContext.getDataSourceByAlias(alias);
    }

    public static JdbcTemplate getJdbcTempByDsAlias(String alias) throws Exception {
        if (alias.equals("LOCAL")) {
            return (JdbcTemplate)AppUtil.getBean(JdbcTemplate.class);
        }
        return new JdbcTemplate(DataSourceUtil.getDataSourceByAlias(alias));
    }

    public static DataSource getDataSource(JsonNode jsonNode) {
        DatabaseContext databaseContext = (DatabaseContext)AppUtil.getBean(DatabaseContext.class);
        return databaseContext.getDsFromSysSource(jsonNode);
    }
}

