/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.table.meta.impl;

import com.hotent.base.util.BeanUtils;
import com.hotent.table.colmap.MySQLColumnMap;
import com.hotent.table.meta.impl.BaseTableMeta;
import com.hotent.table.model.Column;
import com.hotent.table.model.Table;
import com.hotent.table.model.impl.DefaultTable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowMapper;

public class MySQLTableMeta
extends BaseTableMeta {
    private final String SQL_GET_COLUMNS = "SELECT TABLE_NAME,COLUMN_NAME,IS_NULLABLE,DATA_TYPE,CHARACTER_MAXIMUM_LENGTH LENGTH, NUMERIC_PRECISION PRECISIONS,NUMERIC_SCALE SCALE,COLUMN_KEY,COLUMN_COMMENT,COLUMN_TYPE, COLUMN_DEFAULT  FROM  INFORMATION_SCHEMA.COLUMNS  WHERE TABLE_SCHEMA=DATABASE() AND TABLE_NAME='%s' ";
    private final String SQL_GET_COLUMNS_BATCH = "SELECT TABLE_NAME,COLUMN_NAME,IS_NULLABLE,DATA_TYPE,CHARACTER_MAXIMUM_LENGTH LENGTH, NUMERIC_PRECISION PRECISIONS,NUMERIC_SCALE SCALE,COLUMN_KEY,COLUMN_COMMENT,COLUMN_TYPE, COLUMN_DEFAULT  FROM  INFORMATION_SCHEMA.COLUMNS  WHERE TABLE_SCHEMA=DATABASE() ";
    private final String sqlComment = "select table_name,table_comment  from information_schema.tables t where t.table_schema=DATABASE() and table_name='%s' ";
    private final String sqlAllTable = "select table_name,table_comment from information_schema.tables t where t.table_type='BASE TABLE' AND t.table_schema=DATABASE()";
    private final String sqlIndex = "SHOW INDEX FROM %s ";
    private final String sqlPk = "SELECT k.column_name name FROM information_schema.table_constraints t JOIN information_schema.key_column_usage k USING(constraint_name,table_schema,table_name) WHERE t.constraint_type='PRIMARY KEY' AND t.table_schema=DATABASE() AND t.table_name='%s'";

    @Override
    public Table getTableByName(String tableName) {
        Table model = this.getTableModel(tableName);
        List<Column> columnList = this.getColumnsByTableName(tableName);
        model.setColumnList(columnList);
        return model;
    }

    @Override
    public Map<String, String> getTablesByName(String tableName) {
        String sql = "select table_name,table_comment from information_schema.tables t where t.table_type='BASE TABLE' AND t.table_schema=DATABASE()";
        if (StringUtils.isNotEmpty((String)tableName)) {
            sql = sql + " AND TABLE_NAME LIKE '%" + tableName + "%'";
        }
        List list = this.jdbcTemplate.query(sql, (RowMapper)new RowMapper<Map<String, String>>(){

            public Map<String, String> mapRow(ResultSet rs, int row) throws SQLException {
                String tableName = rs.getString("table_name");
                String comments = rs.getString("table_comment");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", tableName);
                map.put("comments", comments);
                return map;
            }
        });
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < list.size(); ++i) {
            Map tmp = (Map)list.get(i);
            String name = (String)tmp.get("name");
            String comments = (String)tmp.get("comments");
            comments = MySQLTableMeta.getComments(comments, name);
            map.put(name, comments);
        }
        return map;
    }

    @Override
    public Map<String, String> getTablesByName(List<String> names) {
        StringBuffer sb = new StringBuffer();
        for (String name : names) {
            sb.append("'");
            sb.append(name);
            sb.append("',");
        }
        sb.deleteCharAt(sb.length() - 1);
        String sql = "select table_name,table_comment from information_schema.tables t where t.table_type='BASE TABLE' AND t.table_schema=DATABASE() and  lower(table_name) in (" + sb.toString().toLowerCase() + ")";
        List list = this.jdbcTemplate.query(sql, (RowMapper)new RowMapper<Map<String, String>>(){

            public Map<String, String> mapRow(ResultSet rs, int row) throws SQLException {
                String tableName = rs.getString("table_name");
                String comments = rs.getString("table_comment");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("tableName", tableName);
                map.put("tableComment", comments);
                return map;
            }
        });
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < list.size(); ++i) {
            Map tmp = (Map)list.get(i);
            String name = (String)tmp.get("tableName");
            String comments = (String)tmp.get("tableComment");
            map.put(name, comments);
        }
        return map;
    }

    @Override
    public List<Map<String, Object>> getTablesByNameIndex(String tableName) {
        String sql = String.format("SHOW INDEX FROM %s ", tableName);
        List list = this.jdbcTemplate.query(sql, (RowMapper)new RowMapper<Map<String, Object>>(){

            public Map<String, Object> mapRow(ResultSet rs, int row) throws SQLException {
                String indexComment = rs.getString("Index_comment");
                String keyName = rs.getString("Key_name");
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("indexComment", indexComment);
                map.put("keyName", keyName);
                return map;
            }
        });
        return list;
    }

    private Table getTableModel(final String tableName) {
        String sql = String.format("select table_name,table_comment  from information_schema.tables t where t.table_schema=DATABASE() and table_name='%s' ", tableName);
        Table table = (Table)this.jdbcTemplate.queryForObject(sql, (RowMapper)new RowMapper<Table>(){

            public Table mapRow(ResultSet rs, int row) throws SQLException {
                DefaultTable table = new DefaultTable();
                String comments = rs.getString("table_comment");
                comments = MySQLTableMeta.getComments(comments, tableName);
                table.setTableName(tableName);
                table.setComment(comments);
                return table;
            }
        });
        if (BeanUtils.isEmpty((Object)table)) {
            table = new DefaultTable();
        }
        return table;
    }

    private List<Column> getColumnsByTableName(String tableName) {
        String sql = String.format("SELECT TABLE_NAME,COLUMN_NAME,IS_NULLABLE,DATA_TYPE,CHARACTER_MAXIMUM_LENGTH LENGTH, NUMERIC_PRECISION PRECISIONS,NUMERIC_SCALE SCALE,COLUMN_KEY,COLUMN_COMMENT,COLUMN_TYPE, COLUMN_DEFAULT  FROM  INFORMATION_SCHEMA.COLUMNS  WHERE TABLE_SCHEMA=DATABASE() AND TABLE_NAME='%s' ", tableName);
        List list = this.jdbcTemplate.query(sql, (RowMapper)new MySQLColumnMap());
        for (Column model : list) {
            model.setTableName(tableName);
        }
        return list;
    }

    private Map<String, List<Column>> getColumnsByTableName(List<String> tableNames) {
        String sql = "SELECT TABLE_NAME,COLUMN_NAME,IS_NULLABLE,DATA_TYPE,CHARACTER_MAXIMUM_LENGTH LENGTH, NUMERIC_PRECISION PRECISIONS,NUMERIC_SCALE SCALE,COLUMN_KEY,COLUMN_COMMENT,COLUMN_TYPE, COLUMN_DEFAULT  FROM  INFORMATION_SCHEMA.COLUMNS  WHERE TABLE_SCHEMA=DATABASE() ";
        HashMap<String, List<Column>> map = new HashMap<String, List<Column>>();
        if (tableNames != null && tableNames.size() == 0) {
            return map;
        }
        StringBuffer buf = new StringBuffer();
        for (String str : tableNames) {
            buf.append("'" + str + "',");
        }
        buf.deleteCharAt(buf.length() - 1);
        sql = sql + " AND TABLE_NAME IN (" + buf.toString() + ") ";
        List Columns = this.jdbcTemplate.query(sql, (RowMapper)new MySQLColumnMap());
        for (Column column : Columns) {
            String tableName = column.getTableName();
            if (map.containsKey(tableName)) {
                ((List)map.get(tableName)).add(column);
                continue;
            }
            ArrayList<Column> cols = new ArrayList<Column>();
            cols.add(column);
            map.put(tableName, cols);
        }
        return map;
    }

    public static String getComments(String comments, String defaultValue) {
        if (StringUtils.isEmpty((String)comments)) {
            return defaultValue;
        }
        int idx = comments.indexOf("InnoDB free");
        if (idx > -1) {
            comments = StringUtils.remove((String)comments.substring(0, idx).trim(), (String)";");
        }
        if (StringUtils.isEmpty((String)comments)) {
            comments = defaultValue;
        }
        return comments;
    }

    @Override
    public List<Table> getTableModelByName(String tableName) throws Exception {
        String sql = "select table_name,table_comment from information_schema.tables t where t.table_type='BASE TABLE' AND t.table_schema=DATABASE()";
        if (StringUtils.isNotEmpty((String)tableName)) {
            sql = sql + " AND TABLE_NAME LIKE '%" + tableName + "%'";
        }
        RowMapper<Table> rowMapper = new RowMapper<Table>(){

            public Table mapRow(ResultSet rs, int row) throws SQLException {
                DefaultTable table = new DefaultTable();
                table.setTableName(rs.getString("TABLE_NAME"));
                String comments = rs.getString("TABLE_COMMENT");
                comments = MySQLTableMeta.getComments(comments, table.getTableName());
                table.setComment(comments);
                return table;
            }
        };
        List tables = this.jdbcTemplate.query(sql, (RowMapper)rowMapper);
        ArrayList<String> tableNames = new ArrayList<String>();
        for (Table model : tables) {
            tableNames.add(model.getTableName());
        }
        Map<String, List<Column>> tableColumnsMap = this.getColumnsByTableName(tableNames);
        for (Map.Entry<String, List<Column>> entry : tableColumnsMap.entrySet()) {
            for (Table model : tables) {
                if (!model.getTableName().equalsIgnoreCase(entry.getKey())) continue;
                model.setColumnList(entry.getValue());
            }
        }
        return tables;
    }

    @Override
    public String getAllTableSql() {
        return this.sqlAllTable;
    }
}

