/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.table.meta.impl;

import com.hotent.base.util.BeanUtils;
import com.hotent.table.colmap.OracleColumnMap;
import com.hotent.table.meta.impl.BaseTableMeta;
import com.hotent.table.model.Column;
import com.hotent.table.model.Table;
import com.hotent.table.model.impl.DefaultTable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowMapper;

public class OracleTableMeta
extends BaseTableMeta {
    private String sqlTableComment = "select TABLE_NAME,DECODE(COMMENTS,null,TABLE_NAME,comments) comments from user_tab_comments  where table_type='TABLE' AND table_name ='%s'";
    private final String SQL_GET_COLUMNS = "SELECT  \tA.TABLE_NAME TABLE_NAME,  \tA.COLUMN_NAME NAME,  \tA.DATA_TYPE TYPENAME,  \tA.CHAR_COL_DECL_LENGTH LENGTH,   \tA.DATA_PRECISION PRECISION,  \tA.DATA_SCALE SCALE,  \tA.DATA_DEFAULT,  \tA.NULLABLE,   \tDECODE(B.COMMENTS,NULL,A.COLUMN_NAME,B.COMMENTS) DESCRIPTION,  \t(    \t  SELECT    \t    COUNT(*)    \t  FROM     \t    USER_CONSTRAINTS CONS,     \t   USER_CONS_COLUMNS CONS_C      \t WHERE      \t   CONS.CONSTRAINT_NAME=CONS_C.CONSTRAINT_NAME     \t   AND CONS.CONSTRAINT_TYPE='P'     \t   AND CONS.TABLE_NAME=B.TABLE_NAME      \t  AND CONS_C.COLUMN_NAME=A.COLUMN_NAME   \t ) AS IS_PK  FROM   \t USER_TAB_COLUMNS A,  \tUSER_COL_COMMENTS B   WHERE   \tA.COLUMN_NAME=B.COLUMN_NAME  \tAND A.TABLE_NAME = B.TABLE_NAME  \tAND A.TABLE_NAME='%s'  ORDER BY   \tA.COLUMN_ID";
    private final String SQL_GET_COLUMNS_BATCH = "SELECT  \tA.TABLE_NAME TABLE_NAME,  \tA.COLUMN_NAME NAME,  \tA.DATA_TYPE TYPENAME,  \tA.CHAR_COL_DECL_LENGTH LENGTH,   \tA.DATA_PRECISION PRECISION,  \tA.DATA_SCALE SCALE,  \tA.DATA_DEFAULT,  \tA.NULLABLE,   \tDECODE(B.COMMENTS,NULL,A.COLUMN_NAME,B.COMMENTS) DESCRIPTION,  \t(    \t  SELECT    \t    COUNT(*)    \t  FROM     \t    USER_CONSTRAINTS CONS,     \t   USER_CONS_COLUMNS CONS_C      \t WHERE      \t   CONS.CONSTRAINT_NAME=CONS_C.CONSTRAINT_NAME     \t   AND CONS.CONSTRAINT_TYPE='P'     \t   AND CONS.TABLE_NAME=B.TABLE_NAME      \t  AND CONS_C.COLUMN_NAME=A.COLUMN_NAME   \t ) AS IS_PK  FROM   \tUSER_TAB_COLUMNS A,  \tUSER_COL_COMMENTS B   WHERE   \tA.COLUMN_NAME=B.COLUMN_NAME  \tAND A.TABLE_NAME = B.TABLE_NAME ";
    private String sqlAllTables = "select TABLE_NAME,DECODE(COMMENTS,null,TABLE_NAME,comments) comments from user_tab_comments where table_type='TABLE'  ";

    @Override
    public Map<String, String> getTablesByName(String tableName) {
        String sql = this.sqlAllTables;
        if (StringUtils.isNotEmpty((String)tableName)) {
            sql = this.sqlAllTables + " and  lower(table_name) like '%" + tableName.toLowerCase() + "%'";
        }
        List list = this.jdbcTemplate.query(sql, (RowMapper)new RowMapper<Map<String, String>>(){

            public Map<String, String> mapRow(ResultSet rs, int row) throws SQLException {
                String tableName = rs.getString("table_name");
                String comments = rs.getString("comments");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", tableName);
                map.put("comments", comments);
                return map;
            }
        });
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < list.size(); ++i) {
            Map tmp = (Map)list.get(i);
            String name = (String)tmp.get("name");
            String comments = (String)tmp.get("comments");
            map.put(name, comments);
        }
        return map;
    }

    @Override
    public Map<String, String> getTablesByName(List<String> names) {
        StringBuffer sb = new StringBuffer();
        for (String name : names) {
            sb.append("'");
            sb.append(name);
            sb.append("',");
        }
        sb.deleteCharAt(sb.length() - 1);
        String sql = this.sqlAllTables + " and  lower(table_name) in (" + sb.toString().toLowerCase() + ")";
        List list = this.jdbcTemplate.query(sql, (RowMapper)new RowMapper<Map<String, String>>(){

            public Map<String, String> mapRow(ResultSet rs, int row) throws SQLException {
                String tableName = rs.getString("TABLE_NAME");
                String comments = rs.getString("COMMENTS");
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("NAME", tableName);
                map.put("COMMENTS", comments);
                return map;
            }
        });
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        for (int i = 0; i < list.size(); ++i) {
            Map tmp = (Map)list.get(i);
            String name = (String)tmp.get("NAME");
            String comments = (String)tmp.get("COMMENTS");
            map.put(name, comments);
        }
        return map;
    }

    @Override
    public Table getTableByName(String tableName) {
        tableName = tableName.toUpperCase();
        Table model = this.getTable(tableName);
        List<Column> columnList = this.getColumnsByTableName(tableName);
        model.setColumnList(columnList);
        return model;
    }

    private Table getTable(final String tableName) {
        String sql = String.format(this.sqlTableComment, tableName);
        Table tableModel = (Table)this.jdbcTemplate.queryForObject(sql, (RowMapper)new RowMapper<Table>(){

            public Table mapRow(ResultSet rs, int row) throws SQLException {
                DefaultTable tableModel = new DefaultTable();
                tableModel.setTableName(tableName);
                tableModel.setComment(rs.getString("comments"));
                return tableModel;
            }
        });
        if (BeanUtils.isEmpty((Object)tableModel)) {
            tableModel = new DefaultTable();
        }
        return tableModel;
    }

    private List<Column> getColumnsByTableName(String tableName) {
        String sql = String.format("SELECT  \tA.TABLE_NAME TABLE_NAME,  \tA.COLUMN_NAME NAME,  \tA.DATA_TYPE TYPENAME,  \tA.CHAR_COL_DECL_LENGTH LENGTH,   \tA.DATA_PRECISION PRECISION,  \tA.DATA_SCALE SCALE,  \tA.DATA_DEFAULT,  \tA.NULLABLE,   \tDECODE(B.COMMENTS,NULL,A.COLUMN_NAME,B.COMMENTS) DESCRIPTION,  \t(    \t  SELECT    \t    COUNT(*)    \t  FROM     \t    USER_CONSTRAINTS CONS,     \t   USER_CONS_COLUMNS CONS_C      \t WHERE      \t   CONS.CONSTRAINT_NAME=CONS_C.CONSTRAINT_NAME     \t   AND CONS.CONSTRAINT_TYPE='P'     \t   AND CONS.TABLE_NAME=B.TABLE_NAME      \t  AND CONS_C.COLUMN_NAME=A.COLUMN_NAME   \t ) AS IS_PK  FROM   \t USER_TAB_COLUMNS A,  \tUSER_COL_COMMENTS B   WHERE   \tA.COLUMN_NAME=B.COLUMN_NAME  \tAND A.TABLE_NAME = B.TABLE_NAME  \tAND A.TABLE_NAME='%s'  ORDER BY   \tA.COLUMN_ID", tableName);
        List columnList = this.jdbcTemplate.query(sql, (RowMapper)new OracleColumnMap());
        return columnList;
    }

    private Map<String, List<Column>> getColumnsByTableName(List<String> tableNames) {
        String sql = "SELECT  \tA.TABLE_NAME TABLE_NAME,  \tA.COLUMN_NAME NAME,  \tA.DATA_TYPE TYPENAME,  \tA.CHAR_COL_DECL_LENGTH LENGTH,   \tA.DATA_PRECISION PRECISION,  \tA.DATA_SCALE SCALE,  \tA.DATA_DEFAULT,  \tA.NULLABLE,   \tDECODE(B.COMMENTS,NULL,A.COLUMN_NAME,B.COMMENTS) DESCRIPTION,  \t(    \t  SELECT    \t    COUNT(*)    \t  FROM     \t    USER_CONSTRAINTS CONS,     \t   USER_CONS_COLUMNS CONS_C      \t WHERE      \t   CONS.CONSTRAINT_NAME=CONS_C.CONSTRAINT_NAME     \t   AND CONS.CONSTRAINT_TYPE='P'     \t   AND CONS.TABLE_NAME=B.TABLE_NAME      \t  AND CONS_C.COLUMN_NAME=A.COLUMN_NAME   \t ) AS IS_PK  FROM   \tUSER_TAB_COLUMNS A,  \tUSER_COL_COMMENTS B   WHERE   \tA.COLUMN_NAME=B.COLUMN_NAME  \tAND A.TABLE_NAME = B.TABLE_NAME ";
        HashMap<String, List<Column>> map = new HashMap<String, List<Column>>();
        if (tableNames != null && tableNames.size() == 0) {
            return map;
        }
        StringBuffer buf = new StringBuffer();
        for (String str : tableNames) {
            buf.append("'" + str + "',");
        }
        buf.deleteCharAt(buf.length() - 1);
        sql = sql + " AND A.TABLE_NAME IN (" + buf.toString() + ") ";
        List columnModels = this.jdbcTemplate.query(sql, (RowMapper)new OracleColumnMap());
        for (Column columnModel : columnModels) {
            String tableName = columnModel.getTableName();
            if (map.containsKey(tableName)) {
                ((List)map.get(tableName)).add(columnModel);
                continue;
            }
            ArrayList<Column> cols = new ArrayList<Column>();
            cols.add(columnModel);
            map.put(tableName, cols);
        }
        return map;
    }

    @Override
    public List<Table> getTableModelByName(String tableName) throws Exception {
        String sql = this.sqlAllTables;
        if (StringUtils.isNotEmpty((String)tableName)) {
            sql = sql + " AND  LOWER(table_name) LIKE '%" + tableName.toLowerCase() + "%'";
        }
        RowMapper<Table> rowMapper = new RowMapper<Table>(){

            public Table mapRow(ResultSet rs, int row) throws SQLException {
                DefaultTable tableModel = new DefaultTable();
                tableModel.setTableName(rs.getString("TABLE_NAME"));
                tableModel.setComment(rs.getString("COMMENTS"));
                return tableModel;
            }
        };
        List tableModels = this.jdbcTemplate.query(sql, (RowMapper)rowMapper);
        ArrayList<String> tableNames = new ArrayList<String>();
        for (Table model : tableModels) {
            tableNames.add(model.getTableName());
        }
        Map<String, List<Column>> tableColumnsMap = this.getColumnsByTableName(tableNames);
        for (Map.Entry<String, List<Column>> entry : tableColumnsMap.entrySet()) {
            for (Table model : tableModels) {
                if (!model.getTableName().equalsIgnoreCase(entry.getKey())) continue;
                model.setColumnList(entry.getValue());
            }
        }
        return tableModels;
    }

    @Override
    public String getAllTableSql() {
        return this.sqlAllTables;
    }

    @Override
    public List<Map<String, Object>> getTablesByNameIndex(String tableName) {
        String sqlIndex = "SELECT index_name, table_name FROM user_indexes WHERE table_name='%s'";
        String sql = String.format(sqlIndex, tableName.toUpperCase());
        List list = this.jdbcTemplate.query(sql, (RowMapper)new RowMapper<Map<String, Object>>(){

            public Map<String, Object> mapRow(ResultSet rs, int row) throws SQLException {
                String keyName = rs.getString("index_name");
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("keyName", keyName);
                return map;
            }
        });
        return list;
    }
}

