/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.table.operator.impl.db2;

import com.hotent.table.model.Column;
import com.hotent.table.model.Table;
import com.hotent.table.operator.impl.BaseTableOperator;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.springframework.jdbc.core.RowMapper;

public class DB2TableOperator
extends BaseTableOperator {
    @Override
    public void createTable(Table model) throws SQLException {
        List<Column> columnList = model.getColumnList();
        StringBuffer sb = new StringBuffer();
        String pkColumn = null;
        ArrayList<String> columnCommentList = new ArrayList<String>();
        sb.append("CREATE TABLE " + model.getTableName() + " (\n");
        for (int i = 0; i < columnList.size(); ++i) {
            String defVal;
            Column cm = columnList.get(i);
            sb.append("    ").append(cm.getFieldName()).append("    ");
            sb.append(this.getColumnType(cm.getColumnType(), cm.getCharLen(), cm.getIntLen(), cm.getDecimalLen()));
            sb.append(" ");
            if (cm.getIsPk()) {
                pkColumn = pkColumn == null ? cm.getFieldName() : pkColumn + "," + cm.getFieldName();
            }
            if (StringUtils.isNotEmpty((String)(defVal = this.getDefaultValueSQL(cm)))) {
                sb.append(defVal);
            }
            if (!cm.getIsNull() || cm.getIsPk()) {
                sb.append(" NOT NULL ");
            }
            if (cm.getComment() != null && cm.getComment().length() > 0) {
                columnCommentList.add("COMMENT ON COLUMN " + model.getTableName() + "." + cm.getFieldName() + " IS '" + cm.getComment() + "'\n");
            }
            sb.append(",\n");
        }
        if (pkColumn != null) {
            sb.append("    CONSTRAINT PK_").append(model.getTableName()).append(" PRIMARY KEY (").append(pkColumn).append(")");
        } else {
            sb = new StringBuffer(sb.substring(0, sb.length() - ",\n".length()));
        }
        sb.append("\n)");
        this.jdbcTemplate.execute(sb.toString());
        if (model.getComment() != null && model.getComment().length() > 0) {
            this.jdbcTemplate.execute("COMMENT ON TABLE " + model.getTableName() + " IS '" + model.getComment() + "'\n");
        }
        for (String columnComment : columnCommentList) {
            this.jdbcTemplate.execute(columnComment);
        }
    }

    private String getDefaultValueSQL(Column column) {
        String defaultValue = column.getDefaultValue();
        if (StringUtils.isEmpty((String)defaultValue)) {
            return "";
        }
        String sql = "";
        String columnType = column.getColumnType();
        sql = "int".equalsIgnoreCase(columnType) || "number".equalsIgnoreCase(columnType) || "date".equalsIgnoreCase(column.getColumnType()) ? " DEFAULT " + defaultValue + " " : ("varchar".equalsIgnoreCase(columnType) || "clob".equalsIgnoreCase(columnType) ? " DEFAULT '" + defaultValue + "' " : " DEFAULT " + defaultValue + " ");
        return sql;
    }

    @Override
    public String getColumnType(Column column) {
        return this.getColumnType(column.getColumnType(), column.getCharLen(), column.getIntLen(), column.getDecimalLen());
    }

    @Override
    public String getColumnType(String columnType, int charLen, int intLen, int decimalLen) {
        if ("varchar".equals(columnType)) {
            return "VARCHAR(" + charLen + ')';
        }
        if ("number".equals(columnType)) {
            return "DECIMAL(" + (intLen + decimalLen) + "," + decimalLen + ")";
        }
        if ("date".equals(columnType)) {
            return "DATE";
        }
        if ("int".equals(columnType)) {
            if (intLen > 0 && intLen <= 5) {
                return "SMALLINT";
            }
            if (intLen > 5 && intLen <= 10) {
                return "INTEGER";
            }
            return "BIGINT";
        }
        if ("clob".equals(columnType)) {
            return "CLOB";
        }
        return "VARCHAR(50)";
    }

    @Override
    public void dropTable(String tableName) throws SQLException {
        String selSql = "SELECT COUNT(*) AMOUNT FROM SYSCAT.TABLES  WHERE TABSCHEMA IN (SELECT CURRENT SQLID FROM SYSIBM.DUAL) AND TABNAME = UPPER('" + tableName + "')";
        int rtn = (Integer)this.jdbcTemplate.queryForObject(selSql, Integer.class);
        if (rtn <= 0) {
            return;
        }
        String sql = "drop table " + tableName;
        this.jdbcTemplate.execute(sql);
    }

    @Override
    public void updateTableComment(String tableName, String comment) throws SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("COMMENT ON TABLE ").append(tableName).append(" IS '").append(comment).append("'\n");
        this.jdbcTemplate.execute(sb.toString());
    }

    @Override
    public void addColumn(String tableName, Column model) throws SQLException {
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ").append(tableName);
        sb.append(" ADD ");
        sb.append(model.getFieldName()).append(" ");
        sb.append(this.getColumnType(model.getColumnType(), model.getCharLen(), model.getIntLen(), model.getDecimalLen()));
        String defVal = this.getDefaultValueSQL(model);
        if (StringUtils.isNotEmpty((String)defVal)) {
            sb.append(defVal);
        }
        sb.append("\n");
        this.jdbcTemplate.execute(sb.toString());
        if (model.getComment() != null && model.getComment().length() > 0) {
            this.jdbcTemplate.execute("COMMENT ON COLUMN " + tableName + "." + model.getFieldName() + " IS '" + model.getComment() + "'");
        }
    }

    @Override
    public void updateColumn(String tableName, String columnName, Column model) throws SQLException {
        if (!columnName.equalsIgnoreCase(model.getFieldName())) {
            StringBuffer addColumn = new StringBuffer();
            addColumn.append("alter table ");
            addColumn.append(tableName);
            addColumn.append(" add column ");
            addColumn.append("    ").append(model.getFieldName()).append("    ");
            addColumn.append(this.getColumnType(model.getColumnType(), model.getCharLen(), model.getIntLen(), model.getDecimalLen()));
            addColumn.append(" ");
            String defVal = this.getDefaultValueSQL(model);
            if (StringUtils.isNotEmpty((String)defVal)) {
                addColumn.append(defVal);
            }
            this.jdbcTemplate.execute(addColumn.toString());
            String copyValue = "update table " + tableName + " set " + model.getFieldName() + "=" + columnName;
            this.jdbcTemplate.execute(copyValue);
            String dropColumn = "alter table " + tableName + " drop column " + columnName;
            this.jdbcTemplate.execute(dropColumn);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("ALTER TABLE ").append(tableName);
        sb.append("  ALTER " + model.getFieldName()).append(" ");
        sb.append(" SET\tDATA TYPE ");
        sb.append(this.getColumnType(model.getColumnType(), model.getCharLen(), model.getIntLen(), model.getDecimalLen()));
        this.jdbcTemplate.execute(sb.toString());
        if (model.getIsNull()) {
            String nullable = "ALTER TABLE " + tableName + " ALTER " + model.getFieldName() + " DROP NOT NULL";
            this.jdbcTemplate.execute(nullable);
        } else {
            String notnull = "ALTER TABLE " + tableName + " ALTER " + model.getFieldName() + " SET NOT NULL";
            this.jdbcTemplate.execute(notnull);
        }
        if (model.getComment() != null && model.getComment().length() > 0) {
            this.updateColumnComment(tableName, model.getFieldName(), model);
        }
    }

    @Override
    public void updateColumnComment(String tableName, String columnName, Column column) {
        this.jdbcTemplate.execute("COMMENT ON COLUMN " + tableName + "." + columnName + " IS '" + column.getComment() + "'");
    }

    @Override
    public void addForeignKey(String pkTableName, String fkTableName, String pkField, String fkField) {
        String shortTableName = fkTableName.replaceFirst("(?im)W_", "");
        String sql = " ALTER TABLE " + fkTableName + " ADD CONSTRAINT FK_" + shortTableName + " FOREIGN KEY (" + fkField + ") REFERENCES " + pkTableName + " (" + pkField + ") ON DELETE CASCADE";
        this.jdbcTemplate.execute(sql);
    }

    @Override
    public void dropForeignKey(String tableName, String keyName) {
        String sql = "ALTER   TABLE   " + tableName + "   DROP   CONSTRAINT  " + keyName;
        this.jdbcTemplate.execute(sql);
    }

    @Override
    public List<String> getPKColumns(String tableName) throws SQLException {
        String sql = "";
        List columns = this.jdbcTemplate.query(sql, (RowMapper)new RowMapper<String>(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return rs.getString(1);
            }
        });
        return columns;
    }

    @Override
    public Map<String, List<String>> getPKColumns(List<String> tableNames) throws SQLException {
        StringBuffer sb = new StringBuffer();
        for (String name : tableNames) {
            sb.append("'");
            sb.append(name);
            sb.append("',");
        }
        sb.deleteCharAt(sb.length() - 1);
        String sql = "";
        HashMap<String, List<String>> columnsMap = new HashMap<String, List<String>>();
        List maps = this.jdbcTemplate.query(sql, (RowMapper)new RowMapper<Map<String, String>>(){

            public Map<String, String> mapRow(ResultSet rs, int rowNum) throws SQLException {
                String table = rs.getString(1);
                String column = rs.getString(2);
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("name", table);
                map.put("column", column);
                return map;
            }
        });
        for (Map map : maps) {
            if (columnsMap.containsKey(map.get("name"))) {
                ((List)columnsMap.get(map.get("name"))).add(map.get("column"));
                continue;
            }
            ArrayList cols = new ArrayList();
            cols.add(map.get("column"));
            columnsMap.put((String)map.get("name"), cols);
        }
        return columnsMap;
    }

    @Override
    public boolean isTableExist(String tableName) {
        String selSql = "SELECT COUNT(*) AMOUNT FROM SYSCAT.TABLES  WHERE TABSCHEMA IN (SELECT CURRENT SQLID FROM SYSIBM.DUAL) AND TABNAME = UPPER('" + tableName + "')";
        int rtn = (Integer)this.jdbcTemplate.queryForObject(selSql, Integer.class);
        return rtn > 0;
    }

    @Override
    public boolean isExsitPartition(String tableName, String partition) {
        return false;
    }

    @Override
    public void createPartition(String tableName, String partition) {
    }

    @Override
    public boolean supportPartition(String tableName) {
        return false;
    }

    @Override
    public void dropColumn(String tableName, String columnName) throws SQLException {
    }
}

