/*
 * Copyright © 2023 广州宏天软件股份有限公司 hotent
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.hotent.tenent.aipsdk.client;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.tenent.aipsdk.config.BaiduAipSdkFeignClientConfigurer;
import feign.Headers;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.*;

/**
 * 业务 RESTful 接口的 Feign 客户端。
 *
 * @author: 黎扬贵
 * @date: 2025/2/14 14:12
 * @version: 1.0
 */
@FeignClient(name = "baidu-ocr", url = "https://aip.baidubce.com", contextId = "tenet-aip-sdk", configuration = BaiduAipSdkFeignClientConfigurer.class)
public interface BaiduAipSdkFeignClient {

    // 获取Access Token的接口
    @GetMapping(value = "/oauth/2.0/token?grant_type=client_credentials")
    ObjectNode getAccessToken(@RequestParam("client_id") String clientId, @RequestParam("client_secret") String clientSecret);

    // 身份证识别接口
    @Headers("Content-Type: application/x-www-form-urlencoded")
    @PostMapping(value = "/rest/2.0/ocr/v1/idcard", consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    ObjectNode recognizeIdCard(@RequestParam("access_token") String accessToken, @RequestPart("image") String imageBase64, @RequestPart("id_card_side") String side);

    // 身份证混合识别接口
    @Headers("Content-Type: application/x-www-form-urlencoded")
    @PostMapping(value = "/rest/2.0/ocr/v1/multi_idcard", consumes = MediaType.MULTIPART_FORM_DATA_VALUE)
    ObjectNode recognizeMultiIdCard(@RequestParam("access_token") String accessToken, @RequestPart("image") String imageBase64);
}
