/*
 * Copyright © 2023 广州宏天软件股份有限公司 hotent
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.hotent.tenent.aipsdk.config;

import com.hotent.tenent.aipsdk.client.BaiduAipSdkFeignClient;
import com.hotent.tenent.aipsdk.properties.BaiduAipSdkProperties;
import com.hotent.tenent.aipsdk.service.BaiduAipSdkService;
import com.hotent.tenent.aipsdk.service.TokenService;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

/**
 * SDK 自动装配配置类，将各个组件注册到 Spring 容器中。
 *
 * @author: 黎扬贵
 * @date: 2025/2/14 14:12
 * @version: 1.0
 */
@Configuration
@Import(CacheConfig.class)
@EnableConfigurationProperties(BaiduAipSdkProperties.class)
@EnableFeignClients(clients = {BaiduAipSdkFeignClient.class})
public class BaiduAipSdkAutoConfiguration {
    /**
     * 创建 TokenService Bean。
     *
     * @return TokenService 实例
     */
    @Bean
    @ConditionalOnMissingBean
    public TokenService tokenService() {
        return new TokenService();
    }

    /**
     * 创建 BpmxSdkService Bean。
     *
     * @return BpmxSdkService 实例
     */
    @Bean
    @ConditionalOnMissingBean
    public BaiduAipSdkService baiduAipSdkService() {
        return new BaiduAipSdkService();
    }

}