/*
 * Copyright © 2023 广州宏天软件股份有限公司 hotent
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.hotent.tenent.aipsdk.config;

import com.hotent.tenent.aipsdk.builder.BaiduAipSdkFeignBuilderCustomizer;
import com.hotent.tenent.aipsdk.properties.BaiduAipSdkProperties;
import feign.Contract;
import feign.Logger;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.openfeign.clientconfig.FeignClientConfigurer;
import org.springframework.cloud.openfeign.support.SpringMvcContract;
import org.springframework.context.annotation.Bean;

/**
 * <pre>
 *     sdk 配置类
 *     1. 配置 Feign 日志级别。
 *     2. 配置 Feign 契约。
 *     3. 配置 Feign 拦截器。
 *     4. 配置 Feign 客户端。
 * </pre>
 * 
 * @author: 黎扬贵
 * @date: 2025/2/17 10:04
 * @version: 1.0
 */
public class BaiduAipSdkFeignClientConfigurer implements FeignClientConfigurer {

    /**
     * 是否继承全局的配置
     *
     * @return
     */
    @Override
    public boolean inheritParentConfiguration() {
        return false;
    }

    @Bean
    public BaiduAipSdkFeignBuilderCustomizer bpmxSdkFeignBuilderCustomizer(BaiduAipSdkProperties baiduAipSdkProperties) {
        return new BaiduAipSdkFeignBuilderCustomizer(baiduAipSdkProperties);
    }

    @Bean
    @ConditionalOnMissingBean
    public Contract feignContract() {
        return new SpringMvcContract();
    }

    /**
     * 配置 Feign 日志级别。
     *
     * @return Feign 日志级别
     */
    @Bean
    Logger.Level feignLoggerLevel() {
        return Logger.Level.BASIC;
    }

}
