/*
 * Copyright © 2023 广州宏天软件股份有限公司 hotent
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.hotent.tenent.aipsdk.config;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.concurrent.TimeUnit;

/**
 * 缓存配置类，用于配置 Caffeine 缓存。
 *
 * @author: 黎扬贵
 * @date: 2025/2/14 14:12
 * @version: 1.0
 */
@Configuration
public class CacheConfig {
    /**
     * 创建一个用于缓存 Token 响应的 Caffeine 缓存。Access token默认有效期为30天
     *
     * @return Token 响应缓存
     */
    @Bean
    public Cache<String, com.hotent.tenent.aipsdk.model.TokenResponse> tokenCache() {
        return Caffeine.newBuilder()
            .expireAfterWrite(29, TimeUnit.DAYS) // 最大过期时间，可根据实际情况调整
            .build();
    }
}