/*
 * Copyright © 2023 广州宏天软件股份有限公司 hotent
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.hotent.tenent.aipsdk.service;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.hotent.tenent.aipsdk.client.BaiduAipSdkFeignClient;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * SDK 服务类，封装业务接口的调用。
 *
 * @author: 黎扬贵
 * @date: 2025/2/14 14:12
 * @version: 1.0
 */
@Service
public class BaiduAipSdkService {
    @Autowired
    private BaiduAipSdkFeignClient baiduAipSdkFeignClient;
    @Autowired
    TokenService tokenService;

    // 身份证识别
    public ObjectNode recognizeIdCard(String imageBase64, String side) {
        String accessToken = tokenService.getAccessToken();
        return baiduAipSdkFeignClient.recognizeIdCard(accessToken, imageBase64, side);
    }

    // 新增身份证混合识别
    public ObjectNode recognizeMultiIdCard(String imageBase64) {
        String accessToken = tokenService.getAccessToken();
        return baiduAipSdkFeignClient.recognizeMultiIdCard(accessToken, imageBase64);
    }

}