/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.tenent.aipsdk.service;

import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.benmanes.caffeine.cache.Cache;
import com.hotent.tenent.aipsdk.client.BaiduAipSdkFeignClient;
import com.hotent.tenent.aipsdk.model.TokenResponse;
import com.hotent.tenent.aipsdk.properties.BaiduAipSdkProperties;
import java.time.Instant;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TokenService {
    @Autowired
    private BaiduAipSdkProperties baiduAipSdkProperties;
    @Autowired
    private BaiduAipSdkFeignClient baiduAipSdkFeignClient;
    @Autowired
    private Cache<String, TokenResponse> tokenCache;

    public synchronized String getAccessToken() {
        String cacheKey = this.baiduAipSdkProperties.getAppKey() + ":" + this.baiduAipSdkProperties.getSecretKey();
        TokenResponse tokenResponse = (TokenResponse)this.tokenCache.getIfPresent((Object)cacheKey);
        if (tokenResponse != null && this.isTokenValid(tokenResponse)) {
            return tokenResponse.getAccessToken();
        }
        ObjectNode accessToken = this.baiduAipSdkFeignClient.getAccessToken(this.baiduAipSdkProperties.getAppKey(), this.baiduAipSdkProperties.getSecretKey());
        if (accessToken == null) {
            throw new RuntimeException("\u83b7\u53d6 Token \u5931\u8d25");
        }
        if (accessToken.has("error")) {
            throw new RuntimeException(accessToken.get("error_description").asText());
        }
        String accessTokenStr = accessToken.get("access_token").asText();
        int expiresIn = accessToken.get("expires_in").asInt();
        tokenResponse = new TokenResponse();
        tokenResponse.setAccessToken(accessTokenStr);
        tokenResponse.setExpireIn(Instant.now().getEpochSecond() + (long)expiresIn - 5L);
        this.tokenCache.put((Object)cacheKey, (Object)tokenResponse);
        return tokenResponse.getAccessToken();
    }

    private boolean isTokenValid(TokenResponse tokenResponse) {
        return tokenResponse.getExpireIn() > Instant.now().getEpochSecond();
    }
}

