/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.tenet.logic.parser.el;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import com.hotent.tenet.logic.parser.base.AbstractLoopExpressParser;
import com.hotent.tenet.logic.parser.enums.ExpressParserEnum;
import com.hotent.tenet.logic.parser.vo.CmpProperty;
import com.hotent.tenet.logic.parser.vo.Properties;
import com.yomahub.liteflow.enums.ConditionTypeEnum;
import com.yomahub.liteflow.enums.NodeTypeEnum;
import com.yomahub.liteflow.flow.element.Chain;
import com.yomahub.liteflow.flow.element.Condition;
import com.yomahub.liteflow.flow.element.Executable;
import com.yomahub.liteflow.flow.element.Node;
import com.yomahub.liteflow.flow.element.condition.WhileCondition;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class WhileConditionParser
extends AbstractLoopExpressParser {
    @Override
    public ConditionTypeEnum parserType() {
        return ConditionTypeEnum.TYPE_WHILE;
    }

    @Override
    public CmpProperty builderCondition(Condition condition) {
        WhileCondition whileCondition = (WhileCondition)condition;
        Executable whileItem = whileCondition.getWhileItem();
        CmpProperty vo = null;
        if (whileItem instanceof Condition) {
            vo = this.builderChildVO((Condition)whileItem);
        } else if (whileItem instanceof Node) {
            vo = Optional.of((Node)whileItem).map(this.nodeMapper).orElse(new CmpProperty());
        } else if (whileItem instanceof Chain) {
            Chain chain = (Chain)whileItem;
            vo = this.buildChildrenChain(chain);
        }
        return vo;
    }

    @Override
    public String generateELMethod(CmpProperty jsonEl) {
        return "WHILE({}).DO({})";
    }

    @Override
    public String generateCondition(CmpProperty jsonEl, String elExpress) {
        if (Objects.isNull(jsonEl.getCondition())) {
            return elExpress;
        }
        CmpProperty condition = jsonEl.getCondition();
        String nodeComponentId = "";
        nodeComponentId = StringUtils.equals((CharSequence)NodeTypeEnum.BOOLEAN.getMappingClazz().getSimpleName(), (CharSequence)condition.getType()) ? condition.getId() : this.generateNodeComponent(condition, nodeComponentId);
        return StrUtil.replaceFirst((CharSequence)elExpress, (CharSequence)"{}", (CharSequence)nodeComponentId);
    }

    @Override
    public String generateCmp(CmpProperty jsonEl, String elExpress) {
        if (CollectionUtil.isEmpty(jsonEl.getChildren())) {
            return elExpress;
        }
        CmpProperty doExpressVO = this.nonBreakMapper(jsonEl.getChildren());
        String doEL = this.generateDoEL(doExpressVO);
        return StrUtil.format((CharSequence)elExpress, (Object[])new Object[]{doEL});
    }

    @Override
    public String generateIdAndTag(CmpProperty jsonEl, String elExpress) {
        Properties properties = jsonEl.getProperties();
        if (Objects.isNull(properties)) {
            return elExpress;
        }
        Object expressIdAndTag = "";
        if (StringUtils.isNotEmpty((CharSequence)properties.getId())) {
            expressIdAndTag = StrUtil.format((CharSequence)".id(\"{}\")", (Object[])new Object[]{properties.getId()});
        }
        if (StringUtils.isNotEmpty((CharSequence)properties.getTag())) {
            expressIdAndTag = (String)expressIdAndTag + StrUtil.format((CharSequence)".tag(\"{}\")", (Object[])new Object[]{properties.getTag()});
        }
        return StrUtil.appendIfMissing((CharSequence)elExpress, (CharSequence)expressIdAndTag, (CharSequence[])new CharSequence[0]);
    }

    @Override
    public String generateBreak(CmpProperty jsonEl, String elExpress) {
        if (Objects.isNull(jsonEl.getChildren()) || jsonEl.getChildren().isEmpty()) {
            return elExpress;
        }
        CmpProperty breakVO = this.breakMapper(jsonEl.getChildren());
        if (Objects.isNull(breakVO)) {
            return elExpress;
        }
        CmpProperty breakNode = this.foundBreakNode(breakVO.getChildren());
        if (Objects.isNull(breakNode)) {
            return elExpress;
        }
        if (StringUtils.equals((CharSequence)NodeTypeEnum.BOOLEAN.getMappingClazz().getSimpleName(), (CharSequence)breakNode.getType())) {
            String breakEL = StrUtil.format((CharSequence)".BREAK({})", (Object[])new Object[]{breakNode.getId()});
            elExpress = (String)elExpress + breakEL;
        }
        return elExpress;
    }

    @Override
    public ExpressParserEnum getExpressType(Condition condition) {
        return ExpressParserEnum.WHILE;
    }
}

