/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.tenet.logic.parser.enums;

import java.util.Objects;
import java.util.stream.Stream;

public enum DesignElementTypeEnum {
    StartEvent("StartEvent", "StartEvent"),
    EndEvent("EndEvent", "EndEvent"),
    Message("THEN", "Message"),
    ServerAction("THEN", "ServerAction"),
    SQL("THEN", "SQL"),
    Parallel("WHEN", "Parallel"),
    If("IF", "If"),
    Switch("SWITCH", "Switch"),
    ForEach("FOR", "ForEach"),
    While("WHILE", "While"),
    Converge("Converge", "Converge");

    private String parserType;
    private String designType;

    public String getParserType() {
        return this.parserType;
    }

    public String getDesignType() {
        return this.designType;
    }

    private DesignElementTypeEnum(String parserType, String designType) {
        this.parserType = parserType;
        this.designType = designType;
    }

    public static DesignElementTypeEnum of(String type) {
        Objects.requireNonNull(type);
        return Stream.of(DesignElementTypeEnum.values()).filter(bean -> bean.designType.equals(type)).findAny().orElseThrow(() -> new IllegalArgumentException(type + " not exists!"));
    }
}

