/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.tenet.logic.parser.factory;

import com.hotent.tenet.logic.parser.base.ExpressParser;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class ExpressParserFactory {
    Logger logger = LoggerFactory.getLogger(ExpressParserFactory.class);
    public static final Map<String, ExpressParser> PARSER_MAP = new ConcurrentHashMap<String, ExpressParser>();

    @Autowired(required=false)
    public void setParsers(List<ExpressParser> parsers) {
        if (CollectionUtils.isNotEmpty(parsers)) {
            parsers.forEach(this::register);
        }
    }

    public void register(ExpressParser parser) {
        if (parser.parserType() == null) {
            return;
        }
        Assert.notNull((Object)parser, (String)"ExpressParser parser must not be null");
        PARSER_MAP.put(parser.parserType().getType(), parser);
        this.logger.info("ExpressParser[{}] has been found", (Object)parser.parserType());
    }
}

