/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.tenet.logic.parser.generator;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.map.MapUtil;
import com.google.common.collect.Lists;
import com.hotent.tenet.logic.parser.enums.DesignElementTypeEnum;
import com.hotent.tenet.logic.parser.vo.CmpProperty;
import com.hotent.tenet.logic.parser.vo.DesignEdge;
import com.hotent.tenet.logic.parser.vo.DesignNode;
import com.hotent.tenet.logic.parser.vo.DesignProperty;
import com.yomahub.liteflow.util.JsonUtil;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class CmpPropertyGenerator {
    Logger logger = LoggerFactory.getLogger(CmpPropertyGenerator.class);

    public CmpProperty generateCmpProperty(String json) {
        DesignProperty designProperty = (DesignProperty)JsonUtil.parseObject((String)json, DesignProperty.class);
        this.buildEdgeIntoNode(designProperty);
        DesignNode startEventNode = this.getStartEventNode(designProperty);
        LinkedHashMap<String, Map<String, List<DesignNode>>> nodeGroups = new LinkedHashMap<String, Map<String, List<DesignNode>>>();
        this.groupNodesByType(nodeGroups, designProperty.getNodeByNodeKey(startEventNode.getOutgoing().get(0).getTarget()), designProperty, null, null, null, null);
        CmpProperty cmpProperty = this.buildCmpProperty(nodeGroups, designProperty);
        return cmpProperty;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void groupNodesByType(Map<String, Map<String, List<DesignNode>>> nodeGroups, DesignNode currentNode, DesignProperty designProperty, List<DesignEdge> untreatedOutgoing, List<DesignEdge> processedOutgoing, String currentDistributeTarget, Map<String, List<DesignNode>> distributeNodeMap) {
        if (currentNode.isEndEvent().booleanValue()) {
            if (CollUtil.isEmpty(processedOutgoing) && MapUtil.isEmpty(distributeNodeMap)) return;
            throw new RuntimeException("There cannot be an ending node in the distributed branch.");
        }
        if (currentNode.isSequential().booleanValue()) {
            Assert.equals((Object)1, (Object)currentNode.getIncoming().size(), (String)String.format("node key: %s should only be one incoming.", currentNode.getNodeKey()), (Object[])new Object[0]);
            List<DesignEdge> outgoing = currentNode.getOutgoing();
            Assert.equals((Object)1, (Object)outgoing.size(), (String)String.format("node key: %s should only be one outgoing.", currentNode.getNodeKey()), (Object[])new Object[0]);
            if (CollUtil.isEmpty(untreatedOutgoing)) {
                String target = outgoing.get(0).getTarget();
                LinkedHashMap<String, ArrayList> targetNodeMap = new LinkedHashMap<String, ArrayList>();
                targetNodeMap.put(target, CollUtil.newArrayList((Object[])new DesignNode[]{currentNode}));
                nodeGroups.put(currentNode.getNodeKey(), targetNodeMap);
                this.groupNodesByType(nodeGroups, designProperty.getNodeByNodeKey(target), designProperty, null, null, null, null);
                return;
            } else {
                Assert.isTrue((!MapUtil.isEmpty(distributeNodeMap) && !CollUtil.isEmpty(processedOutgoing) ? 1 : 0) != 0, (String)"When untreatedOutgoing is not empty, distributeNodeMap and processedOutgoing should not be empty.", (Object[])new Object[0]);
                distributeNodeMap.get(currentDistributeTarget).add(currentNode);
                this.groupNodesByType(nodeGroups, designProperty.getNodeByNodeKey(outgoing.get(0).getTarget()), designProperty, untreatedOutgoing, processedOutgoing, currentDistributeTarget, distributeNodeMap);
            }
            return;
        } else if (currentNode.isDistribute().booleanValue()) {
            Assert.equals((Object)1, (Object)currentNode.getIncoming().size(), (String)String.format("node key: %s should only be one incoming.", currentNode.getNodeKey()), (Object[])new Object[0]);
            if (CollUtil.isEmpty(processedOutgoing)) {
                List<DesignEdge> outgoing = currentNode.getOutgoing();
                Assert.isTrue((outgoing.size() > 1 ? 1 : 0) != 0, (String)String.format("node key: %s should have more than one outgoing.", currentNode.getNodeKey()), (Object[])new Object[0]);
                DesignEdge edgeForHandle = outgoing.get(0);
                String target = edgeForHandle.getTarget();
                LinkedHashMap<String, List<DesignNode>> targetNodeMap = new LinkedHashMap<String, List<DesignNode>>();
                targetNodeMap.put(target, CollUtil.newArrayList((Object[])new DesignNode[0]));
                nodeGroups.put(currentNode.getNodeKey(), targetNodeMap);
                ArrayList _processedOutgoing = CollUtil.newArrayList((Object[])new DesignEdge[]{edgeForHandle});
                this.groupNodesByType(nodeGroups, designProperty.getNodeByNodeKey(target), designProperty, outgoing, _processedOutgoing, target, targetNodeMap);
                return;
            } else {
                String currentNodeKey = currentNode.getNodeKey();
                Assert.isTrue((boolean)currentNodeKey.equals(untreatedOutgoing.get(0).getSource()), (String)"Re distribution is not allowed in the distribution node.", (Object[])new Object[0]);
                Assert.isTrue((!CollUtil.isEmpty(untreatedOutgoing) && !MapUtil.isEmpty(distributeNodeMap) ? 1 : 0) != 0, (String)"When processedOutgoing is not empty, untreatedOutgoing and distributeNodeMap should not be empty.", (Object[])new Object[0]);
                Assert.isTrue((untreatedOutgoing.size() > processedOutgoing.size() ? 1 : 0) != 0, (String)"UntreatedOutgoing size should more than processedOutgoing size.", (Object[])new Object[0]);
                DesignEdge anotherDesignEdge = untreatedOutgoing.stream().filter(uo -> processedOutgoing.stream().noneMatch(po -> po.getEdgeKey().equals(uo.getEdgeKey()))).findAny().orElseThrow(() -> new IllegalArgumentException("could not find another edge of " + currentNodeKey));
                processedOutgoing.add(anotherDesignEdge);
                String anotherTarget = anotherDesignEdge.getTarget();
                distributeNodeMap.put(anotherTarget, CollUtil.newArrayList((Object[])new DesignNode[0]));
                this.groupNodesByType(nodeGroups, designProperty.getNodeByNodeKey(anotherTarget), designProperty, untreatedOutgoing, processedOutgoing, anotherTarget, distributeNodeMap);
            }
            return;
        } else {
            if (!currentNode.isConverge().booleanValue()) throw new IllegalArgumentException(String.format("unknown design type: %s", currentNode.getType().getDesignType()));
            Assert.isTrue((!CollUtil.isEmpty(untreatedOutgoing) && !CollUtil.isEmpty(processedOutgoing) && !MapUtil.isEmpty(distributeNodeMap) ? 1 : 0) != 0, (String)"DistributeNodeMap, untreatedOutgoing and processedOutgoing should not be empty at converge node.", (Object[])new Object[0]);
            if (processedOutgoing.size() < untreatedOutgoing.size()) {
                String distributeNodeKey = untreatedOutgoing.get(0).getSource();
                this.groupNodesByType(nodeGroups, designProperty.getNodeByNodeKey(distributeNodeKey), designProperty, untreatedOutgoing, processedOutgoing, null, distributeNodeMap);
                return;
            } else {
                if (processedOutgoing.size() != untreatedOutgoing.size()) throw new RuntimeException("ProcessedOutgoing size should not more than untreatedOutgoing size.");
                List<DesignEdge> outgoing = currentNode.getOutgoing();
                Assert.equals((Object)1, (Object)outgoing.size(), (String)String.format("node key: %s should only be one outgoing.", currentNode.getNodeKey()), (Object[])new Object[0]);
                this.groupNodesByType(nodeGroups, designProperty.getNodeByNodeKey(outgoing.get(0).getTarget()), designProperty, null, null, null, null);
            }
        }
    }

    private CmpProperty buildCmpProperty(Map<String, Map<String, List<DesignNode>>> nodeGroups, DesignProperty designProperty) {
        int groupSize = nodeGroups.keySet().size();
        Assert.isTrue((groupSize > 0 ? 1 : 0) != 0, (String)"NodeGroups size could not be empty.", (Object[])new Object[0]);
        if (groupSize == 1) {
            Map.Entry<String, Map<String, List<DesignNode>>> firstGroup = nodeGroups.entrySet().iterator().next();
            String key = firstGroup.getKey();
            DesignNode headNode = designProperty.getNodeByNodeKey(key);
            Map<String, List<DesignNode>> value = firstGroup.getValue();
            return this.buildWithGroup(value, headNode);
        }
        CmpProperty cmpProperty = CmpProperty.build().type("THEN");
        for (Map.Entry<String, Map<String, List<DesignNode>>> next : nodeGroups.entrySet()) {
            String key = next.getKey();
            Map<String, List<DesignNode>> value = next.getValue();
            DesignNode headNode = designProperty.getNodeByNodeKey(key);
            cmpProperty.addChild(this.buildWithGroup(value, headNode));
        }
        return cmpProperty;
    }

    private CmpProperty buildWithGroup(Map<String, List<DesignNode>> group, DesignNode headNode) {
        if (headNode.isDistribute().booleanValue()) {
            CmpProperty headCmpProperty = CmpProperty.build().type(headNode.getType().getParserType());
            for (Map.Entry<String, List<DesignNode>> next : group.entrySet()) {
                String key = next.getKey();
                List<DesignNode> value = next.getValue();
                if (value.size() == 1) {
                    headCmpProperty.addChild(this.buildSingleCmpProperty(value.get(0)));
                    continue;
                }
                if (value.size() <= 1) continue;
                CmpProperty cp = CmpProperty.build().type("THEN");
                value.forEach(v -> cp.addChild(this.buildSingleCmpProperty((DesignNode)v)));
                headCmpProperty.addChild(cp);
            }
            return headCmpProperty;
        }
        if (headNode.isSequential().booleanValue()) {
            return this.buildSingleCmpProperty(headNode);
        }
        throw new RuntimeException(String.format("\u5904\u7406\u8282\u70b9s%\u65f6\u9047\u5230\u9884\u671f\u4e4b\u5916\u7684\u7c7b\u578b", new Object[]{headNode.getType()}));
    }

    private CmpProperty buildSingleCmpProperty(DesignNode designNode) {
        return CmpProperty.build().id(designNode.getNodeKey()).type(designNode.getComponentType());
    }

    private DesignNode getStartEventNode(DesignProperty designProperty) {
        List<DesignNode> startNodes = designProperty.getNodesByType(DesignElementTypeEnum.StartEvent);
        Assert.equals((Object)1, (Object)startNodes.size(), (String)"StartEvent should have and only have one.", (Object[])new Object[0]);
        return startNodes.get(0);
    }

    private List<DesignNode> getNextNodes(DesignProperty designProperty, DesignNode currentNode) {
        ArrayList nodes = Lists.newArrayList();
        currentNode.getOutgoing().stream().forEach(edge -> nodes.add(designProperty.getNodeByNodeKey(edge.getTarget())));
        return nodes;
    }

    private void handleCompleteEdge(DesignEdge designEdge, List<DesignEdge> edges) {
        DesignEdge matchEdge = edges.stream().filter(edge -> edge.getEdgeKey().equals(designEdge.getEdgeKey())).findAny().orElseThrow(() -> new IllegalArgumentException(designEdge.getEdgeKey() + " not exists!"));
        designEdge.setSource(matchEdge.getSource());
        designEdge.setTarget(matchEdge.getTarget());
    }

    private void buildEdgeIntoNode(DesignProperty designProperty) {
        List<DesignEdge> edges = designProperty.getEdges();
        designProperty.getNodes().stream().forEach(node -> {
            node.getIncoming().stream().forEach(designEdge -> this.handleCompleteEdge((DesignEdge)designEdge, edges));
            node.getOutgoing().stream().forEach(designEdge -> this.handleCompleteEdge((DesignEdge)designEdge, edges));
        });
    }
}

