/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.tenet.logic.parser.generator;

import com.hotent.tenet.logic.parser.base.ExpressParser;
import com.hotent.tenet.logic.parser.selector.ParserSelector;
import com.hotent.tenet.logic.parser.vo.CmpProperty;
import com.hotent.tenet.logic.parser.vo.ELInfo;
import com.ql.util.express.DefaultContext;
import com.ql.util.express.IExpressContext;
import com.yomahub.liteflow.builder.el.LiteFlowChainELBuilder;
import com.yomahub.liteflow.flow.FlowBus;
import com.yomahub.liteflow.flow.element.Condition;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ExpressGenerator {
    Logger logger = LoggerFactory.getLogger(ExpressGenerator.class);

    public CmpProperty generateJsonEL(ELInfo elInfo) {
        CmpProperty cmpProperty = new CmpProperty();
        try {
            DefaultContext context = new DefaultContext();
            FlowBus.getChainMap().values().forEach(chain -> context.put((Object)chain.getChainId(), chain));
            FlowBus.getNodeMap().keySet().forEach(nodeId -> context.put(nodeId, (Object)FlowBus.getNode((String)nodeId)));
            assert (elInfo != null);
            context.put((Object)"currChainId", (Object)elInfo.getChainId());
            ArrayList errorList = new ArrayList();
            String elStr = elInfo.getElStr();
            this.logger.info("----- {}", (Object)elStr);
            Condition condition = (Condition)LiteFlowChainELBuilder.EXPRESS_RUNNER.execute(elStr, (IExpressContext)context, errorList, true, true);
            cmpProperty = this.builderJsonEL(condition);
        }
        catch (Exception ex) {
            this.logger.error("-----", (Throwable)ex);
        }
        return cmpProperty;
    }

    private CmpProperty builderJsonEL(Condition condition) {
        ExpressParser parser = ParserSelector.getParser(condition);
        CmpProperty cmpProperty = parser.builderVO(condition);
        cmpProperty.setCondition(parser.builderCondition(condition));
        cmpProperty.setChildren(parser.builderChildren(condition));
        return cmpProperty;
    }

    public ELInfo generateEL(CmpProperty jsonEl) {
        ELInfo vo = new ELInfo();
        String elStr = this.builderEL(jsonEl);
        vo.setElStr(elStr);
        return vo;
    }

    public boolean verifyELExpression(CmpProperty jsonEl) {
        String elStr = this.builderEL(jsonEl);
        if (null == elStr) {
            return false;
        }
        this.logger.info("\u751f\u6210EL\u8868\u8fbe\u5f0f\u6210\u529f, elStr: {}", (Object)elStr);
        return LiteFlowChainELBuilder.validate((String)elStr);
    }

    private String builderEL(CmpProperty jsonEl) {
        ExpressParser parser = ParserSelector.getParser(jsonEl.getType().toLowerCase());
        String elExpress = parser.generateELMethod(jsonEl);
        elExpress = parser.generateCondition(jsonEl, elExpress);
        elExpress = parser.generateCmp(jsonEl, elExpress);
        elExpress = parser.generateIdAndTag(jsonEl, elExpress);
        elExpress = parser.generateELEnd(jsonEl, elExpress);
        return elExpress;
    }
}

