/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.tenet.logic.parser.vo;

import com.hotent.tenet.logic.parser.enums.DesignElementTypeEnum;
import com.hotent.tenet.logic.parser.vo.DesignEdge;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;

@Schema(description="\u903b\u8f91\u6a21\u578b\u8bbe\u8ba1\u6570\u636e\u8282\u70b9")
public class DesignNode {
    @Schema(description="\u8282\u70b9key")
    private String nodeKey;
    @Schema(description="\u8282\u70b9\u6807\u9898")
    private String title;
    @Schema(description="\u8282\u70b9\u7c7b\u578b")
    private DesignElementTypeEnum type;
    @Schema(description="\u8282\u70b9\u8fdb\u7ebf")
    private List<DesignEdge> incoming;
    @Schema(description="\u8282\u70b9\u51fa\u7ebf")
    private List<DesignEdge> outgoing;

    public DesignNode() {
    }

    public DesignNode(String nodeKey, String title, DesignElementTypeEnum type, List<DesignEdge> incoming, List<DesignEdge> outgoing) {
        this.nodeKey = nodeKey;
        this.title = title;
        this.type = type;
        this.incoming = incoming;
        this.outgoing = outgoing;
    }

    public String getNodeKey() {
        return this.nodeKey;
    }

    public void setNodeKey(String nodeKey) {
        this.nodeKey = nodeKey;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public DesignElementTypeEnum getType() {
        return this.type;
    }

    public void setType(DesignElementTypeEnum type) {
        this.type = type;
    }

    public List<DesignEdge> getIncoming() {
        return this.incoming;
    }

    public void setIncoming(List<DesignEdge> incoming) {
        this.incoming = incoming;
    }

    public List<DesignEdge> getOutgoing() {
        return this.outgoing;
    }

    public void setOutgoing(List<DesignEdge> outgoing) {
        this.outgoing = outgoing;
    }

    public String getComponentType() {
        return switch (this.type) {
            case DesignElementTypeEnum.Switch -> "SwitchComponent";
            case DesignElementTypeEnum.If, DesignElementTypeEnum.While -> "NodeBooleanComponent";
            case DesignElementTypeEnum.ForEach -> "ForComponent";
            default -> "NodeComponent";
        };
    }

    public Boolean isStartEvent() {
        return DesignElementTypeEnum.StartEvent.equals((Object)this.getType());
    }

    public Boolean isEndEvent() {
        return DesignElementTypeEnum.EndEvent.equals((Object)this.getType());
    }

    public Boolean isConverge() {
        return DesignElementTypeEnum.Converge.equals((Object)this.getType());
    }

    public Boolean isDistribute() {
        return DesignElementTypeEnum.Parallel.equals((Object)this.getType()) || DesignElementTypeEnum.If.equals((Object)this.getType()) || DesignElementTypeEnum.Switch.equals((Object)this.getType()) || DesignElementTypeEnum.ForEach.equals((Object)this.getType()) || DesignElementTypeEnum.While.equals((Object)this.getType());
    }

    public Boolean isSequential() {
        return "THEN".equals(this.getType().getParserType());
    }
}

