/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.tenet.logic.component;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.hotent.base.core.common.exception.bean.BaseException;
import com.hotent.tenet.logic.component.AbstractNodeComponent;
import com.hotent.tenet.logic.core.getter.impl.ApiNodeOptionGetter;
import com.hotent.tenet.logic.core.parser.impl.FixedVariableParser;
import com.hotent.tenet.logic.core.resolver.WebValueResolver;
import com.hotent.tenet.logic.model.context.LogicContext;
import com.hotent.tenet.logic.model.web.ApiOptions;
import com.hotent.tenet.logic.utils.ResultCheckUtil;
import com.yomahub.liteflow.annotation.LiteflowComponent;
import jakarta.annotation.Resource;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@LiteflowComponent(value="API", name="\u63a5\u53e3\u8bf7\u6c42\u8282\u70b9")
public class ApiNodeComponent
extends AbstractNodeComponent<ApiNodeOptionGetter, ApiOptions> {
    Logger logger = LoggerFactory.getLogger(ApiNodeComponent.class);
    @Resource
    RestTemplate restTemplate;
    @Resource
    FixedVariableParser fixedVariableParser;
    @Resource
    List<WebValueResolver> webValueResolvers;

    public ApiNodeComponent(ApiNodeOptionGetter nodeOptionGetter) {
        super(nodeOptionGetter);
    }

    @Override
    public void before(ApiOptions options) {
        ApiOptions.WebApi webApi = Optional.ofNullable(options.getWebApi()).orElseThrow(() -> new BaseException("WebApi\u914d\u7f6e\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a"));
        LogicContext context = (LogicContext)((Object)this.getContextBean(LogicContext.class));
        Map contextMap = BeanUtil.beanToMap((Object)((Object)context), (String[])new String[0]);
        ((List)Optional.ofNullable(webApi.getParamsRequest()).orElse(new ArrayList())).forEach(item -> this.valueResolveApply(contextMap, (ApiOptions.WebApi.Param)item));
        ((List)Optional.ofNullable(webApi.getParamsPath()).orElse(new ArrayList())).forEach(item -> this.valueResolveApply(contextMap, (ApiOptions.WebApi.Param)item));
        ((List)Optional.ofNullable(webApi.getParamsHeader()).orElse(new ArrayList())).forEach(item -> this.valueResolveApply(contextMap, (ApiOptions.WebApi.Param)item));
        ApiOptions.WebApi.Body body = webApi.getBody();
        if (body != null) {
            body.setValue(this.parseBody(Optional.ofNullable(body.getValue()).orElse(""), contextMap));
        }
        this.replacePathVariable(webApi, context.getGlobal());
        this.appendParam(webApi);
    }

    @Override
    public Object handle(ApiOptions options) {
        String baseUrl = "http://127.0.0.1:8088";
        ApiOptions.WebApi webApi = options.getWebApi();
        String requestUrl = webApi.getRequestUrl();
        requestUrl = Optional.ofNullable(requestUrl).map(r -> r.replace("${baseUrl}", baseUrl)).orElse("");
        HttpEntity<String> httpEntity = this.buildHttpEntity(webApi);
        this.logger.info("requestUrl:{}     method:{}", (Object)requestUrl, (Object)HttpMethod.valueOf((String)webApi.getRequestMethod().toUpperCase()));
        return this.restTemplate.exchange(URI.create(requestUrl), HttpMethod.valueOf((String)webApi.getRequestMethod().toUpperCase()), httpEntity, String.class);
    }

    @Override
    public void after(ApiOptions options, Object result) {
        ApiOptions.WebApi webApi = options.getWebApi();
        LogicContext context = (LogicContext)((Object)this.getContextBean(LogicContext.class));
        if (result instanceof ResponseEntity) {
            List<ApiOptions.WebApi.Output> outputList;
            ResponseEntity responseEntity = (ResponseEntity)result;
            String body = String.valueOf(responseEntity.getBody());
            ApiOptions.WebApi.AssertOutput assertOutput = webApi.getAssertOutput();
            if (assertOutput != null) {
                Assert.isTrue((boolean)ResultCheckUtil.matching(body, assertOutput.getParamPath(), assertOutput.getMatchRegex(), assertOutput.getExpectedValue()), (String)"\u63a5\u53e3\u8fd4\u56de\u4e0e\u9884\u6d4b\u4e0d\u7b26\u3002", (Object[])new Object[0]);
            }
            if (CollectionUtil.isEmpty(outputList = webApi.getOutput())) {
                return;
            }
            for (ApiOptions.WebApi.Output output : outputList) {
                Object o = ResultCheckUtil.buildTargetValue(body, this.fixedVariableParser.parse(output.getPath(), context.getGlobal()));
                BeanUtil.setProperty((Object)((Object)context), (String)output.getParams().getKey(), (Object)o);
            }
        }
    }

    private HttpEntity<String> buildHttpEntity(ApiOptions.WebApi webApi) {
        String body = Optional.ofNullable(webApi.getBody()).map(ApiOptions.WebApi.Body::getValue).orElse("");
        HttpHeaders header = new HttpHeaders();
        List<ApiOptions.WebApi.Param> paramsHeader = webApi.getParamsHeader();
        if (CollectionUtil.isNotEmpty(paramsHeader)) {
            header = paramsHeader.stream().filter(Objects::nonNull).filter(param -> StrUtil.isNotEmpty((CharSequence)param.getKey())).filter(param -> Objects.nonNull(param.getValue())).collect(HttpHeaders::new, (m, v) -> m.add(v.getKey(), String.valueOf(v.getValue().getFixedValue())), HttpHeaders::putAll);
        }
        return new HttpEntity((Object)body, (MultiValueMap)header);
    }

    private void valueResolveApply(Map<String, Object> inputMap, ApiOptions.WebApi.Param param) {
        this.webValueResolvers.stream().filter(item -> item.supports(param)).forEach(item -> item.apply(inputMap, param));
    }

    private String parseBody(String body, Map<String, Object> inputMap) {
        return this.fixedVariableParser.parse(body, inputMap);
    }

    private void replacePathVariable(ApiOptions.WebApi webApi, Map<String, Object> inputMap) {
        List<ApiOptions.WebApi.Param> paramsPath = webApi.getParamsPath();
        if (CollectionUtil.isEmpty(paramsPath)) {
            return;
        }
        HashMap pathVariableMap = paramsPath.stream().collect(HashMap::new, (m, v) -> m.put(v.getKey(), v.getValue().getFixedValue()), HashMap::putAll);
        pathVariableMap.putAll(inputMap);
        String requestUrl = this.fixedVariableParser.parse(webApi.getRequestUrl(), pathVariableMap);
        webApi.setRequestUrl(requestUrl);
    }

    private void appendParam(ApiOptions.WebApi webApi) {
        Object requestUrl = webApi.getRequestUrl();
        List<ApiOptions.WebApi.Param> paramsRequest = webApi.getParamsRequest();
        if (CollectionUtil.isNotEmpty(paramsRequest)) {
            String paramStr = HttpUtil.toParams(paramsRequest.stream().filter(param -> StrUtil.isNotEmpty((CharSequence)param.getKey()) && param.getValue().getFixedValue() != null).collect(Collectors.toMap(ApiOptions.WebApi.Param::getKey, param -> param.getValue().getFixedValue())));
            int lastIndexOf = ((String)requestUrl).lastIndexOf("?");
            requestUrl = lastIndexOf == -1 ? (String)requestUrl + "?" + paramStr : (lastIndexOf == ((String)requestUrl).length() - 1 ? (String)requestUrl + paramStr : (String)requestUrl + "&" + paramStr);
            webApi.setRequestUrl((String)requestUrl);
        }
    }
}

