/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.tenet.logic.component;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.codec.Base64;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.resource.Resource;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjUtil;
import com.hotent.tenet.logic.component.AbstractNodeComponent;
import com.hotent.tenet.logic.core.getter.impl.FileReadNodeOptionGetter;
import com.hotent.tenet.logic.core.io.ResourceLoader;
import com.hotent.tenet.logic.core.parser.VariableParseService;
import com.hotent.tenet.logic.model.context.LogicContext;
import com.hotent.tenet.logic.model.context.NodeParam;
import com.hotent.tenet.logic.model.context.NodeValue;
import com.hotent.tenet.logic.model.file.FileReadOptions;
import com.yomahub.liteflow.annotation.LiteflowComponent;
import java.io.InputStream;
import java.util.Map;
import java.util.Optional;

@LiteflowComponent(value="FILE_READ", name="\u6587\u4ef6\u8bfb\u53d6\u8282\u70b9")
public class FileReadNodeComponent
extends AbstractNodeComponent<FileReadNodeOptionGetter, FileReadOptions> {
    @jakarta.annotation.Resource
    Map<String, ResourceLoader> resourceLoaderMap;
    @jakarta.annotation.Resource
    VariableParseService variableParseService;

    public FileReadNodeComponent(FileReadNodeOptionGetter nodeOptionGetter) {
        super(nodeOptionGetter);
    }

    @Override
    public void before(FileReadOptions options) {
        Assert.notNull((Object)options.getLocation(), (String)"\u5165\u53c2\u5b57\u6bb5\u672a\u586b\uff0c\u65e0\u6cd5\u4e0a\u4f20", (Object[])new Object[0]);
        NodeParam param = options.getLocation();
        Object parse = this.variableParseService.parse(param.getValue().getType(), String.valueOf(param.getValue().getValue()), this.getContextBean(LogicContext.class));
        param.getValue().setValue(parse);
    }

    @Override
    public Object handle(FileReadOptions options) {
        ResourceLoader resourceLoader = this.resourceLoaderMap.get(options.getInputType() + "ResourceLoader");
        Assert.notNull((Object)resourceLoader, (String)String.format("\u4e0d\u5b58\u5728%s\u6587\u4ef6\u8bfb\u53d6\u65b9\u5f0f", options.getInputType()), (Object[])new Object[0]);
        Object value = Optional.ofNullable(options.getLocation()).map(NodeParam::getValue).map(NodeValue::getValue).orElse("");
        return resourceLoader.getResource(String.valueOf(value));
    }

    @Override
    public void after(FileReadOptions options, Object result) {
        Resource resource = (Resource)Convert.convert(Resource.class, (Object)result);
        Assert.notNull((Object)resource, (String)"\u8d44\u6e90\u8bfb\u53d6\u5931\u8d25", (Object[])new Object[0]);
        NodeParam output = options.getOutputVar();
        if (ObjUtil.isEmpty((Object)output)) {
            return;
        }
        Object value = this.getResult(resource, options.getOutputType());
        if (value != null) {
            LogicContext context = (LogicContext)((Object)this.getContextBean(LogicContext.class));
            context.setResult(value);
            Object property = BeanUtil.getProperty((Object)((Object)context), (String)output.getResultField());
            BeanUtil.setProperty((Object)((Object)context), (String)output.getName(), (Object)property);
        }
    }

    private Object getResult(Resource resource, String outputType) {
        return switch (outputType) {
            case "text" -> IoUtil.readUtf8((InputStream)resource.getStream());
            case "byte" -> IoUtil.readBytes((InputStream)resource.getStream());
            case "stream" -> resource.getStream();
            case "base64" -> Base64.encode((byte[])IoUtil.readBytes((InputStream)resource.getStream()));
            default -> null;
        };
    }
}

