/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.tenet.logic.component;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.statement.SQLDeleteStatement;
import com.alibaba.druid.sql.ast.statement.SQLInsertStatement;
import com.alibaba.druid.sql.ast.statement.SQLSelectStatement;
import com.alibaba.druid.sql.ast.statement.SQLUpdateStatement;
import com.alibaba.druid.sql.parser.SQLParserFeature;
import com.hotent.base.core.utils.MapUtil;
import com.hotent.base.dynamicdatasource.database.DatabaseContext;
import com.hotent.base.mybatisplus.mvc.manager.CommonManager;
import com.hotent.tenet.logic.component.AbstractNodeComponent;
import com.hotent.tenet.logic.core.getter.impl.SqlNodeOptionGetter;
import com.hotent.tenet.logic.core.parser.VariableParseService;
import com.hotent.tenet.logic.model.context.LogicContext;
import com.hotent.tenet.logic.model.sql.SqlOptions;
import com.hotent.tenet.logic.sql.SqlGenerator;
import com.yomahub.liteflow.annotation.LiteflowComponent;
import jakarta.annotation.Resource;
import java.util.Collection;
import java.util.List;
import java.util.Map;

@LiteflowComponent(value="SQL", name="sql\u8282\u70b9")
public class SqlNodeComponent
extends AbstractNodeComponent<SqlNodeOptionGetter, SqlOptions> {
    @Resource
    DatabaseContext databaseContext;
    @Resource
    CommonManager commonManager;
    @Resource
    Map<String, SqlGenerator> sqlGeneratorMap;
    @Resource
    VariableParseService variableParseService;

    public SqlNodeComponent(SqlNodeOptionGetter nodeOptionGetter) {
        super(nodeOptionGetter);
    }

    @Override
    public Object handle(SqlOptions options) throws Exception {
        return this.databaseContext.switchDS(options.getDatasourceAlias(), switchResult -> {
            String sql = options.getSql();
            Assert.notEmpty((CharSequence)sql, (String)"SQL\u8bed\u53e5\u4e0d\u80fd\u4e3a\u7a7a", (Object[])new Object[0]);
            SQLStatement statement = SQLUtils.parseSingleStatement((String)sql, (String)switchResult.getDbType(), (SQLParserFeature[])new SQLParserFeature[0]);
            if (statement instanceof SQLSelectStatement) {
                return this.commonManager.query(sql);
            }
            if (statement instanceof SQLUpdateStatement) {
                return this.commonManager.execute(sql);
            }
            if (statement instanceof SQLInsertStatement) {
                this.commonManager.execute(sql);
            } else if (statement instanceof SQLDeleteStatement) {
                this.commonManager.execute(sql);
            }
            return null;
        });
    }

    @Override
    public void before(SqlOptions options) throws Exception {
        if (StrUtil.isBlank((CharSequence)options.getSql())) {
            this.parseVariable(options, (LogicContext)((Object)this.getContextBean(LogicContext.class)));
            this.databaseContext.switchDS(options.getDatasourceAlias(), switchResult -> {
                String generatorName = StrUtil.toCamelCase((CharSequence)("sql_" + options.getType() + "_generator"));
                SqlGenerator sqlGenerator = this.sqlGeneratorMap.get(generatorName);
                String sql = sqlGenerator.generate(options, DbType.valueOf((String)switchResult.getDbType()));
                options.setSql(sql);
                return null;
            });
        }
    }

    private void parseVariable(SqlOptions options, LogicContext context) {
        List fields = CollectionUtil.unionAll(options.getInputs(), options.getWheres(), (Collection[])new Collection[0]);
        for (SqlOptions.Field item : fields) {
            Object parse = this.variableParseService.parse(item.getType(), item.getValue(), (Object)context);
            item.setValue(String.valueOf(parse));
        }
    }

    @Override
    public void after(SqlOptions options, Object result) {
        super.after(options, result);
        Map resultMap = MapUtil.buildMap((String)"result", (Object)result);
        LogicContext logicContext = (LogicContext)((Object)this.getContextBean(LogicContext.class));
        options.getOutputVars().forEach(var -> {
            String resultField = var.getResultField();
            Object property = BeanUtil.getProperty((Object)resultMap, (String)resultField);
            Assert.isFalse((boolean)ObjectUtil.isEmpty((Object)property), (String)String.format("\u83b7\u53d6%s\u65f6\u503c\u4e3a\u7a7a", resultField), (Object[])new Object[0]);
            BeanUtil.setProperty((Object)((Object)logicContext), (String)var.getName(), (Object)property);
        });
    }
}

