/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.tenet.logic.core.enums;

import cn.hutool.core.util.ObjUtil;
import cn.hutool.core.util.StrUtil;
import com.hotent.tenet.logic.core.service.OperatorHandler;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum OperatorEnum implements OperatorHandler
{
    EQUAL{

        @Override
        public boolean handle(Object left, Object right) {
            return ObjUtil.equals((Object)left, (Object)right);
        }
    }
    ,
    NOT_EQUAL{

        @Override
        public boolean handle(Object left, Object right) {
            return ObjUtil.notEqual((Object)left, (Object)right);
        }
    }
    ,
    GREAT_THAN{

        @Override
        public boolean handle(Object left, Object right) {
            return this.compare(left, right) > 0;
        }
    }
    ,
    GREAT_EQUAL{

        @Override
        public boolean handle(Object left, Object right) {
            return this.compare(left, right) >= 0;
        }
    }
    ,
    LESS_THAN{

        @Override
        public boolean handle(Object left, Object right) {
            return this.compare(left, right) < 0;
        }
    }
    ,
    LESS_EQUAL{

        @Override
        public boolean handle(Object left, Object right) {
            return this.compare(left, right) <= 0;
        }
    }
    ,
    INCLUDE{

        @Override
        public boolean handle(Object left, Object right) {
            return ObjUtil.contains((Object)left, (Object)right);
        }
    }
    ,
    BETWEEN{

        @Override
        public boolean handle(Object left, Object right) {
            return ObjUtil.contains((Object)right, (Object)left);
        }
    }
    ,
    EMPTY{

        @Override
        public boolean handle(Object left, Object right) {
            return ObjUtil.isEmpty((Object)left);
        }
    }
    ,
    NOT_EMPTY{

        @Override
        public boolean handle(Object left, Object right) {
            return ObjUtil.isNotEmpty((Object)left);
        }
    }
    ,
    START_WITH{

        @Override
        public boolean handle(Object left, Object right) {
            if (left == null || right == null) {
                return false;
            }
            if (left instanceof String) {
                String l = (String)left;
                if (right instanceof String) {
                    String r = (String)right;
                    return StrUtil.startWith((CharSequence)l, (CharSequence)r);
                }
            }
            return false;
        }
    }
    ,
    END_WITH{

        @Override
        public boolean handle(Object left, Object right) {
            if (left == null || right == null) {
                return false;
            }
            if (left instanceof String) {
                String l = (String)left;
                if (right instanceof String) {
                    String r = (String)right;
                    return StrUtil.endWith((CharSequence)l, (CharSequence)r);
                }
            }
            return false;
        }
    };

}

