/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.tenet.logic.sql;

import cn.hutool.core.lang.Assert;
import com.alibaba.druid.DbType;
import com.alibaba.druid.sql.SQLUtils;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.builder.impl.SQLSelectBuilderImpl;
import com.hotent.tenet.logic.model.sql.SqlOptions;
import com.hotent.tenet.logic.sql.SqlGenerator;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class SqlSelectGenerator
implements SqlGenerator {
    @Override
    public String generate(SqlOptions sqlOptions, DbType dbType) {
        SQLSelectBuilderImpl selectBuilder = new SQLSelectBuilderImpl(dbType);
        Assert.notEmpty((CharSequence)sqlOptions.getTableName(), (String)"\u914d\u7f6e\u4fe1\u606f\u4e2d\uff0c\u8868\u540d\u4e0d\u5b58\u5728\uff01", (Object[])new Object[0]);
        selectBuilder.from(sqlOptions.getTableName());
        List<SqlOptions.Field> outputs = sqlOptions.getOutputs();
        outputs.forEach(item -> {
            Assert.notEmpty((CharSequence)item.getKey(), (String)"\u67e5\u8be2\u7684\u5b57\u6bb5\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            String alias = Optional.ofNullable(item.getAlias()).orElse(item.getKey());
            selectBuilder.selectWithAlias(item.getKey(), alias);
        });
        List<SqlOptions.Field> sorts = sqlOptions.getSorts();
        sorts.forEach(item -> {
            Assert.notEmpty((CharSequence)item.getKey(), (String)"\u6392\u5e8f\u6761\u4ef6\u7684\u5b57\u6bb5\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            selectBuilder.orderBy(new String[]{item.getKey()});
        });
        List<SqlOptions.Field> wheres = sqlOptions.getWheres();
        wheres.forEach(item -> {
            Assert.notEmpty((CharSequence)item.getKey(), (String)"\u6761\u4ef6\u7684\u5b57\u6bb5\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            Assert.notEmpty((CharSequence)item.getValue(), (String)"\u6761\u4ef6\u7684\u503c\u4e0d\u5b58\u5728", (Object[])new Object[0]);
            selectBuilder.whereAnd(String.format("%s %s '%s'", item.getKey(), item.getRelation(), item.getValue()));
        });
        selectBuilder.limit(50, 0);
        return SQLUtils.toSQLString((SQLObject)selectBuilder.getSQLSelectStatement(), (DbType)dbType);
    }
}

