/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.tenet.logic.utils;

import com.hotent.base.core.common.exception.bean.BaseException;
import com.hotent.tenet.logic.model.LogicELNode;
import com.yomahub.liteflow.builder.el.ELBus;
import com.yomahub.liteflow.builder.el.ELWrapper;
import com.yomahub.liteflow.builder.el.SwitchELWrapper;
import com.yomahub.liteflow.builder.el.WhenELWrapper;
import java.util.ArrayList;

public class LiteFlowUtil {
    public static String toEL(LogicELNode node) {
        return LiteFlowUtil.toELWrapper(node).toEL();
    }

    public static ELWrapper toELWrapper(LogicELNode node) {
        switch (node.getType()) {
            case "THEN": {
                ArrayList wrappers = new ArrayList();
                node.getChildren().forEach(item -> wrappers.add(LiteFlowUtil.toELWrapper(item)));
                return ELBus.then((Object[])wrappers.toArray());
            }
            case "WHEN": {
                WhenELWrapper wrapper = ELBus.when((ELWrapper[])new ELWrapper[0]);
                node.getChildren().forEach(item -> wrapper.when(new Object[]{LiteFlowUtil.toELWrapper(item)}));
                return wrapper;
            }
            case "SWITCH": {
                LogicELNode condition = node.getCondition();
                SwitchELWrapper wrapper = ELBus.switchOpt((String)condition.getId());
                ArrayList wrappers = new ArrayList();
                node.getChildren().forEach(item -> wrappers.add(LiteFlowUtil.toELWrapper(item)));
                return wrapper.to(wrappers.toArray());
            }
            case "IF": {
                LogicELNode condition = node.getCondition();
                int children = node.getChildren().size();
                if (children == 1) {
                    return ELBus.ifOpt((String)condition.getId(), (Object)LiteFlowUtil.toELWrapper(node.getChildren().get(0)));
                }
                if (children == 2) {
                    return ELBus.ifOpt((String)condition.getId(), (Object)LiteFlowUtil.toELWrapper(node.getChildren().get(0)), (Object)LiteFlowUtil.toELWrapper(node.getChildren().get(1)));
                }
                throw new BaseException("\u6761\u4ef6\u8282\u70b9\u6ca1\u6761\u4ef6");
            }
            case "FOR": {
                LogicELNode condition = node.getCondition();
                LogicELNode children = node.getChildren().get(0);
                return ELBus.forOpt((String)condition.getId()).doOpt((Object)children);
            }
            case "WHILE": {
                LogicELNode condition = node.getCondition();
                LogicELNode children = node.getChildren().get(0);
                return ELBus.whileOpt((String)condition.getId()).doOpt((Object)children);
            }
        }
        return ELBus.node((String)node.getType()).tag(node.getId());
    }

    public static interface ELType {
        public static final String THEN = "THEN";
        public static final String WHEN = "WHEN";
        public static final String SWITCH = "SWITCH";
        public static final String IF = "IF";
        public static final String FOR = "FOR";
        public static final String WHILE = "WHILE";
    }
}

