/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.tenet.logic.utils;

import cn.hutool.core.util.StrUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeType;
import com.hotent.base.core.common.exception.bean.BaseException;
import com.hotent.base.core.utils.JsonUtil;
import java.io.IOException;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResultCheckUtil {
    public static String PREFIX = "$.";

    public static boolean matching(String data, String pathParam, boolean isRegex, String expectedValue) {
        boolean matchResult;
        Object targetValue = ResultCheckUtil.buildTargetValue(data, pathParam);
        if (targetValue == null) {
            return false;
        }
        if (targetValue instanceof JsonNode) {
            JsonNode jsonNode = (JsonNode)targetValue;
            JsonNodeType nodeType = jsonNode.getNodeType();
            if (nodeType == JsonNodeType.BOOLEAN) {
                targetValue = jsonNode.asBoolean();
            } else if (nodeType == JsonNodeType.STRING) {
                targetValue = jsonNode.asText();
            }
        }
        if (isRegex) {
            Pattern pattern = Pattern.compile(expectedValue);
            Matcher matcher = pattern.matcher(targetValue.toString());
            matchResult = matcher.find();
        } else {
            matchResult = Objects.equals(targetValue.toString(), expectedValue);
        }
        return matchResult;
    }

    public static Object buildTargetValue(String data, String pathParam) {
        JsonNode targetValue = null;
        if (StrUtil.isEmpty((CharSequence)pathParam) || !pathParam.startsWith(PREFIX)) {
            throw new BaseException("assert\u8fd4\u56de\u53c2\u6570Json\u8def\u5f84\u914d\u7f6e\u4e0d\u5408\u6cd5");
        }
        if (StrUtil.isEmpty((CharSequence)pathParam)) {
            return data;
        }
        String[] split = StrUtil.splitToArray((CharSequence)pathParam.substring(2), (CharSequence)".");
        JsonNode jsonNode = null;
        for (String property : split) {
            try {
                if (jsonNode == null) {
                    jsonNode = JsonUtil.toJsonNode((String)data);
                }
            }
            catch (IOException e) {
                throw new BaseException(StrUtil.format((CharSequence)"assert\u8fd4\u56de\u53c2\u6570Json\u89e3\u6790\u5931\u8d25", (Object[])new Object[0]));
            }
            if (!jsonNode.has(property)) {
                return null;
            }
            targetValue = jsonNode = jsonNode.get(property);
        }
        return targetValue;
    }
}

