/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.websocket.impl;

import com.hotent.base.util.AuthenticationUtil;
import com.hotent.base.util.time.TimeUtil;
import com.hotent.websocket.api.WebSocketServer;
import java.io.IOException;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@ServerEndpoint(value="/websocket/todo")
@Component
public class WebSocketServerImpl
implements WebSocketServer {
    protected static final Logger log = LoggerFactory.getLogger(WebSocketServerImpl.class);
    private static CopyOnWriteArraySet<WebSocketServerImpl> webSocketSet = new CopyOnWriteArraySet();
    private Session session;
    private String userId = "";

    @OnOpen
    public void onOpen(Session session) {
        this.userId = String.format("%s_%s", AuthenticationUtil.getCurrentUsername(), TimeUtil.getCurrentTimeMillis());
        this.session = session;
        webSocketSet.add(this);
        log.info("\u5efa\u7acbWebSocket\u8fde\u63a5\uff0cuserId\uff1a" + this.userId + "\uff0c\u5f53\u524d\u8fde\u63a5\u6570\uff1a" + webSocketSet.size());
    }

    @OnClose
    public void onClose() {
        webSocketSet.remove(this);
        log.info("\u5173\u95edWebSocket\u8fde\u63a5\uff0cuserId\uff1a" + this.userId + "\uff0c\u5f53\u524d\u8fde\u63a5\u6570\uff1a" + webSocketSet.size());
    }

    @OnMessage
    public void onMessage(String message, Session session) {
        log.info("\u6536\u5230\u6765[" + this.userId + "]\u7684\u4fe1\u606f:" + message);
    }

    @OnError
    public void onError(Session session, Throwable error) {
        log.error("websocket\u53d1\u751f\u9519\u8bef");
        error.printStackTrace();
    }

    private void sendMessage(String message) throws IOException {
        this.session.getBasicRemote().sendText(message);
    }

    @Override
    public void sendAll(String message) {
        log.info("\u63a8\u9001\u6d88\u606f\u5230" + this.userId + "\uff0c\u63a8\u9001\u5185\u5bb9:" + message);
        for (WebSocketServerImpl item : webSocketSet) {
            try {
                item.sendMessage(message);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void sendTo(String message, @PathParam(value="userId") String userId) {
        boolean isSend = false;
        for (WebSocketServerImpl item : webSocketSet) {
            try {
                if (!item.userId.equals(userId)) continue;
                log.info(String.format("%s--webSocket\u63a8\u9001\u7ed9\u7528\u6237\u3010%s\u3011\u5ba2\u6237\u7aef\u6d88\u606f:%s", TimeUtil.getCurrentTime(), userId, message));
                item.sendMessage(message);
                isSend = true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!isSend) {
            log.error(String.format("%s--webSocket\u672a\u63a8\u9001\u7ed9\u7528\u6237\u3010%s\u3011\u5ba2\u6237\u7aef\u6d88\u606f:%s", TimeUtil.getCurrentTime(), userId, message));
        }
    }

    @Override
    public void sendToUserAll(String message, @PathParam(value="userId") String userId) {
        boolean isSend = false;
        for (WebSocketServerImpl item : webSocketSet) {
            try {
                if (item.userId.indexOf(String.format("%s_", userId)) != 0) continue;
                log.info(String.format("%s--webSocket\u63a8\u9001\u7ed9\u7528\u6237\u3010%s\u3011\u3010%s\u3011\u5ba2\u6237\u7aef\u6d88\u606f:%s", TimeUtil.getCurrentTime(), item.userId, userId, message));
                item.sendMessage(message);
                isSend = true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        if (!isSend) {
            log.error(String.format("%s--webSocket\u672a\u63a8\u9001\u7ed9\u7528\u6237\u3010%s\u3011\u5ba2\u6237\u7aef\u6d88\u606f:%s", TimeUtil.getCurrentTime(), userId, message));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WebSocketServerImpl that = (WebSocketServerImpl)o;
        return Objects.equals(this.session, that.session) && Objects.equals(this.userId, that.userId);
    }

    public int hashCode() {
        return Objects.hash(this.session, this.userId);
    }
}

