/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.todo.controller;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.exception.BaseException;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.todo.model.Copy;
import com.hotent.todo.model.FlowInstance;
import com.hotent.todo.persistence.manager.CopyManager;
import com.hotent.todo.persistence.manager.FlowInstanceManager;
import com.hotent.todo.util.TodoUtil;
import com.hotent.todo.vo.CopyVo;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/todo/copy"})
@Api(tags={"\u6284\u9001\u4efb\u52a1"})
@ApiGroup(group={"group_todo"})
public class CopyController
extends BaseController<CopyManager, Copy> {
    @Resource
    CopyManager copyManager;
    @Resource
    private FlowInstanceManager flowInstanceManager;

    @PostMapping(value={"/queryCopyPage"})
    @ApiOperation(value="\u9001\u9605\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u6d41\u7a0b\u5b9e\u4f8b\u5217\u8868\uff08\u5206\u9875\uff09")
    public PageList<Copy> listCopy(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<Copy> queryFilter) throws Exception {
        queryFilter.addFilter("isDele", (Object)"0", QueryOP.EQUAL, FieldRelation.AND, "system");
        queryFilter.addFilter("status", (Object)"pending", QueryOP.EQUAL, FieldRelation.AND, "system");
        return this.copyManager.query(queryFilter);
    }

    @PostMapping(value={"/queryCopyDonePage"})
    @ApiOperation(value="\u5df2\u9605\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u6d41\u7a0b\u5b9e\u4f8b\u5217\u8868\uff08\u5206\u9875\uff09")
    public PageList<Copy> listCopyDone(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<Copy> queryFilter) throws Exception {
        queryFilter.addFilter("isDele", (Object)"0", QueryOP.EQUAL, FieldRelation.AND, "system");
        queryFilter.addFilter("status", (Object)"read", QueryOP.EQUAL, FieldRelation.AND, "system");
        return this.copyManager.query(queryFilter);
    }

    @PostMapping(value={"/queryPage"})
    @ApiOperation(value="\u5df2\u9605\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u6d41\u7a0b\u5b9e\u4f8b\u5217\u8868\uff08\u5206\u9875\uff09")
    public PageList<Copy> queryPage(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<Copy> queryFilter) throws Exception {
        queryFilter.addFilter("isDele", (Object)"0", QueryOP.EQUAL, FieldRelation.AND, "system");
        List<String> authSysCodes = TodoUtil.getAuthSystem();
        if (authSysCodes != null) {
            queryFilter.addFilter("SYSTEM_CODE_", authSysCodes, QueryOP.IN, FieldRelation.AND, "auth");
        }
        return ((CopyManager)this.baseService).query(queryFilter);
    }

    @PostMapping(value={"/front/queryPage"})
    @ApiOperation(value="\u5df2\u9605\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u6d41\u7a0b\u5b9e\u4f8b\u5217\u8868\uff08\u5206\u9875\uff09")
    public PageList<Copy> queryFrontPage(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<Copy> queryFilter) throws Exception {
        queryFilter.addFilter("isDele", (Object)"0", QueryOP.EQUAL, FieldRelation.AND, "system");
        IUser currentUser = ContextUtil.getCurrentUser();
        if (BeanUtils.isEmpty((Object)currentUser)) {
            return new PageList();
        }
        queryFilter.addFilter("callyReceiveNum", (Object)currentUser.getAccount(), QueryOP.EQUAL, FieldRelation.AND, "system");
        return ((CopyManager)this.baseService).query(queryFilter);
    }

    @PostMapping(value={"/toDone"})
    @ApiOperation(value="\u5f85\u529e\u8f6c\u5df2\u529e", httpMethod="POST", notes="\u5f85\u529e\u8f6c\u5df2\u529e")
    public CommonResult<String> task2Done(@RequestBody List<String> ids) {
        ((CopyManager)this.baseService).copyToDone(ids);
        return new CommonResult(true, "\u5f85\u9605\u8f6c\u5df2\u9605\u6210\u529f");
    }

    @PostMapping(value={"/mobile/myCopy"})
    @ApiOperation(value="\u5df2\u9605\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u6d41\u7a0b\u5b9e\u4f8b\u5217\u8868\uff08\u5206\u9875\uff09")
    public PageList<Copy> myCopy(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<Copy> queryFilter) throws Exception {
        queryFilter.addFilter("isDele", (Object)"0", QueryOP.EQUAL, FieldRelation.AND, "system");
        IUser currentUser = ContextUtil.getCurrentUser();
        if (BeanUtils.isEmpty((Object)currentUser)) {
            return new PageList();
        }
        queryFilter.addFilter("callyReceiveId", (Object)currentUser.getUserId(), QueryOP.EQUAL, FieldRelation.AND, "system");
        return ((CopyManager)this.baseService).query(queryFilter);
    }

    @PostMapping(value={"/ignoreLow"})
    @ApiOperation(value="\u5ffd\u7565\u4f4e\u6548\u7edf\u8ba1", httpMethod="POST", notes="\u6253\u5ffd\u7565\u4f4e\u6548\u7edf\u8ba1\u6807\u7b7e")
    public CommonResult<String> ignoreLow(@ApiParam(name="ids", value="\u4efb\u52a1\u4e3b\u952e(\u591a\u4e2a\u7528\u9017\u53f7\u5206\u9694)") @RequestParam String ids, @ApiParam(name="ignore", value="true\uff1a\u5ffd\u7565\uff0cfalse\uff1a\u5ffd\u7565") @RequestParam boolean ignore) {
        if (StringUtil.isNotEmpty((String)ids)) {
            ((CopyManager)this.baseService).ignoreLow(ids, ignore);
            return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
        }
        return new CommonResult(false, "\u672a\u4f20\u5165\u5ffd\u7565\u6570\u636eid");
    }

    @PostMapping(value={"/mobile/findPageCopy"})
    @ApiOperation(value="\u79fb\u52a8\u7aef-\u6d88\u606f\u5217\u8868", httpMethod="POST", notes="\u79fb\u52a8\u7aef-\u6d88\u606f\u5217\u8868")
    public CommonResult<PageList<CopyVo>> findPageCopy(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<Copy> queryFilter) throws Exception {
        PageList resultPage = new PageList();
        ArrayList voList = new ArrayList();
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL, FieldRelation.AND, "system");
        String account = Optional.ofNullable(ContextUtil.getCurrentUser()).map(IUser::getAccount).orElseThrow(() -> new BaseException("\u7528\u6237\u672a\u767b\u5f55"));
        this.getMobileQueryParams(queryFilter);
        queryFilter.addFilter("callyReceiveAccount", (Object)account, QueryOP.EQUAL, FieldRelation.AND, "system");
        PageList pageList = ((CopyManager)this.baseService).query(queryFilter);
        List rows = pageList.getRows();
        if (rows != null && rows.size() > 0) {
            Set<String> instanceIdSet = rows.stream().map(Copy::getInstanceId).collect(Collectors.toSet());
            Map<String, String> serialNumberMap = this.flowInstanceManager.findSerialNumber(instanceIdSet);
            rows.forEach(item -> {
                CopyVo copyVo = (CopyVo)BeanUtil.copyProperties((Object)item, CopyVo.class, (String[])new String[0]);
                String serialNumber = (String)serialNumberMap.get(copyVo.getInstanceId());
                copyVo.setSerialNumber(serialNumber);
                voList.add(copyVo);
            });
        }
        resultPage.setPage(pageList.getPage());
        resultPage.setRows(voList);
        resultPage.setTotal(pageList.getTotal());
        resultPage.setPageSize(pageList.getPageSize());
        return new CommonResult(true, "\u79fb\u52a8\u7aef-\u6d88\u606f\u5217\u8868", (Object)resultPage);
    }

    @GetMapping(value={"/getHomeCopy"})
    @ApiOperation(value="\u83b7\u53d6\u95e8\u6237\u9996\u9875\u6211\u7684\u6d88\u606f", httpMethod="GET", notes="\u83b7\u53d6\u95e8\u6237\u9996\u9875\u6211\u7684\u6d88\u606f")
    public List<Copy> getHomeCopy() {
        String account = ContextUtil.getCurrentUser().getAccount();
        LambdaQueryWrapper copyLambdaQueryWrapper = new LambdaQueryWrapper();
        copyLambdaQueryWrapper.eq(Copy::getCallyReceiveAccount, (Object)account);
        copyLambdaQueryWrapper.eq(Copy::getStatus, (Object)"pending");
        copyLambdaQueryWrapper.ne(Copy::getSystemCode, (Object)"dingtalk");
        copyLambdaQueryWrapper.orderByDesc(Copy::getTaskArriveDate);
        copyLambdaQueryWrapper.last("limit 0,3");
        return ((CopyManager)this.baseService).list((Wrapper)copyLambdaQueryWrapper);
    }

    private void getMobileQueryParams(QueryFilter<?> queryFilter) {
        List querys = queryFilter.getQuerys();
        if (querys != null && querys.size() > 0) {
            String keyword = ((QueryField)querys.get(0)).getValue().toString();
            String group = ((QueryField)querys.get(0)).getGroup();
            if (StringUtils.hasText((String)keyword)) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.lambda().like(FlowInstance::getSerialNumber, (Object)keyword);
                List list = this.flowInstanceManager.list((Wrapper)queryWrapper);
                List insIdList = list.stream().map(FlowInstance::getInstanceId).collect(Collectors.toList());
                if (insIdList.size() > 0) {
                    QueryField queryField = new QueryField();
                    queryField.setProperty("INSTANCE_ID_");
                    queryField.setOperation(QueryOP.IN);
                    queryField.setRelation(FieldRelation.OR);
                    queryField.setGroup(group);
                    queryField.setValue(insIdList);
                    queryFilter.addQueryField(queryField);
                }
            }
        }
    }
}

