/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.todo.controller;

import cn.hutool.core.bean.BeanUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.fasterxml.jackson.databind.JsonNode;
import com.hotent.base.annotation.ApiGroup;
import com.hotent.base.controller.BaseController;
import com.hotent.base.dao.CommonDao;
import com.hotent.base.entity.AutoFillModel;
import com.hotent.base.exception.BaseException;
import com.hotent.base.feign.dto.MobileProcessCountDto;
import com.hotent.base.jms.JmsProducer;
import com.hotent.base.model.CommonResult;
import com.hotent.base.query.Direction;
import com.hotent.base.query.FieldRelation;
import com.hotent.base.query.FieldSort;
import com.hotent.base.query.PageBean;
import com.hotent.base.query.PageList;
import com.hotent.base.query.QueryField;
import com.hotent.base.query.QueryFilter;
import com.hotent.base.query.QueryOP;
import com.hotent.base.util.AppUtil;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.StringUtil;
import com.hotent.base.vo.MobileProcessCountVo;
import com.hotent.todo.model.Copy;
import com.hotent.todo.model.FlowInstance;
import com.hotent.todo.model.Task;
import com.hotent.todo.model.TaskDone;
import com.hotent.todo.persistence.manager.CopyManager;
import com.hotent.todo.persistence.manager.FlowInstanceManager;
import com.hotent.todo.persistence.manager.TaskDoneManager;
import com.hotent.todo.persistence.manager.TaskManager;
import com.hotent.todo.service.WebSocketMessageService;
import com.hotent.todo.util.TodoUtil;
import com.hotent.todo.vo.MyApplyTaskVo;
import com.hotent.todo.vo.TaskVo;
import com.hotent.uc.api.impl.util.ContextUtil;
import com.hotent.uc.api.model.IUser;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/todo/task"})
@Api(tags={"\u5f85\u529e\u4efb\u52a1"})
@ApiGroup(group={"group_todo"})
public class TodoTaskController
extends BaseController<TaskManager, Task> {
    private static final Logger logger = LoggerFactory.getLogger(TodoTaskController.class);
    @Resource
    CommonDao commonDao;
    @Resource
    CopyManager copyManager;
    @Resource
    private FlowInstanceManager flowInstanceManager;
    @Resource
    TaskDoneManager taskDoneManager;
    @Resource
    JmsProducer jmsProducer;
    @Resource
    WebSocketMessageService webSocketMessageService;

    @PostMapping(value={"/queryPage"})
    @ApiOperation(value="\u6d41\u7a0b\u4efb\u52a1\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u6d41\u7a0b\u5b9e\u4f8b\u5217\u8868\uff08\u5206\u9875\uff09")
    public PageList<Task> list(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<Task> queryFilter) throws Exception {
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL, FieldRelation.AND, "is_dele");
        List<String> authSysCodes = TodoUtil.getAuthSystem();
        if (authSysCodes != null) {
            queryFilter.addFilter("SYSTEM_CODE_", authSysCodes, QueryOP.IN, FieldRelation.AND, "auth");
        }
        return ((TaskManager)this.baseService).query(queryFilter);
    }

    @PostMapping(value={"/front/queryPage"})
    @ApiOperation(value="\u6d41\u7a0b\u4efb\u52a1\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u6d41\u7a0b\u5b9e\u4f8b\u5217\u8868\uff08\u5206\u9875\uff09")
    public PageList<Task> queryFrontPage(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<Task> queryFilter, @ApiParam(name="flowDicKey", value="\u603b\u88c1\u95e8\u6237\u680f\u76ee\u5b57\u5178key") @RequestParam Optional<String> flowDicKey, @ApiParam(name="initOa", value="\u662f\u5426\u521d\u59cb\u5316oa\u8865\u507f\u5f85\u529e") @RequestParam Optional<Boolean> initOa) throws Exception {
        queryFilter.addFilter("isDele", (Object)"0", QueryOP.EQUAL, FieldRelation.AND, "is_dele");
        IUser currentUser = ContextUtil.getCurrentUser();
        if (BeanUtils.isEmpty((Object)currentUser)) {
            PageList page = new PageList();
            page.setRows(new ArrayList());
            return page;
        }
        queryFilter.addFilter("taskApproveAccount", (Object)currentUser.getAccount(), QueryOP.EQUAL, FieldRelation.AND, "is_dele");
        queryFilter.addParams("taskApproveAccount", (Object)currentUser.getAccount());
        String dicKey = flowDicKey.orElse("");
        if (StringUtil.isNotEmpty((String)dicKey)) {
            List<String> flowKeys = this.getFlowKeyByDicKey(dicKey);
            if (BeanUtils.isNotEmpty(flowKeys)) {
                queryFilter.addFilter("businessTypeId", flowKeys, QueryOP.IN, FieldRelation.AND, "senior");
            } else {
                PageList page = new PageList();
                page.setRows(new ArrayList());
                return page;
            }
        }
        return ((TaskManager)this.baseService).queryPageList(queryFilter, initOa.orElse(false));
    }

    private List<String> getFlowKeyByDicKey(String flowDicKey) {
        String dicSql = String.format("select GROUP_CONCAT(dic.KEY_) as 'flowKeys' from portal_sys_dic dic LEFT JOIN portal_sys_type type ON dic.TYPE_ID_=type.ID_ AND type.TYPE_GROUP_KEY_='DIC' where type.TYPE_KEY_='%s'", flowDicKey);
        HashMap<String, String> dicMap = new HashMap<String, String>();
        dicMap.put("sql", dicSql);
        List list = this.commonDao.query(dicMap);
        if (BeanUtils.isNotEmpty((Object)list)) {
            try {
                String flowKeys = (String)((Map)list.get(0)).get("flowKeys");
                if (StringUtil.isNotEmpty((String)flowKeys)) {
                    ArrayList<String> flowKeyList = new ArrayList<String>();
                    flowKeyList.addAll(Arrays.asList(flowKeys.split(",")));
                    String likes = StringUtil.convertListToSingleQuotesString(new HashSet(flowKeyList));
                    String flowSql = String.format("select DISTINCT detail.FLOW_CODE_ as 'flowCode' from todo_common_flow_detail detail LEFT JOIN todo_common_flow flow on detail.REF_ID_=flow.ID_ where flow.FLOW_CODE_ in(%s)", likes);
                    HashMap<String, String> flowMap = new HashMap<String, String>();
                    flowMap.put("sql", flowSql);
                    List commonFlowlist = this.commonDao.query(flowMap);
                    if (BeanUtils.isNotEmpty((Object)commonFlowlist)) {
                        for (Map map : commonFlowlist) {
                            if (!BeanUtils.isNotEmpty(map.get("flowCode"))) continue;
                            flowKeyList.add(map.get("flowCode").toString());
                        }
                    }
                    return flowKeyList;
                }
            }
            catch (Exception e) {
                logger.error("\u603b\u88c1\u680f\u76ee\u83b7\u53d6\u5b57\u5178\u6570\u636e\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
        return null;
    }

    @PostMapping(value={"/toDone"})
    @ApiOperation(value="\u5f85\u529e\u8f6c\u5df2\u529e", httpMethod="POST", notes="\u5f85\u529e\u8f6c\u5df2\u529e")
    public CommonResult<String> task2Done(@RequestBody List<String> ids, @ApiParam(name="type", value="\u7c7b\u578b\uff1aself\uff08\u7528\u6237\u81ea\u5df1\uff09") @RequestParam Optional<String> type) {
        ((TaskManager)this.baseService).task2Done(ids, false, type.orElse(""));
        return new CommonResult(true, "\u5f85\u529e\u8f6c\u5df2\u529e\u6210\u529f");
    }

    @PostMapping(value={"/mobile/myTask"})
    @ApiOperation(value="\u6d41\u7a0b\u4efb\u52a1\u6570\u636e\u5217\u8868", httpMethod="POST", notes="\u6d41\u7a0b\u5b9e\u4f8b\u5217\u8868\uff08\u5206\u9875\uff09")
    public PageList<Task> myTask(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<Task> queryFilter, @ApiParam(name="initOa", value="\u662f\u5426\u521d\u59cb\u5316oa\u8865\u507f\u5f85\u529e") @RequestParam Optional<Boolean> initOa, @ApiParam(name="ignoreOa", value="\u5ffd\u7565Oa\u5f85\u529e") @RequestParam Optional<Boolean> ignoreOa) throws Exception {
        IUser currentUser;
        queryFilter.addFilter("isDele", (Object)"0", QueryOP.EQUAL, FieldRelation.AND, "is_dele");
        if (ignoreOa.orElse(false).booleanValue()) {
            queryFilter.addFilter("systemCode", (Object)"oa", QueryOP.NOT_EQUAL, FieldRelation.AND, "ignoreOa");
        }
        if (BeanUtils.isEmpty((Object)(currentUser = ContextUtil.getCurrentUser()))) {
            return new PageList();
        }
        queryFilter.addFilter("taskApproveId", (Object)currentUser.getUserId(), QueryOP.EQUAL, FieldRelation.AND, "is_dele");
        return ((TaskManager)this.baseService).queryPageList(queryFilter, initOa.orElse(false));
    }

    @PostMapping(value={"/mobile/findPageTask"})
    @ApiOperation(value="\u79fb\u52a8\u7aef-\u5f85\u529e\u5217\u8868", httpMethod="POST", notes="\u6d41\u7a0b\u5b9e\u4f8b\u5217\u8868\uff08\u5206\u9875\uff09")
    public CommonResult<List<TaskVo>> findPageTask(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<Task> queryFilter, @ApiParam(name="initOa", value="\u662f\u5426\u521d\u59cb\u5316oa\u8865\u507f\u5f85\u529e") @RequestParam Optional<Boolean> initOa, @ApiParam(name="ignoreOa", value="\u5ffd\u7565Oa\u5f85\u529e") @RequestParam Optional<Boolean> ignoreOa) throws Exception {
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL, FieldRelation.AND, "is_dele");
        if (ignoreOa.orElse(false).booleanValue()) {
            queryFilter.addFilter("systemCode", (Object)"oa", QueryOP.NOT_EQUAL, FieldRelation.AND, "ignoreOa");
        }
        IUser user = Optional.ofNullable(ContextUtil.getCurrentUser()).orElseThrow(() -> new BaseException("\u7528\u6237\u672a\u767b\u5f55"));
        String account = user.getAccount();
        List querys = queryFilter.getQuerys();
        String title = "";
        if (querys != null && querys.size() > 0) {
            title = ((QueryField)querys.get(0)).getValue().toString();
        }
        List sorter = queryFilter.getSorter();
        Comparator<TaskVo> comparing = Comparator.comparing(AutoFillModel::getCreateTime, Comparator.nullsLast(LocalDateTime::compareTo)).reversed();
        if (sorter != null && sorter.size() > 0 && ((FieldSort)sorter.get(0)).getDirection() == Direction.ASC) {
            comparing = Comparator.comparing(AutoFillModel::getCreateTime, Comparator.nullsLast(LocalDateTime::compareTo));
        }
        queryFilter.addFilter("taskApproveAccount", (Object)account, QueryOP.EQUAL, FieldRelation.AND, "is_dele");
        queryFilter.addParams("taskApproveAccount", (Object)account);
        queryFilter.setPageBean(new PageBean(PageBean.WITHOUT_PAGE, Integer.valueOf(50000)));
        PageList<Task> taskPageList = ((TaskManager)this.baseService).queryPageList(queryFilter, initOa.orElse(false));
        ArrayList tempList = new ArrayList();
        List rows = taskPageList.getRows();
        if (rows != null && rows.size() > 0) {
            Set<String> instanceIdSet = rows.stream().map(Task::getInstanceId).collect(Collectors.toSet());
            Map<String, String> serialNumberMap = this.flowInstanceManager.findSerialNumber(instanceIdSet);
            taskPageList.getRows().forEach(item -> {
                TaskVo taskVo = (TaskVo)BeanUtil.copyProperties((Object)item, TaskVo.class, (String[])new String[0]);
                String serialNumber = (String)serialNumberMap.get(taskVo.getInstanceId());
                taskVo.setSerialNumber(serialNumber);
                tempList.add(taskVo);
            });
        }
        List voList = tempList.stream().sorted(comparing).collect(Collectors.toList());
        return new CommonResult(true, "\u79fb\u52a8\u7aef-\u4ee3\u529e\u5217\u8868", voList);
    }

    @GetMapping(value={"/mobile/myTaskCount"})
    @ApiOperation(value="\u6d41\u7a0b\u4efb\u52a1\u6570\u91cf", httpMethod="GET", notes="\u6d41\u7a0b\u4efb\u52a1\u6570\u91cf")
    public CommonResult<Integer> myTaskCount(@ApiParam(name="ignoreOa", value="\u5ffd\u7565Oa\u5f85\u529e") @RequestParam Optional<Boolean> ignoreOa) throws Exception {
        IUser currentUser;
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("isDele", (Object)"0", QueryOP.EQUAL, FieldRelation.AND, "is_dele");
        if (ignoreOa.orElse(false).booleanValue()) {
            queryFilter.addFilter("systemCode", (Object)"oa", QueryOP.NOT_EQUAL, FieldRelation.AND, "ignoreOa");
        }
        if (BeanUtils.isEmpty((Object)(currentUser = ContextUtil.getCurrentUser()))) {
            return new CommonResult(true, "\u6d41\u7a0b\u4efb\u52a1\u6570\u91cf", (Object)0);
        }
        queryFilter.addFilter("taskApproveId", (Object)currentUser.getUserId(), QueryOP.EQUAL, FieldRelation.AND, "is_dele");
        Integer myTaskCount = ((TaskManager)this.baseService).queryMyTaskCount((QueryFilter<Task>)queryFilter);
        return new CommonResult(true, "\u6d41\u7a0b\u4efb\u52a1\u6570\u91cf", (Object)myTaskCount);
    }

    @GetMapping(value={"/mobile/findTaskCount"})
    @ApiOperation(value="\u6d41\u7a0b\u4efb\u52a1\u6570\u91cf", httpMethod="GET", notes="\u6d41\u7a0b\u4efb\u52a1\u6570\u91cf")
    public CommonResult<MobileProcessCountVo> findTaskCount() throws Exception {
        MobileProcessCountVo mobileProcessCountVo = new MobileProcessCountVo();
        QueryFilter queryFilter = QueryFilter.build();
        queryFilter.addFilter("IS_DELE_", (Object)"0", QueryOP.EQUAL, FieldRelation.AND, "is_dele");
        Optional<IUser> currentUser = Optional.ofNullable(ContextUtil.getCurrentUser());
        String account = currentUser.map(IUser::getAccount).orElseThrow(() -> new BaseException("\u7528\u6237\u672a\u767b\u5f55"));
        queryFilter.addFilter("taskApproveAccount", (Object)account, QueryOP.EQUAL, FieldRelation.AND, "is_dele");
        int taskCount = Optional.ofNullable(((TaskManager)this.baseService).queryMyTaskCount((QueryFilter<Task>)queryFilter)).orElse(0);
        int copyCount = Optional.ofNullable(this.copyManager.findMyTaskCount(account)).orElse(0);
        mobileProcessCountVo.setAgencyCount(Integer.valueOf(taskCount));
        mobileProcessCountVo.setCopyCount(Integer.valueOf(copyCount));
        return new CommonResult(true, "\u6d41\u7a0b\u4efb\u52a1\u6570\u91cf", (Object)mobileProcessCountVo);
    }

    @PostMapping(value={"/remove"})
    @ApiOperation(value="\u5f85\u529e\u5220\u9664", httpMethod="POST", notes="\u5f85\u529e\u5220\u9664")
    public CommonResult<String> remove(@RequestBody List<String> ids) {
        ((TaskManager)this.baseService).removeByIds(ids);
        return new CommonResult(true, "\u5f85\u529e\u5220\u9664\u6210\u529f");
    }

    @PostMapping(value={"/ignoreLow"})
    @ApiOperation(value="\u5ffd\u7565\u4f4e\u6548\u7edf\u8ba1", httpMethod="POST", notes="\u6253\u5ffd\u7565\u4f4e\u6548\u7edf\u8ba1\u6807\u7b7e")
    public CommonResult<String> ignoreLow(@ApiParam(name="modifReason", value="\u539f\u56e0\u5bf9\u8c61") @RequestBody String modifReason, @ApiParam(name="ids", value="\u4efb\u52a1\u4e3b\u952e(\u591a\u4e2a\u7528\u9017\u53f7\u5206\u9694)") @RequestParam String ids, @ApiParam(name="ignore", value="true\uff1a\u5ffd\u7565\uff0cfalse\uff1a\u5ffd\u7565") @RequestParam boolean ignore) {
        if (StringUtil.isNotEmpty((String)ids)) {
            ((TaskManager)this.baseService).ignoreLow(ids, ignore, modifReason);
            return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
        }
        return new CommonResult(false, "\u672a\u4f20\u5165\u5ffd\u7565\u6570\u636eid");
    }

    @PostMapping(value={"/test"})
    @ApiOperation(value="\u83b7\u53d6\u5f85\u529e\u4efb\u52a1\u5206\u7c7b\u6811", httpMethod="POST", notes="\u83b7\u53d6\u5f85\u529e\u4efb\u52a1\u5206\u7c7b\u6811")
    public void test(@ApiParam(name="topicName", value="topic\u540d\u79f0") @RequestParam String topicName, @RequestBody JsonNode node) throws Exception {
        this.webSocketMessageService.sendToWebSocketMessage("todo", "admin");
    }

    @GetMapping(value={"/findCountByUser"})
    @ApiOperation(value="\u83b7\u53d6\u6d41\u7a0b\u4efb\u52a1\u6570\u91cf", httpMethod="GET", notes="\u83b7\u53d6\u6d41\u7a0b\u4efb\u52a1\u6570\u91cf")
    public MobileProcessCountDto findCountByUser() {
        String account = Optional.ofNullable(ContextUtil.getCurrentUser()).map(IUser::getAccount).orElseThrow(() -> new BaseException("\u7528\u6237\u672a\u767b\u5f55"));
        return ((TaskManager)this.baseService).findCountByUser(account);
    }

    @PostMapping(value={"/mobile/findPageApply"})
    @ApiOperation(value="\u6211\u7684\u7533\u8bf7\u5217\u8868", httpMethod="POST", notes="\u6211\u7684\u7533\u8bf7\u5217\u8868")
    public CommonResult<PageList<MyApplyTaskVo>> findPageApply(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<Task> queryFilter) {
        PageList<FlowInstance> pageList;
        List rows;
        PageList resultPage = new PageList();
        ArrayList resultList = new ArrayList();
        String account = Optional.ofNullable(ContextUtil.getCurrentUser()).map(IUser::getAccount).orElseThrow(() -> new BaseException("\u7528\u6237\u672a\u767b\u5f55"));
        QueryFilter instanceFilter = QueryFilter.build();
        instanceFilter.setPageBean(queryFilter.getPageBean());
        instanceFilter.setSorter(queryFilter.getSorter());
        instanceFilter.addFilter("OWER_ACCOUNT_", (Object)account, QueryOP.EQUAL, FieldRelation.AND, account);
        if (queryFilter.getQuerys() != null && queryFilter.getQuerys().size() > 0) {
            QueryField queryField = (QueryField)queryFilter.getQuerys().get(0);
            String value = (String)queryField.getValue();
            instanceFilter.addFilter("TITLE_", (Object)value, QueryOP.LIKE, FieldRelation.OR);
            instanceFilter.addFilter("SERIAL_NUMBER_", (Object)value, QueryOP.LIKE, FieldRelation.OR);
            instanceFilter.addFilter("OWER_NAME_", (Object)value, QueryOP.LIKE, FieldRelation.OR);
        }
        if ((rows = (pageList = this.flowInstanceManager.queryMobilePage((QueryFilter<FlowInstance>)instanceFilter)).getRows()) != null && rows.size() > 0) {
            rows.forEach(item -> {
                String serialNumber = item.getSerialNumber();
                String systemCode = item.getSystemCode();
                String flowStatus = item.getFlowStatus();
                MyApplyTaskVo myApplyTaskVo = new MyApplyTaskVo();
                myApplyTaskVo.setTitle(item.getTitle());
                myApplyTaskVo.setCreateTime(item.getCreateTime());
                myApplyTaskVo.setTaskStartName(item.getOwerName());
                myApplyTaskVo.setSystemCode(item.getSystemCode());
                myApplyTaskVo.setId(item.getId());
                myApplyTaskVo.setSerialNumber(serialNumber);
                myApplyTaskVo.setMobileTaskUrl(item.getMobileTaskUrl());
                String state = "1";
                if ("complete".equals(flowStatus)) {
                    state = "0";
                    myApplyTaskVo.setResult(item.getResult());
                    if ("bpm".equals(systemCode)) {
                        // empty if block
                    }
                } else if ("approving".equals(flowStatus)) {
                    state = "1";
                    List list = ((TaskManager)this.baseService).list((Wrapper)new QueryWrapper().lambda().eq(Task::getInstanceId, (Object)serialNumber));
                    if (list != null && list.size() > 0) {
                        String taskApproveName = ((Task)((Object)((Object)list.get(0)))).getTaskApproveName();
                        myApplyTaskVo.setTaskApproveNum(taskApproveName);
                    }
                } else if ("draft".equals(flowStatus)) {
                    state = "2";
                }
                myApplyTaskVo.setState(state);
                resultList.add(myApplyTaskVo);
            });
        }
        resultPage.setPage(pageList.getPage());
        resultPage.setPageSize(pageList.getPageSize());
        resultPage.setTotal(pageList.getTotal());
        resultPage.setRows(resultList);
        return new CommonResult(true, "\u6211\u7684\u7533\u8bf7\u5217\u8868", (Object)resultPage);
    }

    @GetMapping(value={"/getFlowMsgBox"})
    @ApiOperation(value="\u83b7\u53d6\u95e8\u6237\u9996\u9875\u6d41\u7a0b\u76f8\u5173\u6570\u91cf", httpMethod="GET", notes="\u83b7\u53d6\u95e8\u6237\u9996\u9875\u6d41\u7a0b\u76f8\u5173\u6570\u91cf")
    public Map<String, Object> getFlowMsgBox() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String account = ContextUtil.getCurrentUser().getAccount();
        LambdaQueryWrapper taskQueryWrapper = new LambdaQueryWrapper();
        taskQueryWrapper.eq(Task::getTaskApproveAccount, (Object)account);
        taskQueryWrapper.ne(Task::getSystemCode, (Object)"dingtalk");
        int taskCount = ((TaskManager)this.baseService).count((Wrapper)taskQueryWrapper);
        map.put("taskCount", taskCount);
        LambdaQueryWrapper copyLambdaQueryWrapper = new LambdaQueryWrapper();
        copyLambdaQueryWrapper.eq(Copy::getCallyReceiveAccount, (Object)account);
        copyLambdaQueryWrapper.eq(Copy::getStatus, (Object)"pending");
        copyLambdaQueryWrapper.ne(Copy::getSystemCode, (Object)"dingtalk");
        int copyCount = this.copyManager.count((Wrapper)copyLambdaQueryWrapper);
        map.put("copyCount", copyCount);
        FlowInstanceManager flowInstanceManager = (FlowInstanceManager)AppUtil.getBean(FlowInstanceManager.class);
        LambdaQueryWrapper flowInstanceLambdaQueryWrapper = new LambdaQueryWrapper();
        flowInstanceLambdaQueryWrapper.eq(FlowInstance::getOwerAccount, (Object)account);
        flowInstanceLambdaQueryWrapper.ne(FlowInstance::getSystemCode, (Object)"dingtalk");
        int myApplicationCount = flowInstanceManager.count((Wrapper)flowInstanceLambdaQueryWrapper);
        map.put("myApplicationCount", myApplicationCount);
        return map;
    }

    @GetMapping(value={"/getHomeTask"})
    @ApiOperation(value="\u83b7\u53d6\u95e8\u6237\u9996\u9875\u6211\u7684\u5f85\u529e", httpMethod="GET", notes="\u83b7\u53d6\u95e8\u6237\u9996\u9875\u6211\u7684\u5f85\u529e")
    public List<Task> getHomeTask(@ApiParam(name="pageSize", value="\u8fd4\u56de\u591a\u5c11\u6761 \u9ed8\u8ba4\u8fd4\u56de\u5168\u90e8") @RequestParam Optional<String> pageSize) {
        LambdaQueryWrapper taskQueryWrapper = new LambdaQueryWrapper();
        String account = ContextUtil.getCurrentUser().getAccount();
        taskQueryWrapper.eq(Task::getTaskApproveAccount, (Object)account);
        taskQueryWrapper.orderByDesc(Task::getTaskArriveDate);
        taskQueryWrapper.ne(Task::getSystemCode, (Object)"dingtalk");
        if (StringUtil.isNotEmpty((String)pageSize.orElse(""))) {
            taskQueryWrapper.last("limit 0," + pageSize.get());
        }
        return ((TaskManager)this.baseService).list((Wrapper)taskQueryWrapper);
    }

    @PostMapping(value={"/pc/queryTask"})
    @ApiOperation(value="PC\u7aef\u6211\u7684\u5f85\u529e", httpMethod="POST", notes="PC\u7aef\u6211\u7684\u5f85\u529e\uff08\u5206\u9875\uff09")
    public PageList<Task> queryTask(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<Task> queryFilter) throws Exception {
        IUser currentUser = ContextUtil.getCurrentUser();
        if (BeanUtils.isEmpty((Object)currentUser)) {
            return new PageList();
        }
        queryFilter.addFilter("taskApproveAccount", (Object)currentUser.getAccount(), QueryOP.EQUAL);
        queryFilter.addFilter("systemCode", (Object)"dingtalk", QueryOP.NOT_EQUAL);
        return ((TaskManager)this.baseService).query(queryFilter);
    }

    @PostMapping(value={"/pc/queryTaskTodo"})
    @ApiOperation(value="PC\u7aef\u6211\u7684\u5df2\u529e", httpMethod="POST", notes="PC\u7aef\u6211\u7684\u5df2\u529e\uff08\u5206\u9875\uff09")
    public PageList<TaskDone> queryTaskTodo(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<TaskDone> queryFilter) throws Exception {
        IUser currentUser = ContextUtil.getCurrentUser();
        if (BeanUtils.isEmpty((Object)currentUser)) {
            return new PageList();
        }
        queryFilter.addFilter("taskApproveAccount", (Object)currentUser.getAccount(), QueryOP.EQUAL);
        queryFilter.addFilter("systemCode", (Object)"dingtalk", QueryOP.NOT_EQUAL);
        return this.taskDoneManager.query(queryFilter);
    }

    @PostMapping(value={"/pc/queryFlowInstance"})
    @ApiOperation(value="PC\u7aef\u6211\u7684\u7533\u8bf7", httpMethod="POST", notes="PC\u7aef\u6211\u7684\u7533\u8bf7\uff08\u5206\u9875\uff09")
    public PageList<FlowInstance> queryFlowInstance(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<FlowInstance> queryFilter) throws Exception {
        IUser currentUser = ContextUtil.getCurrentUser();
        if (BeanUtils.isEmpty((Object)currentUser)) {
            return new PageList();
        }
        queryFilter.addFilter("OWER_ACCOUNT_", (Object)currentUser.getAccount(), QueryOP.EQUAL);
        queryFilter.addFilter("SYSTEM_CODE_", (Object)"dingtalk", QueryOP.NOT_EQUAL);
        return this.flowInstanceManager.query(queryFilter);
    }

    @PostMapping(value={"/pc/queryMyStartCopy"})
    @ApiOperation(value="PC\u7aef\u6211\u53d1\u8d77\u7684\u6284\u9001", httpMethod="POST", notes="PC\u7aef\u6211\u53d1\u8d77\u7684\u6284\u9001\uff08\u5206\u9875\uff09")
    public PageList<Copy> queryStartCopy(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<Copy> queryFilter) throws Exception {
        IUser currentUser = ContextUtil.getCurrentUser();
        if (BeanUtils.isEmpty((Object)currentUser)) {
            return new PageList();
        }
        queryFilter.addFilter("CALLY_START_ACCOUNT_", (Object)currentUser.getAccount(), QueryOP.EQUAL);
        queryFilter.addFilter("SYSTEM_CODE_", (Object)"dingtalk", QueryOP.NOT_EQUAL);
        return this.copyManager.query(queryFilter);
    }

    @PostMapping(value={"/pc/queryMyCopy"})
    @ApiOperation(value="PC\u7aef\u6211\u6536\u5230\u7684\u7684\u6284\u9001", httpMethod="POST", notes="PC\u7aef\u6211\u6536\u5230\u7684\u7684\u6284\u9001\uff08\u5206\u9875\uff09")
    public PageList<Copy> queryMyCopy(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<Copy> queryFilter) throws Exception {
        IUser currentUser = ContextUtil.getCurrentUser();
        if (BeanUtils.isEmpty((Object)currentUser)) {
            return new PageList();
        }
        queryFilter.addFilter("CALLY_RECEIVE_ACCOUNT_", (Object)currentUser.getAccount(), QueryOP.EQUAL);
        queryFilter.addFilter("SYSTEM_CODE_", (Object)"dingtalk", QueryOP.NOT_EQUAL);
        return this.copyManager.query(queryFilter);
    }
}

