/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.todo.handler.impl;

import com.hotent.base.util.StringUtil;
import com.hotent.todo.exception.MessageShouldRetryException;
import com.hotent.todo.handler.MessageHandler;
import com.hotent.todo.handler.TodoMessageType;
import com.hotent.todo.handler.impl.AbstractMessageHandler;
import com.hotent.todo.model.AccessSystem;
import com.hotent.todo.model.FlowInstance;
import com.hotent.todo.model.Task;
import com.hotent.todo.model.TaskDone;
import com.hotent.todo.persistence.manager.TaskDoneManager;
import com.hotent.todo.persistence.manager.TaskManager;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class TaskToDoneMessageHandler
extends AbstractMessageHandler<TaskDone>
implements MessageHandler {
    @Resource
    TaskDoneManager taskDoneManager;
    @Resource
    TaskManager taskManager;
    @Value(value="${dingTalk.corpId:ding86fe8ae26d0e3eee35c2f4657eb6378f}")
    private String dingTalkCorpId;

    @Override
    public String getType() {
        return TodoMessageType.TASK_TO_DONE.key();
    }

    @Override
    public void doHandler(TaskDone entity, AccessSystem accessSystem) {
        if (StringUtil.isNotEmpty((String)entity.getInstanceId())) {
            FlowInstance flowInstance = this.isFlowInstanceExist(entity.getSystemCode(), entity.getInstanceId());
            entity.setTitle(flowInstance.getTitle());
        }
        entity.setSystemName(accessSystem.getSystemName());
        List<Task> taskList = this.taskManager.getByTaskId(entity.getSystemCode(), entity.getTaskId());
        if (taskList.isEmpty()) {
            throw new MessageShouldRetryException(String.format("systemCode\u4e3a%s\uff0ctaskId\u4e3a%s\u7684\u4efb\u52a1\u4e0d\u5b58\u5728", entity.getSystemCode(), entity.getTaskId()));
        }
        for (int i = 0; i < taskList.size(); ++i) {
            Task task = taskList.get(i);
            if (task.getTaskApproveAccount().equals(entity.getTaskApproveAccount())) {
                entity.setFrom(accessSystem.getFrom());
                this.taskDoneManager.taskToDone(entity, task);
                continue;
            }
            this.taskManager.remove((Serializable)((Object)task.getId()));
        }
    }
}

