/*
 * Decompiled with CFR 0.152.
 */
package com.hotent.todo.msg.persistence.manager.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.hotent.base.exception.BaseException;
import com.hotent.base.manager.impl.BaseManagerImpl;
import com.hotent.base.util.BeanUtils;
import com.hotent.base.util.JsonUtil;
import com.hotent.base.util.StringUtil;
import com.hotent.todo.constants.MessageType;
import com.hotent.todo.model.MsgCenterLog;
import com.hotent.todo.msg.persistence.dao.MsgCenterLogMapper;
import com.hotent.todo.msg.persistence.manager.IMsgCenterLogService;
import com.hotent.todo.msg.service.TodoMessageService;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class MsgCenterLogServiceImpl
extends BaseManagerImpl<MsgCenterLogMapper, MsgCenterLog>
implements IMsgCenterLogService {
    @Resource
    TodoMessageService messageService;
    @Resource(name="asyncExecutor")
    Executor executorService;

    @Override
    public void revoke(List<String> ids, boolean isMq) {
        ids.forEach(id -> {
            MsgCenterLog log = (MsgCenterLog)this.get((Serializable)((Object)id));
            if (BeanUtils.isEmpty((Object)((Object)log))) {
                throw new BaseException("\u672a\u627e\u5230\u8be5\u65e5\u5fd7");
            }
            if (log.getRetries() < 3 || !isMq) {
                try {
                    MessageType type = MessageType.valueOf(log.getType().toUpperCase());
                    Map vars = (Map)JsonUtil.toBean((String)log.getVars(), Map.class);
                    String msgId = this.messageService.sendMessage(type, log.getDestination(), log.getTemplateId(), (Map<String, String>)vars, false);
                    if (StringUtil.isNotEmpty((String)msgId)) {
                        // empty if block
                    }
                    UpdateWrapper updateWrapper = new UpdateWrapper();
                    updateWrapper.eq((Object)"id_", id);
                    int retries = log.getRetries() + 1;
                    updateWrapper.set((Object)"MSG_ID_", (Object)msgId);
                    updateWrapper.set((Object)"state_", (Object)1);
                    updateWrapper.set((Object)"RETRIES_", (Object)retries);
                    ((MsgCenterLogMapper)this.baseMapper).update(null, (Wrapper)updateWrapper);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    throw new BaseException((Throwable)e);
                }
            }
        });
    }

    @Override
    public void confirmOk(String msgId) {
    }
}

